/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.void_stone;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TabElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.void_stone.Tab;
import iskallia.vault.client.gui.screen.void_stone.elements.ScrollableItemListElement;
import iskallia.vault.client.gui.screen.void_stone.elements.ThemeListElement;
import iskallia.vault.container.VoidCrucibleContainer;
import iskallia.vault.core.data.key.NamedKey;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ServerboundUpdateBlacklistMessage;
import iskallia.vault.network.message.ServerboundVoidCrucibleTabMessage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class VoidCrucibleScreen<T extends VoidCrucibleContainer>
extends AbstractElementContainerScreen<T> {
    protected VoidStoneCrucibleTab selectedTab = VoidStoneCrucibleTab.BLACKLIST;

    public VoidCrucibleScreen(T container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 222));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 0).size(this.getGuiSpatial().width(), this.getGuiSpatial().height()), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        this.addTabs();
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)new TextComponent("Void Crucible").m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    public abstract VoidStoneCrucibleTab getSelectedTab();

    protected void addTabs() {
        for (VoidStoneCrucibleTab tab : VoidStoneCrucibleTab.values()) {
            this.addElement(VoidCrucibleScreen.createTab(tab == this.getSelectedTab(), tab.getIcon(), 5 + 30 * tab.ordinal(), () -> {
                if (tab == this.getSelectedTab()) {
                    return;
                }
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundVoidCrucibleTabMessage(tab.getTab(), ((VoidCrucibleContainer)this.m_6262_()).getPos()));
                this.selectedTab = tab;
            }));
        }
    }

    private static TabElement<?> createTab(boolean selected, TextureAtlasRegion icon, int y, Runnable onClick) {
        return (TabElement)new TabElement(Spatials.positionXYZ(selected ? -28 : -24, y, 1), new TextureAtlasElement(selected ? ScreenTextures.TAB_BACKGROUND_LEFT_SELECTED : ScreenTextures.TAB_BACKGROUND_LEFT), new TextureAtlasElement(Spatials.positionXYZ(selected ? 9 : 5, 6, 1), icon), onClick).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
    }

    public boolean m_7043_() {
        return false;
    }

    @NotNull
    protected ILayoutStrategy positionGuiSpatial() {
        return (screen, gui, parent, world) -> world.positionXY(gui);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public static enum VoidStoneCrucibleTab {
        THEME_SELECT(ScreenTextures.TAB_ICON_CRYSTAL, Tab.THEME),
        BLACKLIST(ScreenTextures.TAB_ICON_BLACKLIST, Tab.BLACKLIST);

        private final TextureAtlasRegion icon;
        private final Tab tab;

        private VoidStoneCrucibleTab(TextureAtlasRegion icon, Tab tab) {
            this.icon = icon;
            this.tab = tab;
        }

        public TextureAtlasRegion getIcon() {
            return this.icon;
        }

        public Tab getTab() {
            return this.tab;
        }

        public boolean isTab(Tab tab) {
            return this.tab == tab;
        }
    }

    public static class Blacklist
    extends VoidCrucibleScreen<VoidCrucibleContainer.Blacklist> {
        public Blacklist(VoidCrucibleContainer.Blacklist container, Inventory inv, Component titleIn) {
            super(container, inv, titleIn);
            this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout(this.translateWorldSpatial()));
        }

        @Override
        public VoidStoneCrucibleTab getSelectedTab() {
            return VoidStoneCrucibleTab.BLACKLIST;
        }
    }

    public static class ThemeSelect
    extends VoidCrucibleScreen<VoidCrucibleContainer.ThemeSelect> {
        private ThemeListElement listElement;
        private ResourceLocation selectedTheme;
        private NineSliceButtonElement<?> backButton;
        private ScrollableItemListElement itemStackDisplayElement;
        private LabelElement<?> themeNameLabel;

        public ThemeSelect(VoidCrucibleContainer.ThemeSelect container, Inventory inv, Component titleIn) {
            super(container, inv, titleIn);
            Map<ResourceLocation, String> themes = this.getThemes();
            this.listElement = (ThemeListElement)new ThemeListElement((ISpatial)Spatials.positionXY(8, 18).size(this.getGuiSpatial().width() - 16, this.getGuiSpatial().height() - 24), themes, this::selectTheme).layout(this.translateWorldSpatial());
            this.addElement(this.listElement);
        }

        private Map<ResourceLocation, String> getThemes() {
            Map<ResourceLocation, String> themes = ModConfigs.VOID_CRUCIBLE.getThemeKeys().stream().collect(Collectors.toMap(VersionedKey::getId, NamedKey::getName));
            themes.putAll(ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.getMappedDisplay());
            return themes.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        @Override
        public VoidStoneCrucibleTab getSelectedTab() {
            return VoidStoneCrucibleTab.THEME_SELECT;
        }

        private void removeElements() {
            if (this.listElement != null) {
                this.removeElement(this.listElement);
            }
            if (this.backButton != null) {
                this.removeElement(this.backButton);
            }
            if (this.itemStackDisplayElement != null) {
                this.removeElement(this.itemStackDisplayElement);
            }
            if (this.themeNameLabel != null) {
                this.removeElement(this.themeNameLabel);
            }
        }

        private void selectTheme(ResourceLocation newTheme) {
            this.removeElements();
            this.selectedTheme = newTheme;
            this.initializeViewTheme(this.selectedTheme);
        }

        private void initializeViewTheme(ResourceLocation theme) {
            if (theme != this.selectedTheme) {
                return;
            }
            String themeName = ModConfigs.VOID_CRUCIBLE.getThemeKeys().stream().filter(themeKey -> themeKey.getId().equals((Object)theme)).map(NamedKey::getName).findFirst().orElse("Unknown Theme");
            int color = ModConfigs.VOID_CRUCIBLE.getThemeKeys().stream().filter(themeKey -> themeKey.getId().equals((Object)theme)).map(ThemeKey::getColor).findFirst().orElse(-12632257);
            if (ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.getItems().containsKey(theme.m_135815_())) {
                themeName = ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.getItems().get(theme.m_135815_()).getDisplayName();
            }
            this.themeNameLabel = (LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 24), (Component)new TextComponent(themeName).m_130948_(Style.f_131099_.m_178520_(color)), LabelTextStyle.defaultStyle().left().shadow(ChatFormatting.GRAY).wrap()).layout(this.translateWorldSpatial());
            this.addElement(this.themeNameLabel);
            this.backButton = (NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(8, 38).size(40, 16), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> {
                this.selectedTheme = null;
                this.removeElements();
                this.listElement = (ThemeListElement)new ThemeListElement((ISpatial)Spatials.positionXY(8, 18).size(this.getGuiSpatial().width() - 16, this.getGuiSpatial().height() - 24), this.getThemes(), this::selectTheme).layout(this.translateWorldSpatial());
                this.addElement(this.listElement);
            }).label(() -> new TextComponent("Back"), LabelTextStyle.defaultStyle().center().shadow().wrap())).layout(this.translateWorldSpatial());
            this.addElement(this.backButton);
            List<ResourceLocation> blocksInTheme = ((VoidCrucibleContainer.ThemeSelect)this.m_6262_()).getBlocksInTheme(theme);
            List<ResourceLocation> blacklistList = ((VoidCrucibleContainer.ThemeSelect)this.m_6262_()).getBlacklist();
            HashMap<ResourceLocation, Boolean> blocksInThemeToBlacklisted = new HashMap<ResourceLocation, Boolean>();
            for (ResourceLocation block : blocksInTheme) {
                if (ModConfigs.VOID_CRUCIBLE.getAllowedBlocks().contains(block)) continue;
                blocksInThemeToBlacklisted.put(block, blacklistList.contains(block));
            }
            this.itemStackDisplayElement = (ScrollableItemListElement)new ScrollableItemListElement((ISpatial)Spatials.positionXY(8, 58).size(this.getGuiSpatial().width() - 16, this.getGuiSpatial().height() - 64), blocksInThemeToBlacklisted, itemResourceLocation -> {
                if (blacklistList.size() >= 54 && !blacklistList.contains(itemResourceLocation)) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TextComponent("Blacklist is full!").m_130940_(ChatFormatting.RED), true);
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11718_, 1.0f, 1.0f);
                    return false;
                }
                boolean alreadyBlacklisted = blacklistList.contains(itemResourceLocation);
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundUpdateBlacklistMessage(!alreadyBlacklisted, (ResourceLocation)itemResourceLocation));
                if (alreadyBlacklisted) {
                    blacklistList.remove(itemResourceLocation);
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
                } else {
                    blacklistList.add((ResourceLocation)itemResourceLocation);
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                }
                return true;
            }).layout(this.translateWorldSpatial());
            this.addElement(this.itemStackDisplayElement);
        }
    }
}

