/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.void_stone.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.ClickableItemSlotElement;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClickableItemStackDisplayElement<E extends ClickableItemStackDisplayElement<E>>
extends ElasticContainerElement<E> {
    private final ItemStack display;
    private float scale = 1.0f;
    private boolean isBlacklisted = false;
    private final Function<ResourceLocation, Boolean> onItemClick;

    public ClickableItemStackDisplayElement(ISpatial spatial, ItemStack display, boolean isBlacklisted, Function<ResourceLocation, Boolean> onItemClick) {
        super(spatial);
        this.display = display;
        this.isBlacklisted = isBlacklisted;
        this.onItemClick = onItemClick;
    }

    public ItemStack getDisplay() {
        return this.display;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    public void setBlacklisted(boolean blacklisted) {
        this.isBlacklisted = blacklisted;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        if (this.isBlacklisted) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, -10.0);
            ClickableItemSlotElement.renderSlotHighlight(poseStack, this.worldSpatial.x(), this.worldSpatial.y(), 0, 0x77FF0000);
            poseStack.m_85849_();
        }
        float scale = this.getScale();
        PoseStack mvStack = RenderSystem.m_157191_();
        mvStack.m_85836_();
        mvStack.m_85837_((double)this.worldSpatial.x(), (double)this.worldSpatial.y(), (double)(this.worldSpatial.z() + 10));
        mvStack.m_85841_(scale, scale, 1.0f);
        ItemRenderer ir = Minecraft.m_91087_().m_91291_();
        ir.m_115123_(this.getDisplay(), 0, 0);
        mvStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        boolean success = this.onItemClick.apply(this.display.m_41720_().getRegistryName());
        if (success) {
            this.isBlacklisted = !this.isBlacklisted;
        }
        return super.onMouseClicked(mouseX, mouseY, buttonIndex);
    }
}

