/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.void_stone.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.item.AugmentItem;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ThemeButtonElement
extends NineSliceButtonElement<ThemeButtonElement> {
    private final Map.Entry<ResourceLocation, String> theme;

    public ThemeButtonElement(ISpatial spatial, Map.Entry<ResourceLocation, String> theme, Runnable onClick) {
        super(spatial, ScreenTextures.BUTTON_EMPTY_TEXTURES, onClick);
        this.theme = theme;
        this.label(() -> new TextComponent(this.theme.getValue()), LabelTextStyle.defaultStyle().left().shadow().wrap());
    }

    @NotNull
    public ILayoutStrategy adjustLabelLayout() {
        return (screen, gui, parent, world) -> {
            world.translateXY(gui);
            world.size(parent.width(), parent.height() - 27);
        };
    }

    public Map.Entry<ResourceLocation, String> getTheme() {
        return this.theme;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        ItemStack itemStack = AugmentItem.create(this.theme.getKey());
        this.renderItemStack(itemStack, poseStack, this.getWorldSpatial().x() + 2, this.getWorldSpatial().y() + 2, 0.0f);
    }

    @Override
    protected void renderLabel(IElementRenderer renderer, PoseStack poseStack, int x, int y, int z, int width) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int labelText = this.labelTextStyle.calculateLines((Component)new TextComponent(this.theme.getValue()), 135);
        Objects.requireNonNull(font);
        int totalHeight = labelText * (9 + 1) - 1;
        int centerY = y + (this.getWorldSpatial().height() - 11 * labelText) / 2 - totalHeight / 2;
        super.renderLabel(renderer, poseStack, x + 8, centerY, z, width - 18);
    }

    private void renderItemStack(ItemStack itemStack, PoseStack poseStack, float x, float y, float z) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, LightmapHelper.getPackedLightCoords(5), OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }
}

