/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.void_stone.elements;

import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.screen.void_stone.elements.ThemeButtonElement;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class ThemeListElement
extends VerticalScrollClipContainer<ThemeListElement> {
    private final Map<ResourceLocation, String> themes;
    private final Consumer<ResourceLocation> selectTheme;

    public ThemeListElement(ISpatial spatial, Map<ResourceLocation, String> themes, Consumer<ResourceLocation> selectTheme) {
        super(spatial, Padding.ZERO, ScreenTextures.INSET_GREY_BACKGROUND);
        this.selectTheme = selectTheme;
        this.themes = themes;
        this.initializeThemes();
    }

    private void initializeThemes() {
        int buttonWidth = this.innerWidth();
        int buttonHeight = 20;
        int x = 0;
        int y = 0;
        for (Map.Entry<ResourceLocation, String> key : this.themes.entrySet()) {
            TextComponent themeName = new TextComponent(key.getValue());
            List<FormattedText> themeNameLines = UIHelper.getLines((Component)themeName, 125).stream().filter(line -> !line.getString().isEmpty()).toList();
            ThemeButtonElement button = (ThemeButtonElement)new ThemeButtonElement((ISpatial)Spatials.positionXY(x, y).size(buttonWidth, buttonHeight * themeNameLines.size()), key, () -> {
                if (this.selectTheme != null) {
                    this.selectTheme.accept((ResourceLocation)key.getKey());
                }
            }).tooltip(Tooltips.shift(Tooltips.empty(), Tooltips.multi(() -> Minecraft.m_91087_().f_91062_.m_92865_().m_92432_((String)key.getValue(), 140, Style.f_131099_).stream().map(formattedText -> new TextComponent(formattedText.getString())).toList())));
            this.addElement(button);
            y += buttonHeight * themeNameLines.size();
        }
    }
}

