/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.screen.MagnetTableScreen;
import iskallia.vault.event.InputEvents;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.LegacyMagnetItem;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class MagnetTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation TEXTURE = MagnetTableScreen.TEXTURE;
    private final LegacyMagnetItem.MagnetTooltip tooltip;
    private final TextComponent advanced;

    public MagnetTooltipComponent(LegacyMagnetItem.MagnetTooltip tooltip) {
        this.tooltip = tooltip;
        this.advanced = new TextComponent(" " + String.valueOf(ChatFormatting.DARK_GRAY) + ModConfigs.MAGNET_CONFIG.getPerkUpgrade(tooltip.perk).getAdvancedTooltip(tooltip.perkPower));
    }

    public int m_142103_() {
        return 16 * (this.tooltip.perk != LegacyMagnetItem.Perk.NONE ? 2 : 1);
    }

    public int m_142069_(Font font) {
        return 44 + font.m_92895_("" + this.tooltip.stats[0]) + font.m_92895_("" + this.tooltip.stats[1]) + font.m_92895_("" + this.tooltip.stats[2]) + (this.tooltip.perk != LegacyMagnetItem.Perk.NONE ? (InputEvents.isShiftDown() ? font.m_92852_((FormattedText)this.advanced) : 0) : 0);
    }

    public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer pItemRenderer, int pBlitOffset) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)pBlitOffset);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int U = 180;
        int V = 112;
        int W = 10;
        Objects.requireNonNull(font);
        int s = 9 - 1;
        int xo = x;
        for (int stat : this.tooltip.stats) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)s, (int)s, (float)U, (float)V, (int)W, (int)W, (int)256, (int)256);
            V += 18;
            TextComponent text = new TextComponent("" + stat);
            font.m_92889_(poseStack, (Component)text, (float)(x += W), (float)y, -1);
            x += font.m_92852_((FormattedText)text) + 2;
        }
        if (this.tooltip.perk != LegacyMagnetItem.Perk.NONE) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)xo, (int)(y += 12), (int)s, (int)s, (float)198.0f, (float)(77 + 18 * this.tooltip.perk.ordinal()), (int)W, (int)W, (int)256, (int)256);
            xo += W;
            MutableComponent perkText = new TextComponent(this.tooltip.perk.m_7912_()).m_130948_(Style.f_131099_.m_178520_(ModConfigs.MAGNET_CONFIG.getPerkUpgrade(this.tooltip.perk).getColor()));
            if (InputEvents.isShiftDown()) {
                perkText.m_7220_((Component)this.advanced);
            }
            font.m_92889_(poseStack, (Component)perkText, (float)xo, (float)y, -1);
        }
        poseStack.m_85849_();
    }
}

