/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutablePosition;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.widget.BaseWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPanWidget
extends AbstractWidget
implements IMutablePosition {
    protected static Map<Class<?>, Vec2> persistedTranslations = new HashMap();
    protected Vec2 translation;
    private final List<BaseWidget> internalWidgets = new ArrayList<BaseWidget>();
    protected boolean dragging;
    protected Vec2 clickedPos;

    public AbstractPanWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        persistedTranslations.clear();
    }

    @NotNull
    protected NineSlice.TextureRegion getBackground() {
        return ScreenTextures.INSET_GREY_BACKGROUND;
    }

    protected Vec2 getDefaultCentered() {
        int centerX = this.f_93618_ / 2;
        int centerY = this.f_93619_ / 2;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int width = 0;
        int height = 0;
        for (BaseWidget internalWidget : this.internalWidgets) {
            int y;
            int x = internalWidget.x - this.f_93620_;
            if (x < minX) {
                minX = x;
                width = internalWidget.width;
            }
            if ((y = internalWidget.y - this.f_93621_) >= minY) continue;
            minY = y;
            height = internalWidget.height;
        }
        if (minX == Integer.MAX_VALUE) {
            minX = 0;
        }
        if (minY == Integer.MAX_VALUE) {
            minY = 0;
        }
        return new Vec2((float)(centerX - minX) - (float)width / 2.0f, (float)(centerY - minY) - (float)height / 2.0f);
    }

    protected <W extends BaseWidget> void addWidget(W widget) {
        widget.x += this.f_93620_;
        widget.y += this.f_93621_;
        this.internalWidgets.add(widget);
    }

    protected boolean contains(double mouseX, double mouseY) {
        if (mouseX < (double)this.f_93620_ || mouseX > (double)(this.f_93620_ + this.f_93618_)) {
            return false;
        }
        return mouseY >= (double)this.f_93621_ && mouseY <= (double)(this.f_93621_ + this.f_93619_);
    }

    private void renderInnerForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.translation.f_82470_, (double)this.translation.f_82471_, 0.0);
        int translatedMouseX = (int)((float)mouseX - this.translation.f_82470_);
        int translatedMouseY = (int)((float)mouseY - this.translation.f_82471_);
        for (BaseWidget widget : this.internalWidgets) {
            widget.m_6305_(poseStack, translatedMouseX, translatedMouseY, partialTick);
        }
        poseStack.m_85849_();
    }

    private void renderInnerBackground(PoseStack poseStack) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)0x1FFFFFF);
    }

    private void moveTranslation(float x, float y) {
        this.translation = new Vec2(x + this.translation.f_82470_, y + this.translation.f_82471_);
        persistedTranslations.put(this.getClass(), this.translation);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.getBackground().blit(poseStack, this.f_93620_ - 1, this.f_93621_ - 1, 0, this.f_93618_ + 2, this.f_93619_ + 2);
        if (this.translation == null) {
            Vec2 defaultCentered = this.getDefaultCentered();
            this.translation = persistedTranslations.getOrDefault(this.getClass(), defaultCentered);
        }
        UIHelper.renderOverflowHidden(poseStack, this::renderInnerBackground, ps -> this.renderInnerForeground((PoseStack)ps, mouseX, mouseY, partialTick));
    }

    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        if (this.contains(mouseX, mouseY)) {
            this.dragging = true;
            this.clickedPos = new Vec2((float)mouseX, (float)mouseY);
            int translatedMouseX = (int)(mouseX - (double)this.translation.f_82470_);
            int translatedMouseY = (int)(mouseY - (double)this.translation.f_82471_);
            for (BaseWidget internalWidget : this.internalWidgets) {
                if (!internalWidget.m_5953_(translatedMouseX, translatedMouseY) || !internalWidget.m_6375_(translatedMouseX, translatedMouseY, pButton)) continue;
                this.dragging = false;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int pButton) {
        this.dragging = false;
        int translatedMouseX = (int)(mouseX - (double)this.translation.f_82470_);
        int translatedMouseY = (int)(mouseY - (double)this.translation.f_82471_);
        for (BaseWidget internalWidget : this.internalWidgets) {
            internalWidget.m_6348_(translatedMouseX, translatedMouseY, pButton);
        }
        return super.m_6348_(mouseX, mouseY, pButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int translatedMouseX = (int)(mouseX - (double)this.translation.f_82470_);
        int translatedMouseY = (int)(mouseY - (double)this.translation.f_82471_);
        for (BaseWidget internalWidget : this.internalWidgets) {
            if (!internalWidget.m_5953_(translatedMouseX, translatedMouseY) || !internalWidget.m_7979_(translatedMouseX, translatedMouseY, button, dragX, dragY)) continue;
            return true;
        }
        if (!this.dragging) {
            return false;
        }
        float deltaX = (float)(mouseX - (double)this.clickedPos.f_82470_);
        float deltaY = (float)(mouseY - (double)this.clickedPos.f_82471_);
        this.moveTranslation(deltaX, deltaY);
        this.clickedPos = new Vec2((float)mouseX, (float)mouseY);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double pDelta) {
        return super.m_6050_(mouseX, mouseY, pDelta);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.dragging) {
            return true;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
    }

    @Override
    public IMutablePosition positionX(int x) {
        this.f_93620_ = x;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition positionX(IPosition position) {
        return this.positionX(position.x());
    }

    @Override
    public IMutablePosition positionY(int y) {
        this.f_93621_ = y;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition positionY(IPosition position) {
        return this.positionY(position.y());
    }

    @Override
    public IMutablePosition positionZ(int z) {
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition positionZ(IPosition position) {
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition positionXY(int x, int y) {
        this.f_93620_ = x;
        this.f_93621_ = y;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition positionXY(IPosition position) {
        return this.positionXY(position.x(), position.y());
    }

    @Override
    public IMutablePosition positionXYZ(int x, int y, int z) {
        this.f_93620_ = x;
        this.f_93621_ = y;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition positionXYZ(IPosition position) {
        return this.positionXYZ(position.x(), position.y(), position.z());
    }

    @Override
    public IMutablePosition translateX(int x) {
        this.f_93620_ += x;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition translateX(IPosition position) {
        return this.translateX(position.x());
    }

    @Override
    public IMutablePosition translateY(int y) {
        this.f_93621_ += y;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition translateY(IPosition position) {
        return this.translateY(position.y());
    }

    @Override
    public IMutablePosition translateZ(int z) {
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition translateZ(IPosition position) {
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition translateXY(int x, int y) {
        this.f_93620_ += x;
        this.f_93621_ += y;
        return Spatials.positionXY(this.f_93620_, this.f_93621_).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition translateXY(IPosition position) {
        return this.translateXY(position.x(), position.y());
    }

    @Override
    public IMutablePosition translateXYZ(int x, int y, int z) {
        this.f_93620_ += x;
        this.f_93621_ += y;
        return Spatials.positionXYZ(this.f_93620_, this.f_93621_, z).size(this.f_93618_, this.f_93619_);
    }

    @Override
    public IMutablePosition translateXYZ(IPosition position) {
        return this.translateXYZ(position.x(), position.y(), position.z());
    }

    @Override
    public int x() {
        return this.f_93620_;
    }

    @Override
    public int y() {
        return this.f_93621_;
    }

    @Override
    public int z() {
        return 0;
    }
}

