/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.config.PrestigePowersGUIConfig;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.util.MathUtilities;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class PrestigeSelectionWidget
extends AbstractWidget {
    public static final ResourceLocation HUD_RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");
    private final TieredSkill prestige;
    private final double angleBoundary;

    public PrestigeSelectionWidget(int x, int y, TieredSkill prestige, double angleBoundary) {
        super(x, y, 24, 24, (Component)new TextComponent(prestige.getId()));
        this.prestige = prestige;
        this.angleBoundary = angleBoundary;
    }

    public TieredSkill getPrestige() {
        return this.prestige;
    }

    public boolean m_142518_() {
        LearnableSkill learnableSkill = this.prestige.getChild();
        if (learnableSkill instanceof ActivatePrestigePower) {
            ActivatePrestigePower power = (ActivatePrestigePower)learnableSkill;
            return power.isActive();
        }
        return false;
    }

    private Rectangle getBounds() {
        return new Rectangle(this.f_93620_ - 12, this.f_93621_ - 12, this.f_93618_, this.f_93619_);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        float midX = (float)minecraft.m_91268_().m_85445_() / 2.0f;
        float midY = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        Vec2 towardsWidget = new Vec2((float)this.f_93620_ - midX, (float)this.f_93621_ - midY);
        Vec2 towardsMouse = new Vec2((float)mouseX - midX, (float)(mouseY - (double)midY));
        double dot = towardsWidget.f_82470_ * towardsMouse.f_82470_ + towardsWidget.f_82471_ * towardsMouse.f_82471_;
        double angleBetween = Math.acos(dot / (MathUtilities.length(towardsWidget) * MathUtilities.length(towardsMouse)));
        return angleBetween < this.angleBoundary;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle bounds = this.getBounds();
        boolean active = this.m_142518_();
        boolean hovered = this.m_5953_(mouseX, mouseY);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureAtlasRegion texture = hovered ? ScreenTextures.PRESTIGE_HOVERED : (active ? ScreenTextures.PRESTIGE_UNLOCKED : ScreenTextures.PRESTIGE_EMPTY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture.atlas().get().getAtlasResourceLocation());
        ITextureAtlas frameAtlas = texture.atlas().get();
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)bounds.x, (int)bounds.y, (int)0, (int)texture.width(), (int)texture.height(), (TextureAtlasSprite)frameAtlas.getSprite(texture.resourceLocation()));
        PrestigePowersGUIConfig guiConfig = ModConfigs.PRESTIGE_POWERS_GUI;
        SkillStyle style = guiConfig.getStyles().get(this.prestige.getId());
        ResourceLocation icon = null;
        if (style != null) {
            ResourceLocation resourceLocation = icon = active || style.inactiveIcon == null ? style.icon : style.inactiveIcon;
        }
        if (icon != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ModTextureAtlases.PRESTIGE.get().getAtlasResourceLocation());
            GuiComponent.m_93200_((PoseStack)matrixStack, (int)(bounds.x + 4), (int)(bounds.y + 4), (int)0, (int)16, (int)16, (TextureAtlasSprite)ModTextureAtlases.PRESTIGE.get().getSprite(icon));
        }
        if (hovered) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_RESOURCE);
            this.m_93228_(matrixStack, bounds.x, bounds.y, 64, 13, 24, 24);
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

