/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.particles.ArtifactProjectorParticleOptions;
import iskallia.vault.core.vault.influence.VaultGod;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ArtifactProjectorParticle
extends TextureSheetParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;
    private double rotationOffset;
    private double rotationSpeed;
    private double range;
    private final SpriteSet pSprites;
    protected double dir;

    ArtifactProjectorParticle(ClientLevel p_106464_, double p_106465_, double p_106466_, double p_106467_, double range, double rotationOffset, double rotationSpeed, SpriteSet pSprites) {
        super(p_106464_, p_106465_, p_106466_, p_106467_);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.xStart = p_106465_;
        this.yStart = p_106466_;
        this.zStart = p_106467_;
        this.f_107663_ = 0.4f * (this.f_107223_.nextFloat() * 0.5f + 0.2f);
        float f = this.f_107223_.nextFloat() * 0.6f + 0.4f;
        this.f_107227_ = 0.9f * f;
        this.f_107228_ = 0.9f * f;
        this.f_107229_ = f;
        this.f_107219_ = false;
        this.f_107225_ = 20;
        this.pSprites = pSprites;
        Vec3 vec = new Vec3(range, range, 0.0).m_82535_((float)Math.toRadians((180.0 + rotationOffset) * rotationSpeed));
        vec = vec.m_82524_((float)Math.toRadians(this.dir));
        this.f_107212_ = this.xStart + vec.m_7096_();
        this.f_107213_ = this.yStart + vec.m_7098_();
        this.f_107214_ = this.zStart + vec.m_7094_();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.range = range;
        this.rotationOffset = rotationOffset;
        this.rotationSpeed = rotationSpeed;
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        if (this.f_107224_ > 1) {
            super.m_5744_(pBuffer, pRenderInfo, pPartialTicks);
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_6257_(double pX, double pY, double pZ) {
        this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
        this.m_107275_();
    }

    public int m_6355_(float pPartialTick) {
        int i = super.m_6355_(pPartialTick);
        float f = (float)this.f_107224_ / (float)this.f_107225_;
        f *= f;
        f *= f;
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
            k = 240;
        }
        return j | k << 16;
    }

    public void setDir(double dir) {
        this.dir = dir;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            float f = (float)this.f_107224_ / (float)this.f_107225_;
            f = 1.0f - f;
            f *= f;
            f *= f;
            Vec3 vec = new Vec3((double)f * this.range, (double)f * this.range, 0.0).m_82535_((float)Math.toRadians(((double)(f * 180.0f) + this.rotationOffset) * this.rotationSpeed));
            vec = vec.m_82524_((float)Math.toRadians(this.dir));
            this.f_107212_ = this.xStart + vec.m_7096_();
            this.f_107213_ = this.yStart + vec.m_7098_();
            this.f_107214_ = this.zStart + vec.m_7094_();
            this.m_108339_(this.pSprites);
        }
    }

    public static class AltarProvider
    implements ParticleProvider<ArtifactProjectorParticleOptions> {
        private final SpriteSet sprites;

        public AltarProvider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Nullable
        public Particle createParticle(ArtifactProjectorParticleOptions data, @Nonnull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            ArtifactProjectorParticle particle = new ArtifactProjectorParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprites);
            particle.m_108335_(this.sprites);
            int col = switch (new Random().nextInt(4)) {
                case 1 -> VaultGod.TENOS.getColor();
                case 2 -> VaultGod.VELARA.getColor();
                case 3 -> VaultGod.WENDARR.getColor();
                default -> VaultGod.IDONA.getColor();
            };
            int r = col >>> 16 & 0xFF;
            int g = col >>> 8 & 0xFF;
            int b = col & 0xFF;
            float colorOffset = new Random().nextFloat(0.3f) + 0.7f;
            particle.m_107253_((float)r / 256.0f * colorOffset, (float)g / 256.0f * colorOffset, (float)b / 256.0f * colorOffset);
            particle.setDir(data.dir());
            particle.m_107257_(data.lifetime());
            return particle;
        }
    }
}

