/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record ArtifactProjectorParticleOptions(ParticleType<ArtifactProjectorParticleOptions> particleType, int lifetime, double dir) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<ArtifactProjectorParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ArtifactProjectorParticleOptions>(){

        @Nonnull
        @ParametersAreNonnullByDefault
        public ArtifactProjectorParticleOptions fromCommand(ParticleType<ArtifactProjectorParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            return new ArtifactProjectorParticleOptions(particleType, reader.readInt(), reader.readDouble());
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public ArtifactProjectorParticleOptions fromNetwork(ParticleType<ArtifactProjectorParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new ArtifactProjectorParticleOptions(particleType, buffer.readInt(), buffer.readDouble());
        }
    };

    public static Codec<ArtifactProjectorParticleOptions> codec(ParticleType<ArtifactProjectorParticleOptions> particleType) {
        return RecordCodecBuilder.create(c -> c.group((App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime), (App)Codec.DOUBLE.fieldOf("dir").forGetter(data -> data.dir)).apply((Applicative)c, (range, dir) -> new ArtifactProjectorParticleOptions(particleType, (int)range, (double)dir)));
    }

    @Nonnull
    public ParticleType<ArtifactProjectorParticleOptions> m_6012_() {
        return this.particleType;
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeFloat((float)this.lifetime);
        buffer.writeDouble(this.dir);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f", this.m_6012_().getRegistryName(), this.lifetime, this.dir);
    }
}

