/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.init.ModOptions;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.Tween;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EffectRangeParticle
extends TextureSheetParticle {
    private static final float ROTATION_SPEED = 0.0125f;
    private float rotationSpeed;
    private final double xOrigin;
    private final double zOrigin;
    private final float orbitRadius;
    private final Tween alphaTween;
    private float orbitAngleRadians;

    protected EffectRangeParticle(ClientLevel clientLevel, double xPosition, double yPosition, double zPosition, double xOrigin, double zOrigin, float orbitRadius, float orbitAngleRadians, Tween alphaTween) {
        super(clientLevel, xPosition, yPosition, zPosition);
        this.xOrigin = xOrigin;
        this.zOrigin = zOrigin;
        this.orbitRadius = orbitRadius;
        this.alphaTween = alphaTween;
        this.f_107219_ = false;
        this.orbitAngleRadians = orbitAngleRadians;
        this.m_107264_(this.xOrigin + Math.cos(this.orbitAngleRadians) * (double)this.orbitRadius, this.f_107213_, this.zOrigin + Math.sin(this.orbitAngleRadians) * (double)this.orbitRadius);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.orbitAngleRadians += this.rotationSpeed;
        this.m_107264_(this.xOrigin + Math.cos(this.orbitAngleRadians) * (double)this.orbitRadius, this.f_107213_, this.zOrigin + Math.sin(this.orbitAngleRadians) * (double)this.orbitRadius);
    }

    @ParametersAreNonnullByDefault
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        this.m_107271_(Mth.m_14036_((float)this.alphaTween.tween((float)this.f_107224_ + partialTicks, 0.0f, 1.0f, this.f_107225_), (float)0.0f, (float)1.0f));
        super.m_5744_(vertexConsumer, camera, partialTicks);
    }

    protected int m_6355_(float pPartialTick) {
        return 240;
    }

    public static class CircleProvider
    implements ParticleProvider<SphericalParticleOptions> {
        private static final Random RANDOM = new Random();
        private final SpriteSet sprites;
        private final float orbitSpeed;
        private final int durationTicks;
        private final float scale;
        private final Tween alphaTween;

        public CircleProvider(SpriteSet pSprites, float orbitSpeed, int durationTicks, float scale, Tween alphaTween) {
            this.sprites = pSprites;
            this.orbitSpeed = orbitSpeed;
            this.durationTicks = durationTicks;
            this.scale = scale;
            this.alphaTween = alphaTween;
        }

        @Nullable
        public Particle createParticle(SphericalParticleOptions data, @Nonnull ClientLevel level, double xOrigin, double yOrigin, double zOrigin, double xSpeed, double ySpeed, double zSpeed) {
            if (data.particleType() == ModParticles.TOTEM_EFFECT_RANGE.get() && !ModOptions.TOTEM_PARTICLES.getValue().booleanValue()) {
                return null;
            }
            Vec3 position = MathUtilities.getRandomPointOnCircle(xOrigin, yOrigin, zOrigin, data.range(), RANDOM);
            float orbitRadius = (float)MathUtilities.getDistance(position.f_82479_, position.f_82481_, xOrigin, zOrigin);
            float orbitAngleRadians = (float)Math.atan2(position.f_82479_ - xOrigin, position.f_82481_ - zOrigin);
            EffectRangeParticle particle = new EffectRangeParticle(level, position.f_82479_, position.f_82480_, position.f_82481_, xOrigin, zOrigin, orbitRadius, orbitAngleRadians, this.alphaTween);
            particle.m_108335_(this.sprites);
            particle.m_107253_(data.color().m_122239_(), data.color().m_122260_(), data.color().m_122269_());
            particle.m_6569_(this.scale);
            particle.m_107257_(this.durationTicks);
            particle.setRotationSpeed((0.0125f + Mth.m_144924_((Random)RANDOM, (float)-0.01f, (float)0.01f)) * this.orbitSpeed);
            return particle;
        }
    }

    public static class SphereProvider
    implements ParticleProvider<SphericalParticleOptions> {
        private static final Random RANDOM = new Random();
        private final SpriteSet sprites;
        private final float orbitSpeed;
        private final int durationTicks;
        private final float scale;
        private final Tween alphaTween;

        public SphereProvider(SpriteSet pSprites, float orbitSpeed, int durationTicks, float scale, Tween alphaTween) {
            this.sprites = pSprites;
            this.orbitSpeed = orbitSpeed;
            this.durationTicks = durationTicks;
            this.scale = scale;
            this.alphaTween = alphaTween;
        }

        @Nullable
        public Particle createParticle(SphericalParticleOptions data, @Nonnull ClientLevel level, double xOrigin, double yOrigin, double zOrigin, double xSpeed, double ySpeed, double zSpeed) {
            if (data.particleType() == ModParticles.TOTEM_EFFECT_RANGE.get() && !ModOptions.TOTEM_PARTICLES.getValue().booleanValue()) {
                return null;
            }
            Vec3 position = MathUtilities.getRandomPointOnSphere(xOrigin, yOrigin, zOrigin, data.range(), RANDOM);
            float orbitRadius = (float)MathUtilities.getDistance(position.f_82479_, position.f_82481_, xOrigin, zOrigin);
            float orbitAngleRadians = (float)Math.atan2(position.f_82479_ - xOrigin, position.f_82481_ - zOrigin);
            EffectRangeParticle particle = new EffectRangeParticle(level, position.f_82479_, position.f_82480_, position.f_82481_, xOrigin, zOrigin, orbitRadius, orbitAngleRadians, this.alphaTween);
            particle.m_108335_(this.sprites);
            particle.m_107253_(data.color().m_122239_(), data.color().m_122260_(), data.color().m_122269_());
            particle.m_6569_(this.scale);
            particle.m_107257_(this.durationTicks);
            particle.setRotationSpeed((0.0125f + Mth.m_144924_((Random)RANDOM, (float)-0.01f, (float)0.01f)) * this.orbitSpeed);
            return particle;
        }
    }
}

