/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class HealSpellParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private int healedEntityId = 0;

    protected HealSpellParticle(ClientLevel pLevel, double pX, double pY, double pZ, int healedEntityId, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        float f;
        this.f_107226_ = 0.0f;
        this.f_107219_ = false;
        this.f_172258_ = 1.0f;
        this.sprites = pSprites;
        this.healedEntityId = healedEntityId;
        this.f_107227_ = f = this.f_107223_.nextFloat() * 0.3f + 0.7f;
        this.f_107228_ = f;
        this.f_107229_ = f;
        this.f_107663_ = 0.1f * (this.f_107223_.nextFloat() * this.f_107223_.nextFloat() * 3.0f + 1.0f);
        this.f_107225_ = (int)(8.0 / ((double)this.f_107223_.nextFloat() * 0.8 + 0.2)) + 2;
        this.m_108339_(pSprites);
        this.updateSpeed();
    }

    private void updateSpeed() {
        Entity entity = this.f_107208_.m_6815_(this.healedEntityId);
        if (entity != null) {
            double pXSpeed = (entity.m_20185_() - this.f_107212_) / (double)this.f_107225_ * 1.5;
            double pYSpeed = (entity.m_20186_() + (double)entity.m_20206_() / 2.0 - this.f_107213_) / (double)this.f_107225_ * 1.5;
            double pZSpeed = (entity.m_20189_() - this.f_107214_) / (double)this.f_107225_ * 1.5;
            this.f_107215_ = pXSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
            this.f_107216_ = pYSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
            this.f_107217_ = pZSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        }
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.updateSpeed();
        this.m_108339_(this.sprites);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            int healedEntityId = (int)pXSpeed;
            return new HealSpellParticle(pLevel, pX, pY, pZ, healedEntityId, this.sprites);
        }
    }
}

