/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.particles.ColoredParticleOptions;
import iskallia.vault.init.ModOptions;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TotemFountainParticle
extends TextureSheetParticle {
    private float scale;

    protected TotemFountainParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107219_ = false;
    }

    public void setYSpeed(float ySpeed) {
        this.f_107216_ = ySpeed;
    }

    public void setRoll(float rollRadians) {
        this.f_107204_ = rollRadians;
        this.f_107231_ = rollRadians;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.m_107264_(this.f_107212_, this.f_107213_ + this.f_107216_, this.f_107214_);
    }

    @ParametersAreNonnullByDefault
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        float delta = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107663_ = 0.1f;
        super.m_6569_(Mth.m_14179_((float)delta, (float)this.scale, (float)0.0f));
        float alpha = 1.0f - delta;
        this.m_107271_(Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
        super.m_5744_(vertexConsumer, camera, partialTicks);
    }

    @Nonnull
    public Particle m_6569_(float scale) {
        this.scale = scale;
        return super.m_6569_(scale);
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float pPartialTick) {
        return 240;
    }

    public static class Provider
    implements ParticleProvider<ColoredParticleOptions> {
        private static final Random RANDOM = new Random();
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Nullable
        public Particle createParticle(@Nonnull ColoredParticleOptions data, @Nonnull ClientLevel level, double xOrigin, double yOrigin, double zOrigin, double xSpeed, double ySpeed, double zSpeed) {
            if (!ModOptions.TOTEM_PARTICLES.getValue().booleanValue()) {
                return null;
            }
            TotemFountainParticle particle = new TotemFountainParticle(level, xOrigin, yOrigin, zOrigin);
            particle.m_108335_(this.sprites);
            particle.m_107253_(data.color().m_122239_(), data.color().m_122260_(), data.color().m_122269_());
            particle.m_6569_(Mth.m_144924_((Random)RANDOM, (float)0.5f, (float)1.0f));
            particle.m_107257_(40);
            particle.setYSpeed(Mth.m_144924_((Random)RANDOM, (float)0.025f, (float)0.0625f));
            particle.setRoll(RANDOM.nextBoolean() ? 0.0f : 0.7853982f);
            return particle;
        }
    }
}

