/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.client.render.healthbar.HealthbarRenderer;
import iskallia.vault.config.EntityHitboxOffsets;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.entity.champion.IChampionAffix;
import iskallia.vault.entity.champion.LeechOnHitAffix;
import iskallia.vault.entity.champion.OnHitApplyPotionAffix;
import iskallia.vault.entity.champion.PotionAuraAffix;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModRenderTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ChampionRenderer {
    private static final Map<String, IChampionAffixRenderer<? extends IChampionAffix>> AFFIX_RENDERERS = new HashMap<String, IChampionAffixRenderer<? extends IChampionAffix>>();

    public static void render(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, Quaternion cameraOrientation, float partialTicks) {
        LivingEntity livingEntity;
        if (!(entity instanceof LivingEntity) || !ChampionLogic.isChampion(livingEntity = (LivingEntity)entity)) {
            return;
        }
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)entity.m_20206_() + 0.5 + (HealthbarRenderer.isShowingHealthbar(livingEntity) ? 0.3 : 0.0) + (double)ModConfigs.ENTITY_HITBOX_OFFSETS.getOffset(entity.m_6095_().getRegistryName()).orElse(EntityHitboxOffsets.EntityHitboxOffset.empty()).getY(), 0.0);
        poseStack.m_85845_(cameraOrientation);
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        ChampionRenderer.renderChampionIndicator(poseStack, bufferSource);
        ChampionRenderer.renderAffixes(entity, poseStack, bufferSource, partialTicks);
        poseStack.m_85849_();
    }

    private static void renderAffixes(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        if (entity instanceof ChampionLogic.IChampionLogicHolder) {
            ChampionLogic.IChampionLogicHolder championLogicHolder = (ChampionLogic.IChampionLogicHolder)entity;
            List<IChampionAffix> affixes = championLogicHolder.getChampionLogic().getAffixes();
            AtomicInteger xOffset = new AtomicInteger(-affixes.size() * 8);
            affixes.forEach(affix -> {
                IChampionAffix affixRenderer = ChampionRenderer.getAffixRenderer(affix);
                if (affixRenderer == null) {
                    return;
                }
                RenderSystem.m_69482_();
                TextureAtlasSprite icon = affixRenderer.getIcon((IChampionAffix)affix);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon.m_118414_().m_118330_());
                GuiComponent.m_93200_((PoseStack)poseStack, (int)(-1 + xOffset.get()), (int)0, (int)0, (int)icon.m_118405_(), (int)icon.m_118408_(), (TextureAtlasSprite)icon);
                xOffset.set(xOffset.get() + 16);
                affixRenderer.render(entity, (IChampionAffix)affix, poseStack, bufferSource, partialTicks);
            });
        }
    }

    private static void renderChampionIndicator(PoseStack poseStack, MultiBufferSource bufferSource) {
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.CHAMPION_INDICATOR);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float size = 10.0f;
        buffer.m_85982_(matrix, -size, -size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_85982_(matrix, -size, size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_85982_(matrix, size, size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_85982_(matrix, size, -size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
    }

    private static <T extends IChampionAffix> void registerRenderer(Class<T> affixClass, String type, IChampionAffixRenderer<T> renderer) {
        AFFIX_RENDERERS.put(type, renderer);
    }

    @Nullable
    private static <A extends IChampionAffix, T extends IChampionAffixRenderer<A>> T getAffixRenderer(A affix) {
        String type = affix.getType();
        if (!AFFIX_RENDERERS.containsKey(type)) {
            return null;
        }
        return (T)AFFIX_RENDERERS.get(type);
    }

    static {
        ChampionRenderer.registerRenderer(OnHitApplyPotionAffix.class, "on_hit_apply_potion", affix -> affix.getMobEffect() == null ? null : Minecraft.m_91087_().m_91306_().m_118732_(affix.getMobEffect()));
        ChampionRenderer.registerRenderer(PotionAuraAffix.class, "potion_aura", new IChampionAffixRenderer<PotionAuraAffix>(){

            @Override
            @Nullable
            public TextureAtlasSprite getIcon(PotionAuraAffix affix) {
                return affix.getMobEffect() == null ? null : Minecraft.m_91087_().m_91306_().m_118732_(affix.getMobEffect());
            }

            @Override
            public void render(Entity entity, PotionAuraAffix affix, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
                if (affix.getMobEffect() == null) {
                    return;
                }
                int range = affix.getRange();
                Minecraft minecraft = Minecraft.m_91087_();
                LocalPlayer player = minecraft.f_91074_;
                if (minecraft.m_91104_() || player == null || player.m_20270_(entity) > (float)Math.max(range * 2, range + 5)) {
                    return;
                }
                int color = affix.getMobEffect().m_19484_();
                float red = (float)(color >>> 16 & 0xFF) / 255.0f;
                float green = (float)(color >>> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                Vec3 offset = new Vec3((double)range, 0.0, 0.0).m_82524_(entity.f_19853_.m_5822_().nextFloat((float)Math.PI * 2));
                Vec3 pos = entity.m_20182_().m_82549_(offset);
                ParticleEngine pm = Minecraft.m_91087_().f_91061_;
                Particle particle = pm.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), pos.f_82479_, pos.f_82480_ + (double)0.2f, pos.f_82481_, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.m_107253_(red, green, blue);
                }
                for (int i = 0; i < 3; ++i) {
                    offset = new Vec3((double)range, (double)0.1f, 0.0).m_82524_((float)Math.toRadians((float)(entity.f_19797_ % 90) * 4.0f + (float)(120 * i)));
                    pos = entity.m_20182_().m_82549_(offset);
                    particle = pm.m_107370_((ParticleOptions)ModParticles.CHAINING.get(), pos.f_82479_, pos.f_82480_ + (double)0.2f, pos.f_82481_, 0.0, 0.0, 0.0);
                    if (particle == null) continue;
                    particle.m_107253_(Mth.m_14036_((float)(red * 1.25f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(green * 1.25f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(blue * 1.25f), (float)0.0f, (float)1.0f));
                }
            }
        });
        ChampionRenderer.registerRenderer(LeechOnHitAffix.class, "leech_on_hit", affix -> Minecraft.m_91087_().m_91306_().m_118732_((MobEffect)ModEffects.RAMPAGE_LEECH));
    }

    private static interface IChampionAffixRenderer<T extends IChampionAffix> {
        @Nullable
        public TextureAtlasSprite getIcon(T var1);

        default public void render(Entity entity, T affix, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        }
    }
}

