/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.init.ModEntities;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionSeries;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompanionItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final CompanionItemRenderer INSTANCE = new CompanionItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    private static final String UPDATING_SKIN_TAG = "updatingSkin";
    private static final String DEFAULT_SKIN_TAG = "defaultSkin";
    private final EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();

    public CompanionItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        PetEntity pet;
        if (!(stack.m_41720_() instanceof CompanionItem) || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        EntityType<PetEntity> entityType = ModEntities.PET;
        CompanionSeries series = CompanionItem.getPetSeries(stack);
        if (series == CompanionSeries.PET) {
            String petType = CompanionItem.getPetType(stack);
            entityType = PetHelper.getVariant(petType).map(PetHelper.PetVariant::entityType).orElse(ModEntities.PET);
        }
        if ((pet = (PetEntity)entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_)) == null) {
            VaultMod.LOGGER.error("Failed to create pet entity for type {}", entityType);
            return;
        }
        pet.setCompanionData(stack);
        pet.f_19794_ = true;
        if (series == CompanionSeries.LEGEND) {
            Optional<GameProfile> profileOpt = CompanionItem.getUserProfile(stack);
            profileOpt.ifPresent(profile -> {
                pet.setGameProfile((GameProfile)profile);
                Minecraft minecraft = Minecraft.m_91087_();
                CompanionItemRenderer.getPlayerProfileTexture(minecraft, stack).ifPresent(texture -> {
                    ResourceLocation skin = minecraft.m_91109_().m_118825_(texture, MinecraftProfileTexture.Type.SKIN);
                    String metadata = texture.getMetadata("model");
                    pet.setSkinLocation(skin);
                    pet.setSlimSkin(metadata != null && !metadata.equals("default"));
                });
                if (stack.m_41784_().m_128441_(DEFAULT_SKIN_TAG)) {
                    pet.setSkinLocation(DefaultPlayerSkin.m_118626_());
                    pet.setSlimSkin(false);
                }
            });
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -0.5, 0.0);
        if (series == CompanionSeries.LEGEND) {
            if (pet.getPetType().equalsIgnoreCase("minion")) {
                poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            } else if (pet.getPetType().equalsIgnoreCase("antlion")) {
                float originalScale = 0.1667f;
                poseStack.m_85841_(1.0f / originalScale, 1.0f / originalScale, 1.0f / originalScale);
            } else if (pet.getPetType().equalsIgnoreCase("giant")) {
                float originalScale = 1.5f;
                poseStack.m_85841_(1.0f / originalScale, 1.0f / originalScale, 1.0f / originalScale);
            }
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (series == CompanionSeries.PET && pet.getPetType().equalsIgnoreCase("baby_creeper_pog")) {
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        }
        float yBodyRot = pet.f_20883_;
        float yBodyRotO = pet.f_20884_;
        float yRot = pet.m_146908_();
        float xRot = pet.m_146909_();
        float yHeadRotO = pet.f_20886_;
        float yHeadRot = pet.f_20885_;
        pet.f_20883_ = 45.0f;
        pet.f_20884_ = 45.0f;
        pet.m_146922_(0.0f);
        pet.m_146926_(0.0f);
        pet.f_19860_ = 0.0f;
        pet.f_20885_ = pet.m_146908_();
        pet.f_20886_ = pet.m_146908_();
        this.dispatcher.m_114468_(false);
        this.dispatcher.m_114384_((Entity)pet, 0.0, 0.0, 0.0, 0.0f, Minecraft.m_91087_().m_91296_(), poseStack, buffer, light);
        this.dispatcher.m_114468_(true);
        pet.f_20883_ = yBodyRot;
        pet.f_20884_ = yBodyRotO;
        pet.m_146922_(yRot);
        pet.m_146926_(xRot);
        pet.f_20886_ = yHeadRotO;
        pet.f_20885_ = yHeadRot;
    }

    private static Optional<MinecraftProfileTexture> getPlayerProfileTexture(Minecraft minecraft, ItemStack stack) {
        return CompanionItem.getUserProfile(stack).flatMap(gameProfile -> {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(UPDATING_SKIN_TAG) || tag.m_128441_(DEFAULT_SKIN_TAG)) {
                return Optional.empty();
            }
            if (!gameProfile.getProperties().containsKey((Object)"textures")) {
                tag.m_128379_(UPDATING_SKIN_TAG, true);
                SkullBlockEntity.m_155738_((GameProfile)gameProfile, gp -> {
                    CompanionItem.setUserProfile(stack, gp);
                    CompoundTag t = stack.m_41784_();
                    if (!gp.getProperties().containsKey((Object)"textures")) {
                        t.m_128379_(DEFAULT_SKIN_TAG, true);
                    }
                    t.m_128473_(UPDATING_SKIN_TAG);
                });
                return Optional.empty();
            }
            SkinManager skinManager = minecraft.m_91109_();
            Map skinInfo = skinManager.m_118815_(gameProfile);
            if (skinInfo.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return Optional.of((MinecraftProfileTexture)skinInfo.get(MinecraftProfileTexture.Type.SKIN));
            }
            return Optional.empty();
        });
    }
}

