/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GlacialShatterIndicatorRenderer {
    public static void render(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, Quaternion cameraOrientation) {
        LivingEntity livingEntity;
        if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_(ModEffects.GLACIAL_SHATTER)) {
            return;
        }
        if (livingEntity.m_21224_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-((LivingEntity)entity).f_20883_));
        poseStack.m_85837_(-0.5, (double)0.1f, -0.5);
        Minecraft.m_91087_().m_91289_().renderSingleBlock(Blocks.f_50126_.m_49966_(), poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        float height = 1.0f;
        while (height + 0.5f < entity.m_20206_()) {
            poseStack.m_85837_(0.0, 1.0, 0.0);
            Minecraft.m_91087_().m_91289_().renderSingleBlock(Blocks.f_50126_.m_49966_(), poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            if (!((height += 1.0f) > 6.0f)) continue;
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (height > entity.m_20206_()) {
            poseStack.m_85837_(0.0, (double)height + 0.5, 0.0);
        } else {
            poseStack.m_85837_(0.0, (double)entity.m_20206_() + 0.5, 0.0);
        }
        poseStack.m_85845_(cameraOrientation);
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.GLACIAL_SHATTER_INDICATOR);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float size = 10.0f;
        buffer.m_85982_(matrix, -size, -size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_85982_(matrix, -size, size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_85982_(matrix, size, size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_85982_(matrix, size, -size, 0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.f_19853_.f_46443_) {
                ParticleEngine pm;
                Particle particle;
                if (livingEntity.m_21023_(ModEffects.GLACIAL_SHATTER) && !livingEntity.m_21224_() && livingEntity.f_19853_.f_46441_.nextInt(2) == 0 && (particle = (pm = Minecraft.m_91087_().f_91061_).m_107370_((ParticleOptions)ModParticles.NOVA_SPEED.get(), livingEntity.m_20182_().f_82479_ - (double)((livingEntity.m_20205_() + 0.5f) / 2.0f) + (double)((livingEntity.m_20205_() + 1.0f) * livingEntity.f_19853_.f_46441_.nextFloat()), livingEntity.m_20182_().f_82480_ + (double)((livingEntity.m_20206_() + 1.0f) * livingEntity.f_19853_.f_46441_.nextFloat()), livingEntity.m_20182_().f_82481_ - (double)((livingEntity.m_20205_() + 0.5f) / 2.0f) + (double)((livingEntity.m_20205_() + 1.0f) * livingEntity.f_19853_.f_46441_.nextFloat()), 0.0, 0.0, 0.0)) != null) {
                    particle.m_172260_((Math.random() - 0.5) * (double)0.1f, -0.1, (Math.random() - 0.5) * (double)0.1f);
                }
                if (livingEntity.m_21023_(ModEffects.CHILLED) && !livingEntity.m_21224_()) {
                    float angle = (float)Math.PI + (float)livingEntity.f_19797_ / 2.0f;
                    float radius = livingEntity.m_20205_() / 2.0f;
                    float x = (float)(livingEntity.m_20182_().m_7096_() + (double)radius * Math.cos(angle));
                    float y = (float)(livingEntity.m_20182_().m_7098_() + (double)(0.2f * livingEntity.m_21187_().nextFloat()));
                    float z = (float)(livingEntity.m_20182_().m_7094_() + (double)radius * Math.sin(angle));
                    livingEntity.f_19853_.m_7106_((ParticleOptions)ModParticles.NOVA_SPEED.get(), (double)x, (double)y, (double)z, (Math.random() - 0.5) * (double)0.01f, 0.0, (Math.random() - 0.5) * (double)0.01f);
                }
            }
        }
    }
}

