/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import net.minecraft.client.Minecraft;

public record HudPosition(float xPct, float yPct) {
    public static HudPosition fromPixels(int x, int y, int screenWidth, int screenHeight) {
        float xp = screenWidth == 0 ? 0.0f : (float)x / (float)screenWidth;
        float yp = screenHeight == 0 ? 0.0f : (float)y / (float)screenHeight;
        return new HudPosition(xp, yp);
    }

    public String serialize() {
        return this.xPct + "," + this.yPct;
    }

    public static HudPosition deserialize(String serialized) {
        String[] parts = serialized.split(",");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid serialized HudPosition:" + serialized);
        }
        try {
            float x = Float.parseFloat(parts[0]);
            float y = Float.parseFloat(parts[1]);
            return new HudPosition(x, y);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format in HudPosition: " + serialized, e);
        }
    }

    public int getScaledX() {
        return this.getScaledX(Minecraft.m_91087_().m_91268_().m_85445_());
    }

    public int getScaledY() {
        return this.getScaledY(Minecraft.m_91087_().m_91268_().m_85446_());
    }

    public int getScaledX(int screenWidth) {
        return Math.round(this.xPct * (float)screenWidth);
    }

    public int getScaledY(int screenHeight) {
        return Math.round(this.yPct * (float)screenHeight);
    }
}

