/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.render.hunter.HunterOutlineMode;
import iskallia.vault.client.util.FrustumSource;
import iskallia.vault.init.ModOptions;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HunterOutlineRenderer {
    private static final VoxelShape CUBE_SMALL = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    private static final List<HighlightBatch> BATCHES = new ArrayList<HighlightBatch>();
    private static final Map<BlockPos, HighlightPosition> POSITIONS = new ConcurrentHashMap<BlockPos, HighlightPosition>();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Iterator<HighlightBatch> iterator = BATCHES.iterator();
        while (iterator.hasNext()) {
            HighlightBatch batch = iterator.next();
            if (level != null && batch.expireAge > level.m_46467_()) continue;
            POSITIONS.values().removeAll(batch.positions);
            iterator.remove();
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(WorldEvent.Unload event) {
        BATCHES.clear();
        POSITIONS.clear();
    }

    @SubscribeEvent
    public static void renderHunterOutlines(RenderLevelLastEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || POSITIONS.isEmpty()) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        poseStack.m_85850_().m_85861_().m_162210_(event.getPoseStack().m_85850_().m_85861_());
        poseStack.m_85836_();
        RenderSystem.m_69465_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 view = camera.m_90583_();
        Frustum frustum = ((FrustumSource)minecraft.f_91060_).getFrustum();
        poseStack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        MultiBufferSource.BufferSource source = minecraft.m_91269_().m_110104_();
        RenderType renderType = ModOptions.HUNTER_OUTLINE_THICKNESS.getValue().renderType;
        VertexConsumer buffer = source.m_6299_(renderType);
        long gameTime = minecraft.f_91073_.m_46467_();
        for (HighlightPosition position : POSITIONS.values()) {
            AABB boundingBox;
            VoxelShape shape;
            if (position.expireAge <= gameTime) continue;
            BlockPos pos = position.blockPos;
            BlockState state = minecraft.f_91073_.m_8055_(pos);
            if (state.m_60795_()) {
                if (!position.rendered) continue;
                if (position.expireAge - gameTime > (long)position.fadeTicks) {
                    position.expireAge = gameTime + (long)position.fadeTicks;
                }
            }
            if ((shape = (switch (ModOptions.HUNTER_OUTLINE_MODE.getValue()) {
                default -> throw new IncompatibleClassChangeError();
                case HunterOutlineMode.DETAILED -> {
                    if (position.shape == null) {
                        position.shape = state.m_60795_() ? Shapes.m_83144_() : state.m_60812_((BlockGetter)minecraft.f_91073_, position.blockPos);
                    }
                    yield position.shape;
                }
                case HunterOutlineMode.CUBE -> Shapes.m_83144_();
                case HunterOutlineMode.CUBE_SMALL -> CUBE_SMALL;
            })).m_83281_() || !frustum.m_113029_(boundingBox = shape.m_83215_().m_82338_(pos))) continue;
            int alpha = -16777216;
            long ageDelta = position.expireAge - gameTime;
            long durationDelta = gameTime - position.startAge();
            if (durationDelta <= (long)position.fadeTicks) {
                alpha = (int)(255.0 * ((double)durationDelta / (double)position.fadeTicks)) << 24;
            }
            if (ageDelta <= (long)position.fadeTicks) {
                alpha = (int)(255.0 * ((double)ageDelta / (double)position.fadeTicks)) << 24;
            }
            position.rendered = true;
            HunterOutlineRenderer.renderShape(poseStack, buffer, shape, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), position.color & 0xFFFFFF | alpha);
        }
        source.m_109912_(renderType);
        poseStack.m_85849_();
        RenderSystem.m_69482_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderShape(PoseStack pPoseStack, VertexConsumer buffer, VoxelShape pShape, double pX, double pY, double pZ, int color) {
        PoseStack.Pose pose = pPoseStack.m_85850_();
        pShape.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float dX = (float)(maxX - minX);
            float dY = (float)(maxY - minY);
            float dZ = (float)(maxZ - minZ);
            float dA = Mth.m_14116_((float)(dX * dX + dY * dY + dZ * dZ));
            buffer.m_85982_(pose.m_85861_(), (float)(minX + pX), (float)(minY + pY), (float)(minZ + pZ)).m_193479_(color).m_85977_(pose.m_85864_(), dX /= dA, dY /= dA, dZ /= dA).m_5752_();
            buffer.m_85982_(pose.m_85861_(), (float)(maxX + pX), (float)(maxY + pY), (float)(maxZ + pZ)).m_193479_(color).m_85977_(pose.m_85864_(), dX, dY, dZ).m_5752_();
        });
    }

    public static void addHighlightPositions(Collection<HunterAbility.HighlightPosition> positions, int duration) {
        if (Minecraft.m_91087_().f_91073_ == null || positions.isEmpty()) {
            return;
        }
        long startAge = Minecraft.m_91087_().f_91073_.m_46467_();
        long expireAge = Minecraft.m_91087_().f_91073_.m_46467_() + (long)duration;
        ArrayList<HighlightPosition> batchPositions = new ArrayList<HighlightPosition>();
        for (HunterAbility.HighlightPosition vhPosition : positions) {
            HighlightPosition old = POSITIONS.get(vhPosition.blockPos());
            HighlightPosition position = new HighlightPosition(vhPosition.blockPos(), ModOptions.getHunterColor(vhPosition.target(), vhPosition.color()), Math.floorDiv(duration, 4), old != null ? old.startAge() : startAge, expireAge);
            if (old != null && old.rendered) {
                position.rendered = true;
            }
            POSITIONS.put(position.blockPos, position);
            batchPositions.add(position);
        }
        BATCHES.add(new HighlightBatch(batchPositions, expireAge));
    }

    private record HighlightBatch(Collection<HighlightPosition> positions, long expireAge) {
    }

    private static class HighlightPosition {
        private final BlockPos blockPos;
        private final int color;
        private final int fadeTicks;
        private long startAge;
        private long expireAge;
        private VoxelShape shape;
        private boolean rendered = false;

        public HighlightPosition(BlockPos blockPos, int color, int fadeTicks, long startAge, long expireAge) {
            this.blockPos = blockPos;
            this.color = color;
            this.fadeTicks = fadeTicks;
            this.startAge = startAge;
            this.expireAge = expireAge;
        }

        public long startAge() {
            if (!this.rendered) {
                this.startAge = Minecraft.m_91087_().f_91073_.m_46467_();
            }
            return this.startAge;
        }
    }
}

