/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.overlay.PotionStatusOverlay;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.config.VaultModifierOverlayConfig;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.gear.VaultCharmItem;
import iskallia.vault.item.gear.VaultNecklaceItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class InventoryHudRenderer {
    public static final List<String> HUD_KEYS = List.of("helmet", "chestplate", "leggings", "boots", "trinket_1", "trinket_2", "void_stone", "god_charm", "magnet", "backpack", "potions", "modifiers", "ability_bar", "cooldowns", "timer");
    public static final List<String> DURABILITY_KEYS = List.of("helmet", "chestplate", "leggings", "boots", "magnet");
    public static final List<String> USES_KEYS = List.of("trinket_1", "trinket_2", "void_stone", "god_charm");
    private static long lastPortalCheckTick = 0L;
    private static boolean nearPortal = false;

    public static void render(PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        IVaultOptions options = (IVaultOptions)minecraft.f_91066_;
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (options.getShowPotionVisibility()) {
            InventoryHudRenderer.renderPotionStatus(poseStack);
        }
        if (options.isShowHudOnlyOnTab() && !ModKeybinds.holdShowHud.m_90857_()) {
            return;
        }
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        Font font = minecraft.f_91062_;
        InventoryHudRenderer.renderDurabilityItems(options, poseStack, font, player, screenWidth, screenHeight);
        InventoryHudRenderer.renderUsesItems(poseStack, player);
        InventoryHudRenderer.renderBackpackItem(poseStack, player, screenWidth, screenHeight);
    }

    public static void renderDurabilityItems(IVaultOptions options, PoseStack poseStack, Font font, @NotNull LocalPlayer player, int screenWidth, int screenHeight) {
        IVaultOptions.GearVisibilityMode gearMode = options.getGearVisibilityMode();
        if (gearMode == IVaultOptions.GearVisibilityMode.NONE) {
            return;
        }
        InventoryHudDisplayMode displayTime = options.getInventoryHudMode();
        PositionMode percentageMode = options.getInventoryHudPercentageDisplayMode();
        float scale = options.getInvHudScale();
        for (String key : DURABILITY_KEYS) {
            boolean shouldShow;
            HudPosition hudPosition = options.getHudPositions().getOrDefault(key, InventoryHudRenderer.computeDefaultHudPosition(key, screenWidth, screenHeight));
            int iconX = hudPosition.getScaledX(screenWidth);
            int iconY = hudPosition.getScaledY(screenHeight);
            ItemStack stack = InventoryHudRenderer.fetchStackForKey((Player)player, key);
            if (stack.m_41619_()) continue;
            float usePercentage = 1.0f;
            if (stack.m_41720_() instanceof ArmorItem || stack.m_41720_() instanceof MagnetItem) {
                int maxDurability = stack.m_41776_();
                int currentDamage = stack.m_41773_();
                usePercentage = (float)(maxDurability - currentDamage) / (float)maxDurability;
            }
            switch (displayTime) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case OFF: {
                    boolean bl = false;
                    break;
                }
                case ALWAYS: {
                    boolean bl = true;
                    break;
                }
                case LOW: {
                    boolean bl;
                    if ((double)usePercentage <= 0.25) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case VERY_LOW: {
                    boolean bl = shouldShow = (double)usePercentage <= 0.1;
                }
            }
            if (!shouldShow) continue;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, -10.0);
            if (options.getGearVisibilityMode().equals((Object)IVaultOptions.GearVisibilityMode.OVERLAY)) {
                InventoryHudRenderer.renderOverlayItem(poseStack, key, iconX, iconY, usePercentage, scale);
            } else {
                InventoryHudRenderer.renderScaledGuiItem(poseStack, stack, iconX, iconY, scale);
            }
            if (percentageMode != PositionMode.OFF) {
                poseStack.m_85836_();
                poseStack.m_85841_(scale, scale, 1.0f);
                InventoryHudRenderer.renderPercentageText(poseStack, stack, (int)((float)iconX / scale), (int)((float)iconY / scale), font, percentageMode, usePercentage, scale);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    public static void renderUsesItems(PoseStack poseStack, @NotNull LocalPlayer player) {
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        IVaultOptions.UsesVisibilityMode usesVisibilityMode = options.getUsesVisibilityMode();
        if (usesVisibilityMode == IVaultOptions.UsesVisibilityMode.NONE) {
            return;
        }
        InventoryHudDisplayMode usesShowMode = options.getInventoryUsesHudMode();
        PositionMode usesItemsTextPositionMode = options.getUsesItemsTextPositionMode();
        float scale = options.getInvHudScale();
        if (VaultUtils.getVault(player.f_19853_).map(VaultUtils::isRoyaleVault).orElse(false).booleanValue()) {
            return;
        }
        for (String key : USES_KEYS) {
            boolean shouldShow;
            HudPosition hudPosition = options.getHudPositions().getOrDefault(key, InventoryHudRenderer.computeDefaultHudPosition(key, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_()));
            int iconX = hudPosition.getScaledX(Minecraft.m_91087_().m_91268_().m_85445_());
            int iconY = hudPosition.getScaledY(Minecraft.m_91087_().m_91268_().m_85446_());
            ItemStack stack = InventoryHudRenderer.fetchStackForKey((Player)player, key);
            if (stack.m_41619_()) continue;
            int uses = 0;
            int used = 0;
            int maxUses = 0;
            if (stack.m_150930_((Item)ModItems.TRINKET)) {
                used = TrinketItem.getUsedVaults(stack).size();
                maxUses = TrinketItem.getUses(stack);
            } else if (stack.m_150930_((Item)ModItems.VAULT_GOD_CHARM)) {
                used = VaultCharmItem.getUsedVaults(stack).size();
                maxUses = VaultCharmItem.getUses(stack);
            } else if (stack.m_150930_((Item)ModItems.VAULT_NECKLACE)) {
                used = VaultNecklaceItem.getUsedVaults(stack).size();
                maxUses = VaultNecklaceItem.getUses(stack);
            }
            uses = maxUses - used;
            if (!(shouldShow = (switch (usesShowMode) {
                default -> throw new IncompatibleClassChangeError();
                case InventoryHudDisplayMode.OFF -> false;
                case InventoryHudDisplayMode.ALWAYS -> true;
                case InventoryHudDisplayMode.LOW -> {
                    if (uses <= 5) {
                        yield true;
                    }
                    yield false;
                }
                case InventoryHudDisplayMode.VERY_LOW -> uses <= 2;
            })) || uses < 0) continue;
            poseStack.m_85836_();
            PoseStack matrixStack = RenderSystem.m_157191_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)iconX, (double)iconY, -256.0);
            matrixStack.m_85841_(scale, scale, 1.0f);
            RenderSystem.m_157182_();
            Minecraft.m_91087_().m_91291_().m_115203_(stack, 0, 0);
            matrixStack.m_85849_();
            RenderSystem.m_157182_();
            if (usesVisibilityMode == IVaultOptions.UsesVisibilityMode.BAR && maxUses - uses > 0) {
                InventoryHudRenderer.renderUsesBar(poseStack, stack, iconX, iconY, scale);
            }
            if (usesVisibilityMode.equals((Object)IVaultOptions.UsesVisibilityMode.NUMBER)) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 255.0);
                poseStack.m_85841_(scale, scale, 1.0f);
                InventoryHudRenderer.renderUsesText(poseStack, stack, (int)((float)iconX / scale), (int)((float)iconY / scale), Minecraft.m_91087_().f_91062_, usesItemsTextPositionMode, uses, maxUses, scale);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    private static void renderOverlayItem(PoseStack poseStack, String key, int iconX, int iconY, float usePercentage, float scale) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)iconX, (double)iconY, 0.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        ResourceLocation baseTexture = VaultMod.id("textures/gui/inventory_hud/" + key + "_base.png");
        ResourceLocation overlayTexture = VaultMod.id("textures/gui/inventory_hud/" + key + "_overlay.png");
        RenderSystem.m_157456_((int)0, (ResourceLocation)baseTexture);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        RenderSystem.m_157456_((int)0, (ResourceLocation)overlayTexture);
        int durabilityPercentageOutOf16 = (int)(usePercentage * 16.0f);
        Gui.m_93133_((PoseStack)poseStack, (int)0, (int)(16 - durabilityPercentageOutOf16), (float)0.0f, (float)(16 - durabilityPercentageOutOf16), (int)16, (int)durabilityPercentageOutOf16, (int)16, (int)16);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        poseStack.m_85849_();
    }

    private static void renderScaledGuiItem(PoseStack poseStack, ItemStack stack, int x, int y, float scale) {
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, -256.0);
        matrixStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157182_();
        Minecraft.m_91087_().m_91291_().m_115203_(stack, 0, 0);
        Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, stack, 0, 0);
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static void renderUsesBar(PoseStack poseStack, ItemStack stack, int iconX, int iconY, float scale) {
        RenderSystem.m_69465_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        int barWidth = stack.m_150948_();
        int barColor = stack.m_150949_();
        int scaledX = (int)((float)iconX + 2.0f * scale);
        int scaledY = (int)((float)iconY + 13.0f * scale);
        int scaledBarWidth = (int)(13.0f * scale);
        int scaledBarHeight = (int)(2.0f * scale);
        int scaledBarWidthFilled = (int)((float)barWidth * scale);
        InventoryHudRenderer.fillRect(bufferbuilder, scaledX, scaledY, scaledBarWidth, scaledBarHeight, 0, 0, 0, 255);
        InventoryHudRenderer.fillRect(bufferbuilder, scaledX, scaledY, scaledBarWidthFilled, (int)(1.0f * scale), barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
    }

    private static void fillRect(BufferBuilder pRenderer, int pX, int pY, int pWidth, int pHeight, int pRed, int pGreen, int pBlue, int pAlpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        pRenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        pRenderer.m_5483_((double)pX, (double)pY, 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)pX, (double)(pY + pHeight), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + pWidth), (double)(pY + pHeight), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + pWidth), (double)pY, 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)pRenderer);
    }

    public static void renderPotionStatus(PoseStack poseStack) {
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        if (options.getShowPotionVisibility()) {
            PotionStatusOverlay.render(poseStack);
        }
    }

    private static ItemStack fetchStackForKey(Player player, String key) {
        return switch (key) {
            case "helmet" -> player.m_150109_().m_36052_(3);
            case "chestplate" -> player.m_150109_().m_36052_(2);
            case "leggings" -> player.m_150109_().m_36052_(1);
            case "boots" -> player.m_150109_().m_36052_(0);
            case "trinket_1" -> InventoryHudRenderer.getCurioByIndex(player, ModItems.TRINKET, 0);
            case "trinket_2" -> InventoryHudRenderer.getCurioByIndex(player, ModItems.TRINKET, 1);
            case "void_stone" -> InventoryHudRenderer.getCurioByIndex(player, ModItems.VAULT_NECKLACE, 0);
            case "god_charm" -> InventoryHudRenderer.getCurioByIndex(player, ModItems.VAULT_GOD_CHARM, 0);
            case "magnet" -> InventoryHudRenderer.getCurioByIndex(player, ModItems.MAGNET, 0);
            default -> ItemStack.f_41583_;
        };
    }

    private static ItemStack getCurioByIndex(Player player, Item vaultItem, int index) {
        List slots = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, vaultItem);
        if (index < 0 || index >= slots.size()) {
            return ItemStack.f_41583_;
        }
        return ((SlotResult)slots.get(index)).stack();
    }

    private static void renderPercentageText(PoseStack poseStack, ItemStack stack, int iconX, int iconY, Font font, PositionMode mode, float usePercentage, float scale) {
        VaultGearItem item;
        int percent = (int)(usePercentage * 100.0f);
        int color = percent < 5 ? 0xDA0000 : (percent < 20 ? 14305280 : (percent < 40 ? 14322176 : (percent < 60 ? 16641536 : (percent < 80 ? 0xD0FD00 : 8649984))));
        Object text = percent + "%";
        Item item2 = stack.m_41720_();
        if (item2 instanceof VaultGearItem && (item = (VaultGearItem)item2).isBroken(stack)) {
            text = "BROKEN";
            color = 0xDA0000;
        }
        int scaledIconSize = 16;
        int textOffsetX = 18;
        int textOffsetY = 4;
        int belowOffsetY = 18;
        int aboveOffsetY = -10;
        switch (mode) {
            case RIGHT: {
                font.m_92750_(poseStack, (String)text, (float)(iconX + textOffsetX), (float)(iconY + textOffsetY), color);
                break;
            }
            case LEFT: {
                font.m_92750_(poseStack, (String)text, (float)(iconX - font.m_92895_((String)text) - 2), (float)(iconY + textOffsetY), color);
                break;
            }
            case BELOW: {
                font.m_92750_(poseStack, (String)text, (float)(iconX + scaledIconSize / 2 - font.m_92895_((String)text) / 2), (float)(iconY + belowOffsetY), color);
                break;
            }
            case ABOVE: {
                font.m_92750_(poseStack, (String)text, (float)(iconX + scaledIconSize / 2 - font.m_92895_((String)text) / 2), (float)(iconY + aboveOffsetY), color);
                break;
            }
            case ONTOP: {
                float f = iconX + textOffsetX - font.m_92895_((String)text);
                Objects.requireNonNull(font);
                font.m_92750_(poseStack, (String)text, f, (float)(iconY + textOffsetY - 9), color);
                break;
            }
        }
    }

    private static void renderUsesText(PoseStack poseStack, ItemStack stack, int iconX, int iconY, Font font, PositionMode mode, int uses, int maxUses, float scale) {
        float percent = (float)uses / (float)maxUses * 100.0f;
        int color = percent < 5.0f ? 0xDA0000 : (percent < 20.0f ? 14305280 : (percent < 40.0f ? 14322176 : (percent < 60.0f ? 16641536 : (percent < 80.0f ? 0xD0FD00 : 8649984))));
        String text = String.valueOf(uses);
        int scaledIconSize = 16;
        int textOffsetX = 18;
        int textOffsetY = 4;
        int belowOffsetY = 18;
        int aboveOffsetY = -10;
        switch (mode) {
            case RIGHT: {
                font.m_92750_(poseStack, text, (float)(iconX + textOffsetX), (float)(iconY + textOffsetY), color);
                break;
            }
            case LEFT: {
                font.m_92750_(poseStack, text, (float)(iconX - font.m_92895_(text) - 2), (float)(iconY + textOffsetY), color);
                break;
            }
            case BELOW: {
                font.m_92750_(poseStack, text, (float)(iconX + scaledIconSize / 2 - font.m_92895_(text) / 2), (float)(iconY + belowOffsetY), color);
                break;
            }
            case ABOVE: {
                font.m_92750_(poseStack, text, (float)(iconX + scaledIconSize / 2 - font.m_92895_(text) / 2), (float)(iconY + aboveOffsetY), color);
                break;
            }
            case ONTOP: {
                float f = iconX + scaledIconSize - font.m_92895_(text);
                Objects.requireNonNull(font);
                font.m_92750_(poseStack, text, f, (float)(iconY + scaledIconSize - 9), color);
                break;
            }
        }
    }

    public static void renderBackpackItem(PoseStack poseStack, @NotNull LocalPlayer player, int screenWidth, int screenHeight) {
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        BackpackDisplayMode mode = options.getBackpackHudMode();
        float scale = options.getInvHudScale();
        InventoryHudRenderer.updatePortalProximity((Player)player);
        HudPosition pos = options.getHudPositions().getOrDefault("backpack", InventoryHudRenderer.computeDefaultHudPosition("backpack", screenWidth, screenHeight));
        ItemStack stack = InventoryHudRenderer.getBackSlotItem((Player)player);
        if (mode == BackpackDisplayMode.NONE) {
            return;
        }
        if (stack.m_41619_() && nearPortal) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.getScaledX(screenWidth), (double)pos.getScaledY(screenHeight), 0.0);
            TextComponent text = new TextComponent("Missing Backpack");
            Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)text, (float)(-Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text)) / 2.0f, 0.0f, 0xFF0000);
            poseStack.m_85849_();
        }
    }

    private static ItemStack getBackSlotItem(Player player) {
        return IntegrationCurios.getCurioItemStack((LivingEntity)player, "back", 0);
    }

    private static ItemStack findBackpackInInventory(Player player) {
        if (ModList.get().isLoaded("sophisticatedbackpacksvh")) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof BackpackItem)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    private static void updatePortalProximity(Player player) {
        long gameTime = player.f_19853_.m_46467_();
        if (gameTime - lastPortalCheckTick > 20L) {
            lastPortalCheckTick = gameTime;
            nearPortal = InventoryHudRenderer.isNearPortal(player);
        }
    }

    private static boolean isNearPortal(Player player) {
        if (VaultUtils.getVault(player.m_183503_()).isPresent()) {
            return false;
        }
        BlockPos pos = player.m_142538_();
        int radius = 4;
        for (BlockPos bp : BlockPos.m_121940_((BlockPos)pos.m_142082_(-radius, -radius, -radius), (BlockPos)pos.m_142082_(radius, radius, radius))) {
            if (!player.f_19853_.m_8055_(bp).m_60713_((Block)ModBlocks.VAULT_PORTAL)) continue;
            return true;
        }
        return false;
    }

    public static HudPosition computeDefaultHudPosition(String key, int screenWidth, int screenHeight) {
        int centerX = screenWidth / 2;
        return switch (key) {
            case "helmet" -> HudPosition.fromPixels(centerX - 163, screenHeight - 68, screenWidth, screenHeight);
            case "chestplate" -> HudPosition.fromPixels(centerX - 163, screenHeight - 52, screenWidth, screenHeight);
            case "leggings" -> HudPosition.fromPixels(centerX - 163, screenHeight - 36, screenWidth, screenHeight);
            case "boots" -> HudPosition.fromPixels(centerX - 163, screenHeight - 20, screenWidth, screenHeight);
            case "trinket_1" -> HudPosition.fromPixels(centerX + 91, screenHeight - 20, screenWidth, screenHeight);
            case "trinket_2" -> HudPosition.fromPixels(centerX + 91 + 18, screenHeight - 20, screenWidth, screenHeight);
            case "void_stone" -> HudPosition.fromPixels(centerX + 91 + 36, screenHeight - 20, screenWidth, screenHeight);
            case "god_charm" -> HudPosition.fromPixels(centerX + 91 + 54, screenHeight - 20, screenWidth, screenHeight);
            case "magnet" -> HudPosition.fromPixels(centerX + 91 + 72, screenHeight - 20, screenWidth, screenHeight);
            case "backpack" -> HudPosition.fromPixels(centerX + 91 + 90, screenHeight - 20, screenWidth, screenHeight);
            case "potions" -> HudPosition.fromPixels(screenWidth - 4, 4, screenWidth, screenHeight);
            case "modifiers" -> {
                VaultModifierOverlayConfig cfg = ModConfigs.VAULT_MODIFIER_OVERLAY;
                int x = screenWidth - cfg.rightMargin - cfg.size;
                int y = screenHeight - cfg.bottomMargin - cfg.size;
                yield HudPosition.fromPixels(x, y, screenWidth, screenHeight);
            }
            case "ability_bar" -> HudPosition.fromPixels(10, screenHeight - 36, screenWidth, screenHeight);
            default -> HudPosition.fromPixels(0, 0, screenWidth, screenHeight);
        };
    }

    public static enum InventoryHudDisplayMode {
        OFF("OFF"),
        VERY_LOW("VERY LOW"),
        LOW("LOW"),
        ALWAYS("ALWAYS");

        private final String serializedName;

        private InventoryHudDisplayMode(String name) {
            this.serializedName = name;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public static InventoryHudDisplayMode fromString(String name) {
            for (InventoryHudDisplayMode mode : InventoryHudDisplayMode.values()) {
                if (!mode.serializedName.equalsIgnoreCase(name)) continue;
                return mode;
            }
            return ALWAYS;
        }

        public InventoryHudDisplayMode cycle() {
            InventoryHudDisplayMode[] values = InventoryHudDisplayMode.values();
            int index = (this.ordinal() + 1) % values.length;
            return values[index];
        }
    }

    public static enum PositionMode {
        OFF("OFF"),
        RIGHT("RIGHT"),
        LEFT("LEFT"),
        BELOW("BELOW"),
        ABOVE("ABOVE"),
        ONTOP("ONTOP");

        private final String serializedName;

        private PositionMode(String name) {
            this.serializedName = name;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public static PositionMode fromString(String name) {
            for (PositionMode mode : PositionMode.values()) {
                if (!mode.serializedName.equalsIgnoreCase(name)) continue;
                return mode;
            }
            return OFF;
        }

        public PositionMode cycle() {
            PositionMode[] values = PositionMode.values();
            int index = (this.ordinal() + 1) % values.length;
            return values[index];
        }
    }

    public static enum BackpackDisplayMode {
        NONE("NONE"),
        NEAR_PORTAL("NEAR PORTAL");

        private final String serializedName;

        private BackpackDisplayMode(String name) {
            this.serializedName = name;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public static BackpackDisplayMode fromString(String name) {
            for (BackpackDisplayMode mode : BackpackDisplayMode.values()) {
                if (!mode.serializedName.equalsIgnoreCase(name)) continue;
                return mode;
            }
            return NEAR_PORTAL;
        }

        public BackpackDisplayMode cycle() {
            BackpackDisplayMode[] values = BackpackDisplayMode.values();
            int index = (this.ordinal() + 1) % values.length;
            return values[index];
        }
    }
}

