/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import iskallia.vault.init.ModParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PotionAuraRenderer {
    public static final PotionAuraRenderer INSTANCE = new PotionAuraRenderer();

    private PotionAuraRenderer() {
    }

    public void render(Entity entity, MobEffect mobEffect, int range) {
        this.render(entity, mobEffect, range, false);
    }

    public void render(Entity entity, MobEffect mobEffect, int range, boolean invertEffectRange) {
        if (mobEffect == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (minecraft.m_91104_() || player == null || !PotionAuraRenderer.isWithinRenderableDistance(entity, range, player, invertEffectRange)) {
            return;
        }
        int color = mobEffect.m_19484_();
        float red = (float)(color >>> 16 & 0xFF) / 255.0f;
        float green = (float)(color >>> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (invertEffectRange) {
            for (int i = 0; i < 10; ++i) {
                int randomRange = player.f_19853_.f_46441_.nextInt(range, 64);
                PotionAuraRenderer.createParticle(entity, randomRange, red, green, blue);
            }
        } else {
            PotionAuraRenderer.createParticle(entity, range, red, green, blue);
        }
    }

    private static boolean isWithinRenderableDistance(Entity entity, int range, LocalPlayer player, boolean invertEffectRange) {
        if (invertEffectRange) {
            return player.m_20270_(entity) < 64.0f;
        }
        return player.m_20270_(entity) < (float)Math.max(range * 2, range + 5);
    }

    private static void createParticle(Entity entity, int range, float red, float green, float blue) {
        Vec3 offset = new Vec3((double)range, 0.0, 0.0).m_82524_(entity.f_19853_.m_5822_().nextFloat((float)Math.PI * 2));
        Vec3 pos = entity.m_20182_().m_82549_(offset);
        ParticleEngine pm = Minecraft.m_91087_().f_91061_;
        Particle particle = pm.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), pos.f_82479_, pos.f_82480_ + (double)0.2f, pos.f_82481_, 0.0, 0.0, 0.0);
        if (particle != null) {
            particle.m_107253_(red, green, blue);
        }
        for (int i = 0; i < 3; ++i) {
            offset = new Vec3((double)range, (double)0.1f, 0.0).m_82524_((float)Math.toRadians((float)(entity.f_19797_ % 90) * 4.0f + (float)(120 * i)));
            pos = entity.m_20182_().m_82549_(offset);
            particle = pm.m_107370_((ParticleOptions)ModParticles.CHAINING.get(), pos.f_82479_, pos.f_82480_ + (double)0.2f, pos.f_82481_, 0.0, 0.0, 0.0);
            if (particle == null) continue;
            particle.m_107253_(Mth.m_14036_((float)(red * 1.25f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(green * 1.25f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(blue * 1.25f), (float)0.0f, (float)1.0f));
        }
    }
}

