/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.init.ModRenderTypes;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SpecialEffectsMobRenderer {
    public static final Set<MobEffect> CHAMPION_BUFFS = Set.of(MobEffects.f_19606_, MobEffects.f_19596_, MobEffects.f_19600_);

    public static Stream<MobEffect> getEffects(LivingEntity entity) {
        if (!(entity instanceof Player) && !(entity instanceof EternalEntity) && !(entity instanceof PetEntity) && ChampionLogic.isChampion(entity)) {
            return CHAMPION_BUFFS.stream();
        }
        return Stream.empty();
    }

    public static void render(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, Quaternion cameraOrientation) {
        MobEffectInstance effectInstance;
        LivingEntity livingEntity;
        block7: {
            block6: {
                if (!(entity instanceof LivingEntity)) break block6;
                livingEntity = (LivingEntity)entity;
                if (!ClientVaults.getActive().isEmpty()) break block7;
            }
            return;
        }
        List<MobEffect> buffs = SpecialEffectsMobRenderer.getEffects(livingEntity).toList();
        if (buffs.isEmpty()) {
            return;
        }
        int effects = 0;
        int i = 0;
        for (MobEffect buff : buffs) {
            effectInstance = livingEntity.m_21124_(buff);
            if (effectInstance == null) continue;
            ++effects;
        }
        for (MobEffect buff : buffs) {
            effectInstance = livingEntity.m_21124_(buff);
            if (effectInstance == null) continue;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)entity.m_20206_() + 0.5, 0.0);
            poseStack.m_85845_(cameraOrientation);
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.CHAMPION_BUFF_FG_INDICATOR);
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            int size = 10;
            RenderSystem.m_69482_();
            effectInstance.m_19544_();
            TextureAtlasSprite icon = Minecraft.m_91087_().m_91306_().m_118732_(effectInstance.m_19544_());
            RenderSystem.m_157456_((int)0, (ResourceLocation)icon.m_118414_().m_118330_());
            GuiComponent.m_93200_((PoseStack)poseStack, (int)(1 - effects * 10 + i * 20), (int)(-size + 1), (int)0, (int)icon.m_118405_(), (int)icon.m_118408_(), (TextureAtlasSprite)icon);
            float x1 = -(effects * 10) + i * 20;
            float x2 = x1 + (float)(size * 2);
            float y1 = -size;
            float y2 = y1 + (float)(size * 2);
            buffer.m_85982_(matrix, x1, y1, -0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(matrix, x1, y2, -0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(matrix, x2, y2, -0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
            buffer.m_85982_(matrix, x2, y1, -0.01f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            VertexConsumer buffer_bg = bufferSource.m_6299_(ModRenderTypes.CHAMPION_BUFF_BG_INDICATOR);
            buffer_bg.m_85982_(matrix, x1, y1, 0.25f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            buffer_bg.m_85982_(matrix, x1, y2, 0.25f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
            buffer_bg.m_85982_(matrix, x2, y2, 0.25f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
            buffer_bg.m_85982_(matrix, x2, y1, 0.25f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            poseStack.m_85849_();
            ++i;
        }
    }
}

