/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.render.TextureRegion;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class TextureRegionRenderer {
    private static final TextureRegionRenderer INSTANCE = new TextureRegionRenderer();
    private static final PoseStack IDENTITY_MATRIX_STACK = new PoseStack();
    private PoseStack poseStack = IDENTITY_MATRIX_STACK;
    private BufferBuilder bufferBuilder;
    private ResourceLocation textureAtlas;
    private int atlasWidth;
    private int atlasHeight;

    public static TextureRegionRenderer getInstance() {
        return INSTANCE;
    }

    private TextureRegionRenderer() {
    }

    public TextureRegionRenderer begin(ResourceLocation textureAtlas) {
        return this.begin(textureAtlas, 256, 256);
    }

    public TextureRegionRenderer begin(ResourceLocation textureAtlas, int atlasWidth, int atlasHeight) {
        if (this.bufferBuilder != null) {
            throw new IllegalStateException("Already building!");
        }
        this.textureAtlas = textureAtlas;
        this.atlasWidth = atlasWidth;
        this.atlasHeight = atlasHeight;
        this.bufferBuilder = Tesselator.m_85913_().m_85915_();
        this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        return this;
    }

    public TextureRegionRenderer with(PoseStack poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public TextureRegionRenderer identity() {
        return this.with(IDENTITY_MATRIX_STACK);
    }

    public TextureRegionRenderer push() {
        this.poseStack.m_85836_();
        return this;
    }

    public TextureRegionRenderer pop() {
        this.poseStack.m_85849_();
        return this;
    }

    public TextureRegionRenderer translateX(double x) {
        return this.translate(x, 0.0, 0.0);
    }

    public TextureRegionRenderer translateY(double y) {
        return this.translate(0.0, y, 0.0);
    }

    public TextureRegionRenderer translateZ(double z) {
        return this.translate(0.0, 0.0, z);
    }

    public TextureRegionRenderer translateXY(double x, double y) {
        return this.translate(x, y, 0.0);
    }

    public TextureRegionRenderer translate(double x, double y, double z) {
        this.poseStack.m_85837_(x, y, z);
        return this;
    }

    public TextureRegionRenderer scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public TextureRegionRenderer scaleX(double scale) {
        return this.scale(scale, 1.0, 1.0);
    }

    public TextureRegionRenderer scaleY(double scale) {
        return this.scale(1.0, scale, 1.0);
    }

    public TextureRegionRenderer scale(double x, double y, double z) {
        this.poseStack.m_85841_((float)x, (float)y, (float)z);
        return this;
    }

    public TextureRegionRenderer draw(TextureRegion textureRegion) {
        return this.draw(0.0, 0.0, textureRegion);
    }

    public TextureRegionRenderer draw(double x, double y, TextureRegion textureRegion) {
        return this.draw(this.poseStack.m_85850_().m_85861_(), x, x + (double)textureRegion.width(), y, y + (double)textureRegion.height(), 0.0, (float)textureRegion.x() / (float)this.atlasWidth, (float)(textureRegion.x() + textureRegion.width()) / (float)this.atlasWidth, (float)textureRegion.y() / (float)this.atlasHeight, (float)(textureRegion.y() + textureRegion.height()) / (float)this.atlasHeight);
    }

    private TextureRegionRenderer draw(Matrix4f pMatrix, double pX1, double pX2, double pY1, double pY2, double pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        this.bufferBuilder.m_85982_(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        this.bufferBuilder.m_85982_(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        this.bufferBuilder.m_85982_(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        this.bufferBuilder.m_85982_(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        return this;
    }

    public void end() {
        if (this.bufferBuilder == null) {
            throw new IllegalStateException("Not building!");
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureAtlas);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        this.bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)this.bufferBuilder);
        this.identity();
        this.bufferBuilder = null;
        this.textureAtlas = null;
        this.atlasWidth = 0;
        this.atlasHeight = 0;
    }

    static {
        IDENTITY_MATRIX_STACK.m_166856_();
    }
}

