/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.block.entity.TreasureDoorTileEntity;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.init.ModBlocks;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TreasureDoorTileEntityRenderer
implements BlockEntityRenderer<TreasureDoorTileEntity> {
    private final Font fontRenderer;
    private static final float TEXT_SCALE = 0.0125f;
    private static final float Z_OFFSET = 0.22f;
    private static final int TEXT_COLOR = new Color(230, 230, 230).getRGB();
    private static final double MAX_RENDER_DISTANCE_SQ = 49.0;

    public TreasureDoorTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.fontRenderer = context.m_173586_();
    }

    public void render(TreasureDoorTileEntity doorEntity, float partialTick, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Vec3 blockCenter;
        if (doorEntity.m_58900_().m_61143_((Property)TreasureDoorBlock.f_52730_) != DoubleBlockHalf.UPPER || ((Boolean)doorEntity.m_58900_().m_61143_((Property)TreasureDoorBlock.f_52727_)).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            return;
        }
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        if (!options.isTreasureDoorNamesEnabled()) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        BlockPos blockPos = doorEntity.m_58899_();
        Vec3 playerPos = player.m_20299_(partialTick);
        double distanceSq = playerPos.m_82557_(blockCenter = Vec3.m_82512_((Vec3i)blockPos));
        if (distanceSq > 49.0) {
            return;
        }
        if (!this.hasLineOfSight(minecraft, playerPos, blockCenter)) {
            return;
        }
        matrixStack.m_85836_();
        this.applyFacingRotation(matrixStack, (Direction)doorEntity.m_58900_().m_61143_((Property)TreasureDoorBlock.f_52726_));
        matrixStack.m_85837_(0.5, 0.76, (double)0.22f);
        matrixStack.m_85841_(0.0125f, -0.0125f, 0.0125f);
        String doorType = ((TreasureDoorBlock.Type)((Object)doorEntity.m_58900_().m_61143_(TreasureDoorBlock.TYPE))).toString();
        doorType = this.formatDoorTypeName(doorType);
        FormattedCharSequence formattedText = FormattedCharSequence.m_13714_((String)doorType, (Style)Style.f_131099_);
        float textWidth = this.fontRenderer.m_92724_(formattedText);
        int brightness = 0xF000F0;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        this.fontRenderer.m_92733_(formattedText, -textWidth / 2.0f, 0.0f, TEXT_COLOR, false, matrix4f, buffer, true, 0, brightness);
        matrixStack.m_85849_();
    }

    private boolean hasLineOfSight(Minecraft minecraft, Vec3 playerPos, Vec3 targetPos) {
        if (minecraft.f_91073_ == null) {
            return false;
        }
        if (!minecraft.f_91073_.m_8055_(new BlockPos(targetPos)).m_60713_((Block)ModBlocks.TREASURE_DOOR)) {
            return false;
        }
        Direction doorFacing = (Direction)minecraft.f_91073_.m_8055_(new BlockPos(targetPos)).m_61143_((Property)TreasureDoorBlock.f_52726_);
        Vec3 adjustedTarget = this.offsetPositionByDirection(targetPos, doorFacing.m_122424_(), 0.1);
        ClipContext clipContext = new ClipContext(playerPos, adjustedTarget, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)minecraft.f_91074_);
        BlockHitResult result = minecraft.f_91073_.m_45547_(clipContext);
        return result.m_6662_() == HitResult.Type.MISS || result.m_82425_().equals((Object)new BlockPos(targetPos));
    }

    private Vec3 offsetPositionByDirection(Vec3 pos, Direction direction, double offset) {
        return pos.m_82520_((double)direction.m_122429_() * offset, (double)direction.m_122430_() * offset, (double)direction.m_122431_() * offset);
    }

    private String formatDoorTypeName(String doorType) {
        if ("PETZANITE".equals(doorType)) {
            return "PETEZANITE";
        }
        if ("XENIUM".equals(doorType)) {
            return "XEENIUM";
        }
        return doorType;
    }

    private void applyFacingRotation(PoseStack matrixStack, Direction facing) {
        switch (facing) {
            case NORTH: {
                matrixStack.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                matrixStack.m_85837_(-1.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                matrixStack.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrixStack.m_85837_(-1.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                matrixStack.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                matrixStack.m_85837_(0.0, 0.0, -1.0);
                break;
            }
        }
    }

    public boolean shouldRenderOffScreen(TreasureDoorTileEntity entity) {
        return false;
    }
}

