/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render.healthbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.event.ActiveFlags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.text.DecimalFormat;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

@Deprecated
public class DamageParticleSystem {
    private static final ObjectArrayList<DamageParticle> PARTICLES = new ObjectArrayList(64);
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private static final Random RAND = new Random();
    private static final int MAX_AGE = 35;
    private static final double MAX_DISTANCE_SQUARED = 4096.0;
    private static final int MAX_PARTICLES = 256;
    private static final float FIXED_SCALE = 0.025f;
    private static final float SCALE_DECREASE = 0.3f;
    private static final float FLOAT_SPEED = 0.05f;
    private static final float MAX_DISTANCE_FROM_ENTITY = 1.0f;

    public static void addDamageParticle(Entity targetEntity, Entity attackerEntity, float damage, DamageType damageType) {
        if (PARTICLES.size() >= 256) {
            int removeCount = 64;
            for (int i = 0; i < removeCount && !PARTICLES.isEmpty(); ++i) {
                PARTICLES.remove(0);
            }
        }
        DamageParticle particle = new DamageParticle(targetEntity, attackerEntity, damage, damageType);
        PARTICLES.add((Object)particle);
    }

    public static void addDamageParticle(Entity targetEntity, float damage, DamageType damageType) {
        DamageParticleSystem.addDamageParticle(targetEntity, (Entity)Minecraft.m_91087_().f_91074_, damage, damageType);
    }

    public static void tick() {
        if (PARTICLES.isEmpty()) {
            return;
        }
        ObjectListIterator iterator = PARTICLES.iterator();
        while (iterator.hasNext()) {
            DamageParticle particle = (DamageParticle)iterator.next();
            particle.tick();
            if (particle.age <= 35) continue;
            iterator.remove();
        }
    }

    public static void render(PoseStack matrix, Camera camera, float partialTicks) {
        if (PARTICLES.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        Vec3 camPos = camera.m_90583_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        MultiBufferSource.BufferSource bufferSource = client.m_91269_().m_110104_();
        Font fontRenderer = client.f_91062_;
        PARTICLES.sort((p1, p2) -> {
            double d1 = p1.getDistanceSquared(camPos);
            double d2 = p2.getDistanceSquared(camPos);
            return Double.compare(d1, d2);
        });
        for (DamageParticle particle : PARTICLES) {
            double distanceSquared = particle.getDistanceSquared(camPos);
            if (distanceSquared > 4096.0) continue;
            double x = Mth.m_14139_((double)partialTicks, (double)particle.xPrev, (double)particle.x);
            double y = Mth.m_14139_((double)partialTicks, (double)particle.yPrev, (double)particle.y);
            double z = Mth.m_14139_((double)partialTicks, (double)particle.zPrev, (double)particle.z);
            double camX = camPos.f_82479_;
            double camY = camPos.f_82480_;
            double camZ = camPos.f_82481_;
            matrix.m_85836_();
            matrix.m_85837_(x - camX, y - camY, z - camZ);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(-camera.m_90590_()));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
            float fadeout = DamageParticleSystem.calculateFadeout(particle, partialTicks);
            float scale = 0.025f * fadeout * (1.0f - 0.3f * ((float)particle.age / 35.0f));
            if (particle.targetEntity != null && particle.targetEntity.m_6084_()) {
                float entityScale = Math.max(0.5f, Math.min(2.0f, (particle.targetEntity.m_20205_() + particle.targetEntity.m_20206_()) / 3.0f));
                scale *= entityScale;
            }
            matrix.m_85841_(-scale, -scale, scale);
            double incX = 1.0;
            double incY = 1.0;
            matrix.m_85837_(incX * (double)Mth.m_14179_((float)partialTicks, (float)particle.dxPrev, (float)particle.dx), 0.0, 0.0);
            matrix.m_85837_(0.0, incY * (double)Mth.m_14179_((float)partialTicks, (float)particle.dyPrev, (float)particle.dy), 0.0);
            String text = df.format(particle.damage);
            matrix.m_85837_((double)((float)(-fontRenderer.m_92895_(text)) / 2.0f), 0.0, 0.0);
            int color = particle.damageType.getColor();
            int alpha = (int)(255.0f * fadeout);
            int colorWithAlpha = color & 0xFFFFFF | alpha << 24;
            fontRenderer.m_92811_(text, 0.0f, 0.0f, colorWithAlpha, true, matrix.m_85850_().m_85861_(), (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
            matrix.m_85849_();
        }
        bufferSource.m_109911_();
        RenderSystem.m_69461_();
    }

    private static float calculateFadeout(DamageParticle particle, float partialTicks) {
        float fadeStart = 25.0f;
        if ((float)particle.age < fadeStart) {
            return 1.0f;
        }
        return ((float)(35 - particle.age) - partialTicks) / (35.0f - fadeStart);
    }

    public static class DamageParticle {
        public float damage;
        public DamageType damageType;
        public Entity targetEntity;
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;
        public double xPrev = 0.0;
        public double yPrev = 0.0;
        public double zPrev = 0.0;
        public float dx = 0.0f;
        public float dy = 0.0f;
        public float dxPrev = 0.0f;
        public float dyPrev = 0.0f;
        public int age = 0;
        public double vx = 0.0;
        public double vy = 0.0;
        public double vz = 0.0;
        public float moveSpeed = 0.8f;
        public float horizontalSpeed;
        private double lastDistanceSquared = 0.0;
        private Vec3 lastCamPos = null;

        public DamageParticle(Entity targetEntity, Entity attackerEntity, float damage, DamageType damageType) {
            Vec3 initialPos;
            Minecraft client = Minecraft.m_91087_();
            this.targetEntity = targetEntity;
            Vec3 targetPos = targetEntity.m_20182_();
            if (attackerEntity != null) {
                float eyeHeight = attackerEntity instanceof Player ? attackerEntity.m_20192_() : attackerEntity.m_20206_() * 0.85f;
                initialPos = new Vec3(attackerEntity.m_20185_(), attackerEntity.m_20186_() + (double)eyeHeight, attackerEntity.m_20189_());
                Vec3 direction = targetPos.m_82546_(initialPos).m_82541_();
                float distanceFactor = 0.75f;
                initialPos = initialPos.m_82520_(direction.f_82479_ * (double)targetEntity.m_20270_(attackerEntity) * (double)distanceFactor, direction.f_82480_ * (double)targetEntity.m_20270_(attackerEntity) * (double)distanceFactor, direction.f_82481_ * (double)targetEntity.m_20270_(attackerEntity) * (double)distanceFactor);
            } else {
                initialPos = targetPos.m_82520_(0.0, (double)targetEntity.m_20206_() * 0.75, 0.0);
            }
            this.age = 0;
            this.damage = damage;
            this.damageType = damageType;
            this.x = initialPos.f_82479_;
            this.y = initialPos.f_82480_;
            this.z = initialPos.f_82481_;
            this.xPrev = this.x;
            this.yPrev = this.y;
            this.zPrev = this.z;
            this.vy = 0.15 + RAND.nextGaussian() * 0.04;
            this.vx = RAND.nextGaussian() * 0.07;
            this.vz = RAND.nextGaussian() * 0.07;
            float[] speedOptions = new float[]{0.0f};
            this.horizontalSpeed = speedOptions[RAND.nextInt(speedOptions.length)];
            this.dx = 0.0f;
            this.dy = 0.0f;
            this.dxPrev = 0.0f;
            this.dyPrev = 0.0f;
        }

        public DamageParticle(Entity targetEntity, float damage, DamageType damageType) {
            this(targetEntity, (Entity)Minecraft.m_91087_().f_91074_, damage, damageType);
        }

        public void tick() {
            double entityInfluence;
            double dz;
            double dy;
            double dx;
            double distance;
            this.xPrev = this.x;
            this.yPrev = this.y;
            this.zPrev = this.z;
            this.dxPrev = this.dx;
            this.dyPrev = this.dy;
            ++this.age;
            if (this.targetEntity != null && this.targetEntity.m_6084_() && (distance = Math.sqrt((dx = this.x - this.targetEntity.m_20185_()) * dx + (dy = this.y - this.targetEntity.m_20186_()) * dy + (dz = this.z - this.targetEntity.m_20189_()) * dz)) > 1.0) {
                double pullFactor = 0.1;
                this.x -= dx * pullFactor;
                this.y -= dy * pullFactor;
                this.z -= dz * pullFactor;
            }
            this.x += this.vx;
            this.y += this.vy;
            this.z += this.vz;
            this.vy = 0.05f - 0.001f * (float)this.age;
            this.dy += this.moveSpeed * 0.8f;
            this.dx += this.horizontalSpeed;
            if (this.age >= 5) {
                if (this.age < 15) {
                    this.moveSpeed *= 0.98f;
                    this.horizontalSpeed *= 0.98f;
                } else {
                    this.moveSpeed *= 0.95f;
                    this.horizontalSpeed *= 0.95f;
                }
            }
            if (this.targetEntity != null && this.targetEntity.m_6084_() && (entityInfluence = Math.max(0.0, 0.2 - (double)this.age / 100.0)) > 0.01) {
                double entityDX = this.targetEntity.m_20185_() - this.targetEntity.f_19854_;
                double entityDY = this.targetEntity.m_20186_() - this.targetEntity.f_19855_;
                double entityDZ = this.targetEntity.m_20189_() - this.targetEntity.f_19856_;
                this.x += entityDX * entityInfluence;
                this.y += entityDY * entityInfluence;
                this.z += entityDZ * entityInfluence;
            }
            this.lastCamPos = null;
        }

        public double getDistanceSquared(Vec3 camPos) {
            if (this.lastCamPos != null && this.lastCamPos.equals((Object)camPos)) {
                return this.lastDistanceSquared;
            }
            this.lastDistanceSquared = camPos.m_82531_(this.x, this.y, this.z);
            this.lastCamPos = camPos;
            return this.lastDistanceSquared;
        }
    }

    public static enum DamageType {
        GENERIC(12727847),
        FIRE(11035173),
        MAGIC(0xCC00FF),
        PROJECTILE(12727847),
        EXPLOSION(12727847),
        FALL(12727847),
        DROWNING(24831),
        POISON(7334234),
        CHAINING(6119096),
        THORNS(0xC55757),
        CRITICAL(0xD80000),
        DOT(16738816),
        AOE(15319925),
        REFLECT(0xFFB00F),
        TOTEM(0xD80000),
        CHARMED(16711883),
        EFFECT(1681124),
        JAVELIN(0xD80000),
        SMITE(16711883),
        SMITE_BASE(16711883),
        FIRESHOT(16743168),
        GLACIAL(8973822),
        AP(16711883);

        private final int color;

        private DamageType(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public static DamageType fromDamageSource(DamageSource source) {
            if (source.m_19384_()) {
                return FIRE;
            }
            if (source.m_19387_()) {
                return MAGIC;
            }
            if (source.m_19360_()) {
                return PROJECTILE;
            }
            if (source.m_19372_()) {
                return EXPLOSION;
            }
            if (source == DamageSource.f_19315_) {
                return FALL;
            }
            if (source == DamageSource.f_19312_) {
                return DROWNING;
            }
            if (ActiveFlags.IS_FIRESHOT_ATTACKING.isSet()) {
                return FIRESHOT;
            }
            if (ActiveFlags.IS_GLACIAL_SHATTER_ATTACKING.isSet()) {
                return GLACIAL;
            }
            if (ActiveFlags.IS_AP_ATTACKING.isSet()) {
                return AP;
            }
            if (ActiveFlags.IS_CHAINING_ATTACKING.isSet()) {
                return CHAINING;
            }
            if (ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
                return THORNS;
            }
            if (ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
                return REFLECT;
            }
            if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
                return DOT;
            }
            if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
                return AOE;
            }
            if (ActiveFlags.IS_TOTEM_ATTACKING.isSet()) {
                return TOTEM;
            }
            if (ActiveFlags.IS_CHARMED_ATTACKING.isSet()) {
                return CHARMED;
            }
            if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
                return EFFECT;
            }
            if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
                return JAVELIN;
            }
            if (ActiveFlags.IS_SMITE_BASE_ATTACKING.isSet()) {
                return SMITE_BASE;
            }
            if (ActiveFlags.IS_SMITE_ATTACKING.isSet()) {
                return SMITE;
            }
            return GENERIC;
        }
    }
}

