/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render.healthbar;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.StringRepresentable;

public enum HealthbarAccessibilityHeightOption implements StringRepresentable
{
    XS(2),
    SMALL(4),
    MEDIUM(8),
    LARGE(10);

    private final int height;
    private static final Map<String, HealthbarAccessibilityHeightOption> NAME_TO_TYPE;
    private static final HealthbarAccessibilityHeightOption[] BY_HEIGHT;

    private HealthbarAccessibilityHeightOption(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public static HealthbarAccessibilityHeightOption byHeight(int height) {
        return BY_HEIGHT[height % BY_HEIGHT.length];
    }

    public static HealthbarAccessibilityHeightOption fromString(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public HealthbarAccessibilityHeightOption cycle() {
        if (this == BY_HEIGHT[BY_HEIGHT.length - 1]) {
            return BY_HEIGHT[0];
        }
        return BY_HEIGHT[Arrays.asList(BY_HEIGHT).indexOf((Object)this) + 1];
    }

    @Nonnull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nonnull
    public String getSerializedNameUpper() {
        return this.name().toUpperCase(Locale.ROOT);
    }

    static {
        NAME_TO_TYPE = Arrays.stream(HealthbarAccessibilityHeightOption.values()).collect(Collectors.toMap(HealthbarAccessibilityHeightOption::m_7912_, Functions.identity()));
        BY_HEIGHT = (HealthbarAccessibilityHeightOption[])Arrays.stream(HealthbarAccessibilityHeightOption.values()).sorted(Comparator.comparingInt(HealthbarAccessibilityHeightOption::getHeight)).toArray(HealthbarAccessibilityHeightOption[]::new);
    }
}

