/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render.healthbar;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.StringRepresentable;

public enum HealthbarDisplayOption implements StringRepresentable
{
    ENABLED,
    DISABLED,
    VAULT_ONLY;

    private static final Map<String, HealthbarDisplayOption> NAME_TO_TYPE;

    public static HealthbarDisplayOption fromString(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public HealthbarDisplayOption cycle() {
        HealthbarDisplayOption[] values = HealthbarDisplayOption.values();
        int index = (this.ordinal() + 1) % values.length;
        return values[index];
    }

    @Nonnull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nonnull
    public String getSerializedNameUpper() {
        String result = this.name().toLowerCase(Locale.ROOT).replace("_", " ");
        Matcher matcher = Pattern.compile("(?<=\\s|^)([a-z])").matcher(result);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase(Locale.ROOT));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        NAME_TO_TYPE = Arrays.stream(HealthbarDisplayOption.values()).collect(Collectors.toMap(HealthbarDisplayOption::m_7912_, Functions.identity()));
    }
}

