/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render.healthbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.client.render.healthbar.HealthbarDisplayOption;
import iskallia.vault.config.EntityGroupDefinitionsConfig;
import iskallia.vault.config.EntityHitboxOffsets;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HealthbarRenderer {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final float DEFAULT_MAX_DISPLAY_DISTANCE = 20.0f;
    private static final float MAX_DISPLAY_DISTANCE_SQUARED = 400.0f;
    private static final int VISIBILITY_CACHE_TIME_MS = 100;
    private static final int MAX_RENDER_BATCH_SIZE = 50;
    private static final int LINEARLY_RENDERABLE_MAX_DISTANCE = 10;
    private static final Object2ObjectMap<EntityType<?>, Boolean> ENTITY_RENDER_CONFIG_CACHE = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<ResourceLocation, TextureAtlasSprite> SPRITE_CACHE = new Object2ObjectOpenHashMap();
    private static final ConcurrentHashMap<Integer, VisibilityCacheEntry> VISIBILITY_CACHE = new ConcurrentHashMap();
    private static final Object2ObjectMap<EntityType<?>, EntityHitboxOffsets.EntityHitboxOffset> HITBOX_CACHE = new Object2ObjectOpenHashMap();
    private static final Executor VISIBILITY_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Healthbar-Visibility-Worker");
        thread.setDaemon(true);
        return thread;
    });
    private static int frameCounter = 0;
    private static Frustum currentFrustum;
    private static final List<RenderBatch> renderBatches;

    public static void registerEvents() {
        ClientEvents.RENDER_LEVEL_LAST.register(HealthbarRenderer.class, data -> {
            if (HealthbarRenderer.minecraft.f_91073_ == null || HealthbarRenderer.minecraft.f_91074_ == null) {
                return;
            }
            HealthbarDisplayOption displayOption = ((IVaultOptions)HealthbarRenderer.minecraft.f_91066_).isHealthbarEnabled();
            if (displayOption == HealthbarDisplayOption.DISABLED) {
                return;
            }
            if (ClientVaults.getActive().isEmpty() && displayOption == HealthbarDisplayOption.VAULT_ONLY) {
                return;
            }
            currentFrustum = new Frustum(data.poseStack().m_85850_().m_85861_(), HealthbarRenderer.minecraft.f_91063_.m_172716_(HealthbarRenderer.minecraft.f_91066_.f_92068_));
            currentFrustum.m_113002_(HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90583_().f_82479_, HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90583_().f_82480_, HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90583_().f_82481_);
            renderBatches.clear();
            RenderBatch currentBatch = new RenderBatch();
            renderBatches.add(currentBatch);
            Iterable visibleEntities = HealthbarRenderer.minecraft.f_91073_.m_104735_();
            for (Entity entity : visibleEntities) {
                float distance;
                AABB boundingBox;
                double sqDistance;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity == HealthbarRenderer.minecraft.f_91074_ || entity instanceof Player || (sqDistance = entity.m_20280_((Entity)HealthbarRenderer.minecraft.f_91074_)) > 400.0 || !currentFrustum.m_113029_(boundingBox = entity.m_142469_().m_82400_(0.5)) || !HealthbarRenderer.isRenderableEntity(livingEntity) || !((distance = (float)Math.sqrt(sqDistance)) <= 10.0f) && !HealthbarRenderer.isVisibleWithCache((Entity)HealthbarRenderer.minecraft.f_91074_, (Entity)livingEntity)) continue;
                if (currentBatch.isFull()) {
                    currentBatch = new RenderBatch();
                    renderBatches.add(currentBatch);
                }
                currentBatch.add(livingEntity, distance, livingEntity.m_21223_(), livingEntity.m_21233_());
            }
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            for (RenderBatch batch : renderBatches) {
                if (batch.entries.isEmpty()) continue;
                HealthbarRenderer.renderBatch(batch, data.poseStack(), data.partialTicks());
            }
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
        });
    }

    public static boolean isShowingHealthbar(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (entity.m_21223_() >= entity.m_21233_()) {
            return false;
        }
        if (!ModConfigs.ENTITY_GROUP_DEFINITIONS.isInGroup((Entity)entity)) {
            return false;
        }
        return ModConfigs.ENTITY_GROUP_DEFINITIONS.isInGroup((Entity)entity, true);
    }

    private static EntityHitboxOffsets.EntityHitboxOffset getOffset(LivingEntity entity) {
        EntityHitboxOffsets.EntityHitboxOffset offset = (EntityHitboxOffsets.EntityHitboxOffset)HITBOX_CACHE.get((Object)entity.m_6095_());
        if (offset == null) {
            offset = ModConfigs.ENTITY_HITBOX_OFFSETS.getOffset(entity.m_6095_().getRegistryName()).orElseGet(() -> new EntityHitboxOffsets.EntityHitboxOffset(0.0f, 0.0f, 0.0f));
            HITBOX_CACHE.put((Object)entity.m_6095_(), (Object)offset);
        }
        return offset;
    }

    private static void renderBatch(RenderBatch batch, PoseStack poseStack, float partialTicks) {
        batch.entries.sort((a, b) -> Float.compare(a.distance, b.distance));
        Color healthbarColor = ((IVaultOptions)HealthbarRenderer.minecraft.f_91066_).healthbarColor();
        boolean showMobGroupIcons = ((IVaultOptions)HealthbarRenderer.minecraft.f_91066_).isHealthbarGroupEnabled();
        for (BatchEntry entry : batch.entries) {
            LivingEntity entity = entry.entity;
            float distance = entry.distance;
            float healthPercentage = Math.min(entry.health / entry.maxHealth, 1.0f);
            int barHeight = ((IVaultOptions)HealthbarRenderer.minecraft.f_91066_).getHealthbarHeight().getHeight();
            float barWidth = 40.0f;
            float opacity = HealthbarRenderer.calculateOpacity(distance);
            double dx = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)partialTicks - HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90583_().f_82479_;
            double dy = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)partialTicks - HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90583_().f_82480_;
            double dz = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)partialTicks - HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90583_().f_82481_;
            float xOffset = HealthbarRenderer.getOffset(entity).getX();
            float yOffset = HealthbarRenderer.getOffset(entity).getY();
            float zOffset = HealthbarRenderer.getOffset(entity).getZ();
            poseStack.m_85836_();
            poseStack.m_85837_(dx + (double)xOffset, dy + (double)entity.m_20206_() + 0.35 + (double)yOffset, dz + (double)zOffset);
            poseStack.m_85845_(HealthbarRenderer.minecraft.f_91063_.m_109153_().m_90591_());
            float scale = -0.025f;
            poseStack.m_85841_(scale, scale, -scale);
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_85982_(matrix, -barWidth / 2.0f, (float)(-barHeight) / 2.0f, 0.0f).m_6122_(0, 0, 0, (int)(128.0f * opacity)).m_5752_();
            buffer.m_85982_(matrix, -barWidth / 2.0f, (float)barHeight / 2.0f, 0.0f).m_6122_(0, 0, 0, (int)(128.0f * opacity)).m_5752_();
            buffer.m_85982_(matrix, barWidth / 2.0f, (float)barHeight / 2.0f, 0.0f).m_6122_(0, 0, 0, (int)(128.0f * opacity)).m_5752_();
            buffer.m_85982_(matrix, barWidth / 2.0f, (float)(-barHeight) / 2.0f, 0.0f).m_6122_(0, 0, 0, (int)(128.0f * opacity)).m_5752_();
            tesselator.m_85914_();
            int filledBarWidth = (int)(barWidth * healthPercentage);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_85982_(matrix, -barWidth / 2.0f, (float)(-barHeight) / 2.0f, 0.0f).m_6122_(healthbarColor.getRed(), healthbarColor.getGreen(), healthbarColor.getBlue(), (int)(200.0f * opacity)).m_5752_();
            buffer.m_85982_(matrix, -barWidth / 2.0f, (float)barHeight / 2.0f, 0.0f).m_6122_(healthbarColor.getRed(), healthbarColor.getGreen(), healthbarColor.getBlue(), (int)(200.0f * opacity)).m_5752_();
            buffer.m_85982_(matrix, -barWidth / 2.0f + (float)filledBarWidth, (float)barHeight / 2.0f, 0.0f).m_6122_(healthbarColor.getRed(), healthbarColor.getGreen(), healthbarColor.getBlue(), (int)(200.0f * opacity)).m_5752_();
            buffer.m_85982_(matrix, -barWidth / 2.0f + (float)filledBarWidth, (float)(-barHeight) / 2.0f, 0.0f).m_6122_(healthbarColor.getRed(), healthbarColor.getGreen(), healthbarColor.getBlue(), (int)(200.0f * opacity)).m_5752_();
            tesselator.m_85914_();
            if (showMobGroupIcons) {
                HealthbarRenderer.renderMobGroupIcon(entity, matrix, poseStack, barWidth, barHeight, opacity);
            }
            poseStack.m_85849_();
        }
    }

    private static void renderMobGroupIcon(LivingEntity entity, Matrix4f matrix, PoseStack poseStack, float barWidth, float barHeight, float opacity) {
        Optional<TextureAtlasSprite> sprite = HealthbarRenderer.getMobGroupIcon((Entity)entity);
        if (sprite.isEmpty()) {
            return;
        }
        float iconScale = barHeight / 16.0f;
        TextureAtlasRegion region = new TextureAtlasRegion(ModTextureAtlases.MOB_GROUPS, sprite.get().m_118413_());
        int spriteXStart = (int)(-barWidth / 2.0f - 16.0f * iconScale - 2.0f);
        int spriteYStart = (int)((double)(-barHeight / 2.0f) - 0.25);
        RenderSystem.m_69493_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.get().m_118414_().m_118330_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        poseStack.m_85836_();
        poseStack.m_85837_((double)spriteXStart, (double)spriteYStart, 0.0);
        poseStack.m_85841_(iconScale, iconScale, iconScale);
        region.blit(poseStack, 0, 0);
        poseStack.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static float calculateOpacity(double distance) {
        return (float)Math.max(0.0, 1.0 - distance / 20.0);
    }

    private static boolean isRenderableEntity(LivingEntity entity) {
        if (entity.m_21223_() >= entity.m_21233_()) {
            return false;
        }
        Boolean cachedResult = (Boolean)ENTITY_RENDER_CONFIG_CACHE.get((Object)entity.m_6095_());
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = ModConfigs.ENTITY_GROUP_DEFINITIONS.isInGroup((Entity)entity, true);
        ENTITY_RENDER_CONFIG_CACHE.put((Object)entity.m_6095_(), (Object)result);
        return result;
    }

    private static boolean isVisibleWithCache(Entity observer, Entity target) {
        int cacheKey = observer.m_142049_() * 31 + target.m_142049_();
        VisibilityCacheEntry cacheEntry = VISIBILITY_CACHE.get(cacheKey);
        long currentTime = System.currentTimeMillis();
        if (cacheEntry != null && currentTime - cacheEntry.timestamp < 100L) {
            return cacheEntry.visible;
        }
        if (observer.m_20270_(target) > 10.0f) {
            CompletableFuture.runAsync(() -> {
                boolean result = HealthbarRenderer.hasLineOfSight(observer, target);
                VISIBILITY_CACHE.put(cacheKey, new VisibilityCacheEntry(result, System.currentTimeMillis()));
            }, VISIBILITY_EXECUTOR);
            return cacheEntry != null ? cacheEntry.visible : false;
        }
        boolean result = HealthbarRenderer.hasLineOfSight(observer, target);
        VISIBILITY_CACHE.put(cacheKey, new VisibilityCacheEntry(result, currentTime));
        return result;
    }

    private static boolean hasLineOfSight(Entity observer, Entity target) {
        Vec3 targetPos;
        if (observer == null || target == null) {
            return false;
        }
        if (observer.f_19853_ != target.f_19853_) {
            return false;
        }
        Vec3 eyePosition = new Vec3(observer.m_20185_(), observer.m_20188_(), observer.m_20189_());
        ClipContext context = new ClipContext(eyePosition, targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, observer);
        BlockHitResult result = observer.f_19853_.m_45547_(context);
        return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(targetPos) < 0.01;
    }

    public static Optional<TextureAtlasSprite> getMobGroupIcon(Entity entity) {
        if (!ModConfigs.ENTITY_GROUP_DEFINITIONS.isInGroup(entity)) {
            return Optional.empty();
        }
        ResourceLocation key = ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroup(entity).map(EntityGroupDefinitionsConfig.EntityGroupDefinition::getIcon).orElse(null);
        if (key == null) {
            return Optional.empty();
        }
        TextureAtlasSprite cachedSprite = (TextureAtlasSprite)SPRITE_CACHE.get((Object)key);
        if (cachedSprite != null) {
            return Optional.of(cachedSprite);
        }
        TextureAtlasSprite sprite = ModTextureAtlases.MOB_GROUPS.get().getSprite(key);
        if (sprite != null) {
            SPRITE_CACHE.put((Object)key, (Object)sprite);
            return Optional.of(sprite);
        }
        return Optional.empty();
    }

    public static void clearCaches() {
        ENTITY_RENDER_CONFIG_CACHE.clear();
        HITBOX_CACHE.clear();
        SPRITE_CACHE.clear();
        VISIBILITY_CACHE.clear();
    }

    static {
        renderBatches = new ArrayList<RenderBatch>();
    }

    private static class RenderBatch {
        final List<BatchEntry> entries = new ArrayList<BatchEntry>();
        float maxDistance = 0.0f;

        private RenderBatch() {
        }

        void add(LivingEntity entity, float distance, float health, float maxHealth) {
            this.entries.add(new BatchEntry(entity, distance, health, maxHealth));
            this.maxDistance = Math.max(this.maxDistance, distance);
        }

        boolean isFull() {
            return this.entries.size() >= 50;
        }
    }

    private static class BatchEntry {
        final LivingEntity entity;
        final float distance;
        final float health;
        final float maxHealth;

        BatchEntry(LivingEntity entity, float distance, float health, float maxHealth) {
            this.entity = entity;
            this.distance = distance;
            this.health = health;
            this.maxHealth = maxHealth;
        }
    }

    private static class VisibilityCacheEntry {
        final boolean visible;
        final long timestamp;

        VisibilityCacheEntry(boolean visible, long timestamp) {
            this.visible = visible;
            this.timestamp = timestamp;
        }
    }
}

