/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render.hunter;

public enum HunterParticleDensityOption {
    NORMAL("normal", 1.0),
    HALF("reduced", 0.5),
    QUARTER("quarter", 0.25);

    private final String serializedName;
    private final double density;

    private HunterParticleDensityOption(String serializedName, double density) {
        this.serializedName = serializedName;
        this.density = density;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public double getDensity() {
        return this.density;
    }

    public HunterParticleDensityOption next() {
        HunterParticleDensityOption[] options = HunterParticleDensityOption.values();
        return options[(this.ordinal() + 1) % options.length];
    }

    public static HunterParticleDensityOption fromString(String name) {
        for (HunterParticleDensityOption option : HunterParticleDensityOption.values()) {
            if (!option.getSerializedName().equals(name)) continue;
            return option;
        }
        return NORMAL;
    }
}

