/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.shader.glsl.NativeShader;
import iskallia.vault.event.event.WindowResizeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ShaderChain {
    private static final List<ShaderChain> globalChains = new ArrayList<ShaderChain>();
    private final List<NativeShader> shaders = new ArrayList<NativeShader>();
    private int[] frameBuffers;
    private int[] colorTextures;
    private int[] depthTextures;
    private int width = 0;
    private int height = 0;

    private ShaderChain(List<NativeShader> shaders) {
        this.shaders.addAll(shaders);
        globalChains.add(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void build() {
        if (this.shaders.isEmpty()) {
            throw new IllegalStateException("Cannot build chain with no shaders.");
        }
        Window gameWindow = Minecraft.m_91087_().m_91268_();
        this.width = gameWindow.m_85441_();
        this.height = gameWindow.m_85442_();
        int layers = this.shaders.size() + 1;
        this.frameBuffers = new int[layers];
        this.colorTextures = new int[layers];
        this.depthTextures = new int[layers];
        GL30.glGenFramebuffers((int[])this.frameBuffers);
        GL11.glGenTextures((int[])this.colorTextures);
        GL11.glGenTextures((int[])this.depthTextures);
        for (int i = 0; i < this.frameBuffers.length; ++i) {
            int bufId = this.frameBuffers[i];
            int colorId = this.colorTextures[i];
            int depthId = this.depthTextures[i];
            GlStateManager.m_84486_((int)36160, (int)bufId);
            GlStateManager.m_84544_((int)depthId);
            GlStateManager.m_84331_((int)3553, (int)10241, (int)9728);
            GlStateManager.m_84331_((int)3553, (int)10240, (int)9728);
            GlStateManager.m_84331_((int)3553, (int)34892, (int)0);
            GlStateManager.m_84331_((int)3553, (int)10242, (int)33071);
            GlStateManager.m_84331_((int)3553, (int)10243, (int)33071);
            GlStateManager.m_84209_((int)3553, (int)0, (int)36013, (int)this.width, (int)this.height, (int)0, (int)34041, (int)36269, null);
            GlStateManager.m_84544_((int)colorId);
            GlStateManager.m_84331_((int)3553, (int)10241, (int)9729);
            GlStateManager.m_84331_((int)3553, (int)10240, (int)9729);
            GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
            GlStateManager.m_84486_((int)36160, (int)bufId);
            GlStateManager.m_84173_((int)36160, (int)36064, (int)3553, (int)colorId, (int)0);
            GlStateManager.m_84173_((int)36160, (int)36096, (int)3553, (int)depthId, (int)0);
            GlStateManager.m_84173_((int)36160, (int)36128, (int)3553, (int)depthId, (int)0);
            int fbStatus = GL30.glCheckFramebufferStatus((int)36160);
            if (fbStatus != 36053) {
                throw new IllegalStateException("Framebuffer init failed. " + fbStatus);
            }
            this.clearFramebuffer(bufId);
        }
    }

    public void render(Runnable renderCall, Consumer<NativeShader> preShaderRun) {
        if (this.frameBuffers == null) {
            return;
        }
        int currentFramebufferId = GL11.glGetInteger((int)36006);
        this.copyDepthFromBuffer(currentFramebufferId, this.width, this.height);
        int prevTexture = -1;
        for (int i = 0; i < this.frameBuffers.length; ++i) {
            GlStateManager.m_84486_((int)36160, (int)this.frameBuffers[i]);
            GlStateManager.m_84266_((int)16640, (boolean)Minecraft.f_91002_);
            if (i == 0) {
                renderCall.run();
            } else if (prevTexture != -1) {
                GlStateManager.m_84544_((int)prevTexture);
                RenderSystem.m_157453_((int)0, (int)prevTexture);
                RenderSystem.m_69493_();
                RenderSystem.m_69465_();
                RenderSystem.m_69464_();
                Tesselator tesselator = RenderSystem.m_69883_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_5483_((double)(-this.width / 2), (double)(-this.height / 2), 0.0).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_5483_((double)(-this.width / 2), (double)(this.height / 2), 0.0).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_((double)(this.width / 2), (double)(this.height / 2), 0.0).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_((double)(this.width / 2), (double)(-this.height / 2), 0.0).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_85721_();
                BufferUploader.m_166847_((BufferBuilder)bufferbuilder);
                RenderSystem.m_69481_();
                RenderSystem.m_69482_();
                RenderSystem.m_69472_();
            }
            prevTexture = this.colorTextures[i];
        }
        this.unbindFramebuffer();
        this.copyAllInternal(this.frameBuffers[1], Minecraft.m_91087_().m_91385_().f_83920_);
        GlStateManager.m_84486_((int)36160, (int)currentFramebufferId);
        for (int bufId : this.frameBuffers) {
            this.clearFramebuffer(bufId);
        }
        GlStateManager.m_84486_((int)36160, (int)currentFramebufferId);
    }

    public void copyColorDepthFromBuffer(int otherBuffer, int otherWidth, int otherHeight) {
        this.copyFromBuffer(otherBuffer, otherWidth, otherHeight, 16640);
    }

    public void copyDepthFromBuffer(int otherBuffer, int otherWidth, int otherHeight) {
        this.copyFromBuffer(otherBuffer, otherWidth, otherHeight, 256);
    }

    public void copyFromBuffer(int otherBuffer, int otherWidth, int otherHeight, int copyMask) {
        if (this.frameBuffers == null) {
            return;
        }
        this.copyInternal(otherBuffer, otherWidth, otherHeight, copyMask, this.frameBuffers[0]);
    }

    private void copyAllInternal(int buffer, int targetBuffer) {
        this.copyInternal(buffer, this.width, this.height, 16640, targetBuffer);
    }

    private void copyInternal(int buffer, int otherWidth, int otherHeight, int copyMask, int targetBuffer) {
        GlStateManager.m_84486_((int)36008, (int)buffer);
        GlStateManager.m_84486_((int)36009, (int)targetBuffer);
        GlStateManager.m_84188_((int)0, (int)0, (int)otherWidth, (int)otherHeight, (int)0, (int)0, (int)this.width, (int)this.height, (int)copyMask, (int)9728);
        GlStateManager.m_84486_((int)36160, (int)0);
    }

    private void bindFramebuffer(int bufId, boolean setViewport) {
        GlStateManager.m_84486_((int)36160, (int)bufId);
        if (setViewport) {
            GlStateManager.m_84430_((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    private void unbindFramebuffer() {
        GlStateManager.m_84486_((int)36160, (int)0);
    }

    private void clearFramebuffer(int bufId) {
        this.bindFramebuffer(bufId, false);
        GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.m_84121_((double)1.0);
        GlStateManager.m_84266_((int)16640, (boolean)Minecraft.f_91002_);
        this.unbindFramebuffer();
    }

    private void clean() {
        if (this.frameBuffers == null) {
            return;
        }
        GlStateManager.m_84544_((int)0);
        this.unbindFramebuffer();
        GL11.glDeleteTextures((int[])this.colorTextures);
        GL11.glDeleteTextures((int[])this.depthTextures);
        GL30.glDeleteFramebuffers((int[])this.frameBuffers);
        this.frameBuffers = null;
    }

    public void destroy() {
        this.clean();
        globalChains.remove(this);
    }

    @SubscribeEvent
    public static void onResize(WindowResizeEvent event) {
        globalChains.forEach(chain -> {
            chain.clean();
            chain.build();
        });
    }

    public static class Builder {
        private final List<NativeShader> shaders = new ArrayList<NativeShader>();

        private Builder() {
        }

        public Builder addShader(NativeShader shader) {
            this.shaders.add(shader);
            return this;
        }

        public ShaderChain build() {
            ShaderChain chain = new ShaderChain(this.shaders);
            chain.build();
            return chain;
        }
    }
}

