/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.shader.glsl;

import com.mojang.blaze3d.systems.RenderSystem;
import iskallia.vault.VaultMod;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

public class NativeShader {
    private int loadedShader = -1;
    private int fsh = -1;
    private int vsh = -1;

    public NativeShader(ResourceProvider resourceLoader, ResourceLocation shaderName) {
        this.loadShader(resourceLoader, shaderName);
    }

    public void applyFloatValue(String name, float value) {
        if (this.loadedShader == -1) {
            return;
        }
        int location = GL20.glGetUniformLocation((int)this.loadedShader, (CharSequence)name);
        GL20.glUniform1f((int)location, (float)value);
    }

    public void applyIntValue(String name, int value) {
        if (this.loadedShader == -1) {
            return;
        }
        int location = GL20.glGetUniformLocation((int)this.loadedShader, (CharSequence)name);
        GL20.glUniform1i((int)location, (int)value);
    }

    public void applyActiveTexture(String name) {
        if (this.loadedShader == -1) {
            return;
        }
        int activeTex = RenderSystem.m_157203_((int)0);
        int location = GL20.glGetUniformLocation((int)this.loadedShader, (CharSequence)name);
        GL20.glUniform1i((int)location, (int)activeTex);
    }

    public void run() {
        if (this.loadedShader == -1) {
            return;
        }
        GL20.glUseProgram((int)this.loadedShader);
    }

    public void destroy() {
        if (this.loadedShader != -1) {
            GL20.glDeleteProgram((int)this.loadedShader);
        }
        if (this.fsh != -1) {
            GL20.glDeleteShader((int)this.fsh);
        }
        if (this.vsh != -1) {
            GL20.glDeleteShader((int)this.vsh);
        }
    }

    private void loadShader(ResourceProvider resourceLoader, ResourceLocation shaderName) {
        int vsh;
        int fsh;
        ResourceLocation frag = new ResourceLocation(shaderName.m_135827_(), "shaders/" + shaderName.m_135815_() + ".fsh");
        ResourceLocation vert = new ResourceLocation(shaderName.m_135827_(), "shaders/" + shaderName.m_135815_() + ".vsh");
        try {
            fsh = this.compileShader(resourceLoader, frag, 35632);
            vsh = this.compileShader(resourceLoader, vert, 35633);
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return;
        }
        int shaderProgram = GL20.glCreateProgram();
        GL20.glAttachShader((int)shaderProgram, (int)vsh);
        GL20.glAttachShader((int)shaderProgram, (int)fsh);
        GL20.glLinkProgram((int)shaderProgram);
        if (GL20.glGetProgrami((int)shaderProgram, (int)35714) == 0) {
            VaultMod.LOGGER.error("Shader linking failed: " + GL20.glGetProgramInfoLog((int)shaderProgram));
            return;
        }
        this.fsh = fsh;
        this.vsh = vsh;
        this.loadedShader = shaderProgram;
    }

    private int compileShader(ResourceProvider resourceLoader, ResourceLocation shaderName, int type) throws IOException {
        Resource resource = resourceLoader.m_142591_(shaderName);
        String shader = IOUtils.toString((InputStream)resource.m_6679_(), (Charset)StandardCharsets.UTF_8);
        int shaderId = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shaderId, (CharSequence)shader);
        GL20.glCompileShader((int)shaderId);
        if (GL20.glGetShaderi((int)shaderId, (int)35713) == 0) {
            throw new IOException("Shader compilation failed: " + GL20.glGetShaderInfoLog((int)shaderId));
        }
        return shaderId;
    }
}

