/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util;

import iskallia.vault.VaultMod;
import iskallia.vault.client.util.color.ColorThief;
import iskallia.vault.client.util.color.ColorUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ColorizationHelper {
    private static final Random rand = new Random();
    private static final Map<Item, Optional<Color>> itemColors = new HashMap<Item, Optional<Color>>();

    private ColorizationHelper() {
    }

    @Nonnull
    public static Optional<Color> getColor(ItemStack stack) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        Item i = stack.m_41720_();
        if (!itemColors.containsKey(i)) {
            TextureAtlasSprite tas = ColorizationHelper.getParticleTexture(stack);
            if (tas != null) {
                itemColors.put(i, ColorizationHelper.getDominantColor(tas));
            } else {
                itemColors.put(i, Optional.empty());
            }
        }
        return itemColors.get(i).map(c -> ColorUtil.overlayColor(c, new Color(ColorUtil.getOverlayColor(stack))));
    }

    @Nullable
    private static TextureAtlasSprite getParticleTexture(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        ItemModelShaper imm = Minecraft.m_91087_().m_91291_().m_115103_();
        BakedModel mdl = imm.m_109406_(stack);
        if (mdl.equals(imm.m_109393_().m_119409_())) {
            return null;
        }
        return mdl.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }

    private static Optional<Color> getDominantColor(TextureAtlasSprite tas) {
        if (tas == null) {
            return Optional.empty();
        }
        try {
            BufferedImage extractedImage = ColorizationHelper.extractImage(tas);
            int[] dominantColor = ColorThief.getColor(extractedImage);
            int color = (dominantColor[0] & 0xFF) << 16 | (dominantColor[1] & 0xFF) << 8 | dominantColor[2] & 0xFF;
            return Optional.of(new Color(color));
        }
        catch (Exception exc) {
            VaultMod.LOGGER.error("Item Colorization Helper: Ignoring non-resolvable image " + tas.m_118413_().toString());
            exc.printStackTrace();
            return Optional.empty();
        }
    }

    @Nullable
    private static BufferedImage extractImage(TextureAtlasSprite tas) {
        int w = tas.m_118405_();
        int h = tas.m_118408_();
        int count = tas.m_118415_();
        if (w <= 0 || h <= 0 || count <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(w, h * count, 6);
        for (int i = 0; i < count; ++i) {
            int[] pxArray = new int[tas.m_118405_() * tas.m_118408_()];
            for (int xx = 0; xx < tas.m_118405_(); ++xx) {
                for (int zz = 0; zz < tas.m_118408_(); ++zz) {
                    int argb = tas.getPixelRGBA(0, xx, zz + i * tas.m_118408_());
                    pxArray[zz * tas.m_118405_() + xx] = argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
                }
            }
            bufferedImage.setRGB(0, i * h, w, h, pxArray, 0, w);
        }
        return bufferedImage;
    }
}

