/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util;

import iskallia.vault.network.message.EffectMessage;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleHelper {
    public static void spawnParticle(EffectMessage pkt) {
        EffectMessage.Type type = pkt.getEffectType();
        switch (type) {
            case COLORED_FIREWORK: {
                ParticleHelper.spawnColoredFirework(pkt.getPos(), pkt.getData().readInt());
                break;
            }
            case BLOCK_BREAK_EFFECT: {
                ParticleHelper.spawnBlockBreakEffect(pkt.getPos(), pkt.getData().readInt());
            }
        }
    }

    private static void spawnBlockBreakEffect(Vec3 pos, int id) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockState state = Block.m_49803_((int)id);
        level.m_142052_(new BlockPos(pos), state);
    }

    private static void spawnColoredFirework(Vec3 pos, int color) {
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        SimpleAnimatedParticle fwParticle = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
        if (fwParticle != null) {
            Color c = new Color(color);
            fwParticle.m_107253_((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        }
    }
}

