/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;

public final class TooltipUtil {
    public static void renderTooltip(PoseStack poseStack, List<? extends FormattedCharSequence> tooltips, int mouseX, int mouseY, int screenWidth, int screenHeight) {
        TooltipUtil.renderTooltip(poseStack, tooltips.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), mouseX, mouseY, screenWidth, screenHeight, ItemStack.f_41583_, Minecraft.m_91087_().f_91062_, false);
    }

    public static void renderTooltip(PoseStack pPoseStack, List<Component> pTooltips, int pMouseX, int pMouseY, Screen screen, boolean onLeft) {
        int width = screen.f_96543_;
        int height = screen.f_96544_;
        Font font = screen.getMinecraft().f_91062_;
        List components = ForgeHooksClient.gatherTooltipComponents((ItemStack)ItemStack.f_41583_, pTooltips, (int)pMouseX, (int)width, (int)height, (Font)font, (Font)font);
        TooltipUtil.renderTooltip(pPoseStack, components, pMouseX, pMouseY, width, height, ItemStack.f_41583_, font, onLeft);
    }

    public static void renderTooltip(PoseStack poseStack, List<ClientTooltipComponent> clientTooltipComponents, int mouseX, int mouseY, int screenWidth, int screenHeight, ItemStack itemStack, Font tooltipFont, boolean flippedToTheLeft) {
        if (!clientTooltipComponents.isEmpty()) {
            ClientTooltipComponent component;
            RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)itemStack, (PoseStack)poseStack, (int)mouseX, (int)mouseY, (int)screenWidth, (int)screenHeight, clientTooltipComponents, (Font)tooltipFont, (Font)Minecraft.m_91087_().f_91062_);
            if (preEvent.isCanceled()) {
                return;
            }
            int maxWidth = 0;
            int maxHeight = clientTooltipComponents.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : clientTooltipComponents) {
                int k = clienttooltipcomponent.m_142069_(preEvent.getFont());
                if (k > maxWidth) {
                    maxWidth = k;
                }
                maxHeight += clienttooltipcomponent.m_142103_();
            }
            int x = preEvent.getX() + (flippedToTheLeft ? -12 : 12);
            int y = preEvent.getY() - 12;
            if (flippedToTheLeft) {
                x -= maxWidth;
            }
            if (x + maxWidth > screenWidth) {
                x -= 28 + maxWidth;
            }
            if (y + maxHeight + 6 > screenHeight) {
                y = screenHeight - maxHeight - 6;
            }
            int zOffset = 400;
            poseStack.m_85836_();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            float originalBlitOffset = itemRenderer.f_115093_;
            itemRenderer.f_115093_ = zOffset;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)itemStack, (PoseStack)poseStack, (int)x, (int)y, (Font)preEvent.getFont(), clientTooltipComponents);
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 3, y - 4, x + maxWidth + 3, y - 3, zOffset, colorEvent.getBackgroundStart(), colorEvent.getBackgroundStart());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 3, y + maxHeight + 3, x + maxWidth + 3, y + maxHeight + 4, zOffset, colorEvent.getBackgroundEnd(), colorEvent.getBackgroundEnd());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 3, y - 3, x + maxWidth + 3, y + maxHeight + 3, zOffset, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 4, y - 3, x - 3, y + maxHeight + 3, zOffset, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x + maxWidth + 3, y - 3, x + maxWidth + 4, y + maxHeight + 3, zOffset, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 3, y - 3 + 1, x - 3 + 1, y + maxHeight + 3 - 1, zOffset, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x + maxWidth + 2, y - 3 + 1, x + maxWidth + 3, y + maxHeight + 3 - 1, zOffset, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 3, y - 3, x + maxWidth + 3, y - 3 + 1, zOffset, colorEvent.getBorderStart(), colorEvent.getBorderStart());
            TooltipUtil.fillGradient(matrix4f, bufferbuilder, x - 3, y + maxHeight + 2, x + maxWidth + 3, y + maxHeight + 3, zOffset, colorEvent.getBorderEnd(), colorEvent.getBorderEnd());
            RenderSystem.m_69482_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            poseStack.m_85837_(0.0, 0.0, (double)zOffset);
            int l1 = y;
            for (int i2 = 0; i2 < clientTooltipComponents.size(); ++i2) {
                component = clientTooltipComponents.get(i2);
                component.m_142440_(preEvent.getFont(), x, l1, matrix4f, bufferSource);
                l1 += component.m_142103_() + (i2 == 0 ? 2 : 0);
            }
            bufferSource.m_109911_();
            poseStack.m_85849_();
            l1 = y;
            for (int l2 = 0; l2 < clientTooltipComponents.size(); ++l2) {
                component = clientTooltipComponents.get(l2);
                component.m_183452_(preEvent.getFont(), x, l1, poseStack, itemRenderer, zOffset);
                l1 += component.m_142103_() + (l2 == 0 ? 2 : 0);
            }
            itemRenderer.f_115093_ = originalBlitOffset;
        }
    }

    private static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.m_85982_(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
        pBuilder.m_85982_(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
    }
}

