/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.command.Command;
import iskallia.vault.config.AscensionForgeConfig;
import iskallia.vault.config.PlayerTitlesConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.TitleScrollItem;
import iskallia.vault.world.data.PlayerTitlesData;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AscensionTitleCommand
extends Command {
    @Override
    public String getName() {
        return "ascension_title";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"affix", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82970_((Iterable)Arrays.stream(PlayerTitlesConfig.Affix.values()).map(Enum::name).collect(Collectors.toList()), (SuggestionsBuilder)sb)).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"tabText", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"tabColor", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"chatText", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"chatColor", (ArgumentType)StringArgumentType.string()).executes(this::createTitle)).then(Commands.m_82129_((String)"emberCost", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::createTitle)))))))));
    }

    private int createTitle(CommandContext<CommandSourceStack> ctx) {
        PlayerTitlesConfig.Affix affix;
        String affixArg = StringArgumentType.getString(ctx, (String)"affix").toUpperCase();
        String id = StringArgumentType.getString(ctx, (String)"id");
        String tabText = StringArgumentType.getString(ctx, (String)"tabText");
        String tabColor = StringArgumentType.getString(ctx, (String)"tabColor");
        String chatText = StringArgumentType.getString(ctx, (String)"chatText");
        String chatColor = StringArgumentType.getString(ctx, (String)"chatColor");
        int emberCost = 5;
        try {
            emberCost = IntegerArgumentType.getInteger(ctx, (String)"emberCost");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            affix = PlayerTitlesConfig.Affix.valueOf(affixArg);
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Invalid affix type"));
            return 0;
        }
        PlayerTitlesConfig.Title title = new PlayerTitlesConfig.Title();
        title.put(PlayerTitlesData.Type.TAB_LIST, new PlayerTitlesConfig.Display(tabText, tabColor));
        title.put(PlayerTitlesData.Type.CHAT, new PlayerTitlesConfig.Display(chatText, chatColor));
        Map<String, PlayerTitlesConfig.Title> map = ModConfigs.PLAYER_TITLES.getAll(affix);
        if (map == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Config missing affix map"));
            return 0;
        }
        map.put(id, title);
        try {
            ModConfigs.PLAYER_TITLES.writeConfig();
        }
        catch (IOException e) {
            VaultMod.LOGGER.error("Failed to save PlayerTitlesConfig", (Throwable)e);
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Could not save title config"));
            return 0;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.TITLE_SCROLL);
        TitleScrollItem.setTitle(stack, id, affix);
        ModConfigs.ASCENSION_FORGE.getListings().add(new AscensionForgeConfig.AscensionForgeListing(null, stack, emberCost));
        try {
            ModConfigs.ASCENSION_FORGE.writeConfig();
        }
        catch (IOException e) {
            VaultMod.LOGGER.error("Failed to save AscensionForgeConfig", (Throwable)e);
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Could not save forge config"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Added Ascension title " + id), true);
        return 1;
    }
}

