/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardPos;
import iskallia.vault.core.card.modifier.deck.DeckModifier;
import iskallia.vault.core.card.modifier.deck.DummyDeckModifier;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BoosterPackItem;
import iskallia.vault.item.CardDeckItem;
import iskallia.vault.item.CardItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CardDebugCommand
extends Command {
    private static final Random rand = new Random();

    @Override
    public String getName() {
        return "card_debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"diagnose_deck").executes(this::diagnoseDeck));
        builder.then(Commands.m_82127_((String)"reserialize_deck").executes(this::reserializeDeck));
        builder.then(Commands.m_82127_((String)"create_card").then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests(this::suggestColors).executes(this::createCard))));
        builder.then(Commands.m_82127_((String)"set_tier").then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(this::setCardTier)));
        builder.then(Commands.m_82127_((String)"add_color").then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests(this::suggestColors).executes(this::addCardColor)));
        builder.then(Commands.m_82127_((String)"add_group").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.word()).suggests(this::suggestGroups).executes(this::addCardGroup)));
        builder.then(Commands.m_82127_((String)"add_card_modifier").then(Commands.m_82129_((String)"modifier", (ArgumentType)StringArgumentType.word()).suggests(this::suggestCardModifiers).executes(this::addCardModifier)));
        builder.then(Commands.m_82127_((String)"create_deck").then(Commands.m_82129_((String)"template", (ArgumentType)StringArgumentType.word()).suggests(this::suggestDeckTemplates).executes(this::createDeck)));
        builder.then(Commands.m_82127_((String)"add_deck_modifier").then(Commands.m_82129_((String)"modifier", (ArgumentType)StringArgumentType.word()).suggests(this::suggestDeckModifiers).executes(this::addDeckModifier)));
        builder.then(Commands.m_82127_((String)"remove_deck_modifier").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::removeDeckModifier)));
        builder.then(Commands.m_82127_((String)"list_deck_modifiers").executes(this::listDeckModifiers));
        builder.then(Commands.m_82127_((String)"create_booster_pack").then(Commands.m_82129_((String)"template", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(this::suggestPackTemplates).executes(this::createBoosterPack)));
    }

    private int diagnoseDeck(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack deck = this.getHeldDeck(player);
        Optional<CardDeck> deckOpt = CardDeckItem.getCardDeck(deck);
        if (deckOpt.isEmpty()) {
            player.m_6352_((Component)new TextComponent("No valid deck data found").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        CardDeck cardDeck = deckOpt.get();
        int cardCount = 0;
        int emptySlotCount = 0;
        for (Map.Entry<CardPos, Card> entry : cardDeck.getCards().entrySet()) {
            if (entry.getValue() != null) {
                ++cardCount;
                continue;
            }
            ++emptySlotCount;
        }
        List<DeckModifier<?>> modifiers = cardDeck.getModifiers();
        long dummyModifiers = modifiers.stream().filter(mod -> mod instanceof DummyDeckModifier).count();
        boolean populated = cardDeck.isModifiersPopulated();
        player.m_6352_((Component)new TextComponent("=== Deck Diagnosis ===").m_130940_(ChatFormatting.GOLD), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Total slots: " + (cardCount + emptySlotCount)).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Cards in deck: " + cardCount).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Empty slots: " + emptySlotCount).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Total modifiers: " + modifiers.size()).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Dummy modifiers: " + dummyModifiers).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Modifiers populated: " + populated).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
        if (dummyModifiers > 0L) {
            float dummyValue = new DummyDeckModifier().getModifierValue(null, null, cardDeck);
            player.m_6352_((Component)new TextComponent("DummyDeckModifier value: " + dummyValue).m_130940_(dummyValue == 0.0f ? ChatFormatting.RED : ChatFormatting.GREEN), Util.f_137441_);
            if (dummyValue == 0.0f) {
                player.m_6352_((Component)new TextComponent("ISSUE DETECTED: DummyDeckModifier returns 0, which causes all modifiers to be nullified.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                player.m_6352_((Component)new TextComponent("This should be fixed in the DummyDeckModifier.java file.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            }
        }
        player.m_6352_((Component)new TextComponent("=== Card Value Tests ===").m_130940_(ChatFormatting.GOLD), Util.f_137441_);
        cardDeck.getCards().forEach((pos, card) -> {
            if (card != null) {
                float modValue = cardDeck.getModifierValue((Card)card, (CardPos)pos);
                player.m_6352_((Component)new TextComponent(String.format("Card at (%d,%d): Modifier value = %.2f", pos.x, pos.y, Float.valueOf(modValue))).m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
                if (modValue == 0.0f) {
                    player.m_6352_((Component)new TextComponent("ISSUE DETECTED: Card has 0 modifier value").m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
            }
        });
        player.m_6352_((Component)new TextComponent("=== Active Modifiers ===").m_130940_(ChatFormatting.GOLD), Util.f_137441_);
        for (int i = 0; i < modifiers.size(); ++i) {
            DeckModifier<?> modifier = modifiers.get(i);
            String modifierType = modifier.getClass().getSimpleName();
            float value = modifier.getModifierValue();
            String valueFormatted = String.format("%.2f", Float.valueOf(value));
            player.m_6352_((Component)new TextComponent("[" + i + "] " + modifierType + " (value: " + valueFormatted + ")").m_130940_(modifier instanceof DummyDeckModifier ? ChatFormatting.RED : ChatFormatting.GREEN), Util.f_137441_);
        }
        return 1;
    }

    private int createBoosterPack(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ResourceLocation template = ResourceLocationArgument.m_107011_(ctx, (String)"template");
        if (!ModConfigs.BOOSTER_PACK.getIds().contains(template)) {
            player.m_6352_((Component)new TextComponent("Unknown booster pack template: " + String.valueOf(template)).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        ItemStack packItem = new ItemStack((ItemLike)ModItems.BOOSTER_PACK);
        BoosterPackItem.setId(packItem, template.toString());
        ModConfigs.BOOSTER_PACK.getName(template.toString()).ifPresent(name -> packItem.m_41714_(name));
        player.m_150109_().m_36054_(packItem);
        player.m_6352_((Component)new TextComponent("Created booster pack from template: " + String.valueOf(template)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int reserializeDeck(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack deck = this.getHeldDeck(player);
        Optional<CardDeck> deckOpt = CardDeckItem.getCardDeck(deck);
        if (deckOpt.isEmpty()) {
            player.m_6352_((Component)new TextComponent("No valid deck data found").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        CardDeck cardDeck = deckOpt.get();
        CardDeck newDeck = new CardDeck();
        newDeck.setUuid(cardDeck.getUuid());
        for (Map.Entry<CardPos, Card> entry : cardDeck.getCards().entrySet()) {
            if (entry.getValue() != null) {
                newDeck.setCard(entry.getKey(), entry.getValue());
                continue;
            }
            newDeck.setCard(entry.getKey(), null);
        }
        for (DeckModifier deckModifier : cardDeck.getModifiers()) {
            newDeck.addModifier(deckModifier);
        }
        newDeck.setModifiersPopulated(cardDeck.isModifiersPopulated());
        CardDeckItem.setCardDeck(deck, newDeck);
        player.m_6352_((Component)new TextComponent("Deck has been reserialized.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int createCard(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CardEntry.Color color;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        String colorName = StringArgumentType.getString(ctx, (String)"color");
        try {
            color = CardEntry.Color.valueOf(colorName);
        }
        catch (IllegalArgumentException e) {
            player.m_6352_((Component)new TextComponent("Invalid color: " + colorName).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        CardEntry.Config entryConfig = new CardEntry.Config();
        entryConfig.colors = Set.of(color);
        entryConfig.groups = new HashSet<String>();
        entryConfig.name = new TextComponent("Custom Card");
        ModConfigs.CARD_MODIFIERS.getRandom("@default", JavaRandom.ofNanoTime()).ifPresent(config -> {
            entryConfig.value = config.value;
        });
        CardEntry entry = entryConfig.toEntry();
        ArrayList<CardEntry> entries = new ArrayList<CardEntry>();
        entries.add(entry);
        Card card = new Card(tier, entries);
        ItemStack cardItem = CardItem.create(card);
        player.m_150109_().m_36054_(cardItem);
        player.m_6352_((Component)new TextComponent("Created card (Tier " + tier + ", " + colorName + ")").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setCardTier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = this.getHeldCard(player);
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        Card card = CardItem.getCard(held);
        int oldTier = card.getTier();
        CardItem.modifyCard(held, c -> new Card(tier, c.getEntries()));
        player.m_6352_((Component)new TextComponent("Changed card tier from " + oldTier + " to " + tier).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int addCardColor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CardEntry.Color color;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = this.getHeldCard(player);
        String colorName = StringArgumentType.getString(ctx, (String)"color");
        try {
            color = CardEntry.Color.valueOf(colorName);
        }
        catch (IllegalArgumentException e) {
            player.m_6352_((Component)new TextComponent("Invalid color: " + colorName).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        CardItem.modifyCard(held, c -> {
            for (CardEntry entry : c.getEntries()) {
                entry.getColors().add(color);
            }
            return c;
        });
        player.m_6352_((Component)new TextComponent("Added color " + colorName + " to card").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int addCardGroup(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = this.getHeldCard(player);
        String group = StringArgumentType.getString(ctx, (String)"group");
        CardItem.modifyCard(held, c -> {
            for (CardEntry entry : c.getEntries()) {
                entry.getGroups().add(group);
            }
            return c;
        });
        player.m_6352_((Component)new TextComponent("Added group " + group + " to card").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int addCardModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = this.getHeldCard(player);
        String modifierId = StringArgumentType.getString(ctx, (String)"modifier");
        Card card = CardItem.getCard(held);
        if (card.getEntries().isEmpty()) {
            player.m_6352_((Component)new TextComponent("Card has no entries to modify").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        ModConfigs.CARD_MODIFIERS.getRandom(modifierId, JavaRandom.ofNanoTime()).ifPresentOrElse(config -> {
            CardItem.modifyCard(held, c -> {
                ArrayList<CardEntry> newEntries = new ArrayList<CardEntry>();
                for (CardEntry oldEntry : c.getEntries()) {
                    CardEntry.Config newConfig = new CardEntry.Config(oldEntry.getName(), new HashSet<CardEntry.Color>(oldEntry.getColors()), new HashSet<String>(oldEntry.getGroups()), oldEntry.getModel(), config.value, oldEntry.getScaler(), oldEntry.getCondition());
                    newEntries.add(newConfig.toEntry());
                }
                return new Card(c.getTier(), newEntries);
            });
            player.m_6352_((Component)new TextComponent("Updated card with modifier: " + modifierId).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        }, () -> player.m_6352_((Component)new TextComponent("Modifier not found: " + modifierId).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 1;
    }

    private int createDeck(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String template = StringArgumentType.getString(ctx, (String)"template");
        if (!ModConfigs.CARD_DECK.has(template)) {
            player.m_6352_((Component)new TextComponent("Unknown deck template: " + template).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        ItemStack deckItem = new ItemStack((ItemLike)ModItems.CARD_DECK);
        CardDeckItem.setId(deckItem, template);
        ModConfigs.CARD_DECK.generate(template, JavaRandom.ofNanoTime()).ifPresent(deck -> {
            deck.setModifiersPopulated(true);
            CardDeckItem.setCardDeck(deckItem, deck);
        });
        player.m_150109_().m_36054_(deckItem);
        player.m_6352_((Component)new TextComponent("Created card deck from template: " + template).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int addDeckModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack deck = this.getHeldDeck(player);
        String modifierId = StringArgumentType.getString(ctx, (String)"modifier");
        ModConfigs.DECK_MODIFIERS.getRandom(modifierId, JavaRandom.ofNanoTime()).ifPresentOrElse(modifier -> CardDeckItem.getCardDeck(deck).ifPresent(cardDeck -> {
            cardDeck.addModifier((DeckModifier<?>)modifier);
            cardDeck.setModifiersPopulated(true);
            CardDeckItem.setCardDeck(deck, cardDeck);
            player.m_6352_((Component)new TextComponent("Added deck modifier: " + modifierId).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        }), () -> player.m_6352_((Component)new TextComponent("Modifier not found: " + modifierId).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 1;
    }

    private int removeDeckModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack deck = this.getHeldDeck(player);
        int index = IntegerArgumentType.getInteger(ctx, (String)"index");
        CardDeckItem.getCardDeck(deck).ifPresent(cardDeck -> {
            List<DeckModifier<?>> modifiers = cardDeck.getModifiers();
            if (index < 0 || index >= modifiers.size()) {
                player.m_6352_((Component)new TextComponent("Invalid modifier index. Use /card_debug list_deck_modifiers to see indices.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                return;
            }
            cardDeck.clearModifiers();
            for (int i = 0; i < modifiers.size(); ++i) {
                if (i == index) continue;
                cardDeck.addModifier(modifiers.get(i));
            }
            CardDeckItem.setCardDeck(deck, cardDeck);
            player.m_6352_((Component)new TextComponent("Removed deck modifier at index " + index).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        });
        return 1;
    }

    private int listDeckModifiers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack deck = this.getHeldDeck(player);
        CardDeckItem.getCardDeck(deck).ifPresent(cardDeck -> {
            List<DeckModifier<?>> modifiers = cardDeck.getModifiers();
            if (modifiers.isEmpty()) {
                player.m_6352_((Component)new TextComponent("No modifiers on this deck.").m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
                return;
            }
            player.m_6352_((Component)new TextComponent("=== Deck Modifiers ===").m_130940_(ChatFormatting.GOLD), Util.f_137441_);
            for (int i = 0; i < modifiers.size(); ++i) {
                DeckModifier<?> modifier = modifiers.get(i);
                String modifierType = modifier.getClass().getSimpleName();
                float value = modifier.getModifierValue();
                String valueFormatted = String.format("%.2f", Float.valueOf(value));
                player.m_6352_((Component)new TextComponent("[" + i + "] " + modifierType + " (value: " + valueFormatted + ")").m_130940_(modifier instanceof DummyDeckModifier ? ChatFormatting.RED : ChatFormatting.GREEN), Util.f_137441_);
            }
        });
        return 1;
    }

    private CompletableFuture<Suggestions> suggestColors(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List colors = Arrays.stream(CardEntry.Color.values()).map(Enum::name).collect(Collectors.toList());
        return SharedSuggestionProvider.m_82970_(colors, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestGroups(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ArrayList<String> groups = new ArrayList<String>(Card.TYPES);
        groups.add("Foil");
        return SharedSuggestionProvider.m_82970_(groups, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestCardModifiers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Set<String> directModifiers = ModConfigs.CARD_MODIFIERS.getValues().keySet();
        ArrayList<String> allSuggestions = new ArrayList<String>();
        allSuggestions.addAll(directModifiers);
        Collections.sort(allSuggestions);
        return SharedSuggestionProvider.m_82970_(allSuggestions, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestDeckTemplates(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(ModConfigs.CARD_DECK.getIds(), (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestPackTemplates(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(ModConfigs.BOOSTER_PACK.getIds(), (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestDeckModifiers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Set<String> directModifiers = ModConfigs.DECK_MODIFIERS.getValues().keySet();
        Set poolModifiers = ModConfigs.DECK_MODIFIERS.getPools().keySet().stream().map(key -> "@" + key).collect(Collectors.toSet());
        ArrayList<String> allSuggestions = new ArrayList<String>();
        allSuggestions.addAll(directModifiers);
        allSuggestions.addAll(poolModifiers);
        Collections.sort(allSuggestions);
        return SharedSuggestionProvider.m_82970_(allSuggestions, (SuggestionsBuilder)builder);
    }

    private ItemStack getHeldCard(ServerPlayer player) throws CommandSyntaxException {
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(held.m_41720_() instanceof CardItem)) {
            throw new CommandSyntaxException(null, (Message)new TextComponent("Not holding a card"));
        }
        return held;
    }

    private ItemStack getHeldDeck(ServerPlayer player) throws CommandSyntaxException {
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(held.m_41720_() instanceof CardDeckItem)) {
            throw new CommandSyntaxException(null, (Message)new TextComponent("Not holding a card deck"));
        }
        return held;
    }
}

