/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.command.CrystalCommand;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionSeries;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class CompanionCommand
extends Command {
    @Override
    public String getName() {
        return "companion";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"addxp").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::addXP)));
        builder.then(Commands.m_82127_((String)"setxp").then(Commands.m_82129_((String)"xp", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setXP)));
        builder.then(Commands.m_82127_((String)"setlevel").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::setLevel)));
        builder.then(Commands.m_82127_((String)"sethearts").then(Commands.m_82129_((String)"hearts", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setHearts)));
        builder.then(Commands.m_82127_((String)"setmaxhearts").then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::setMaxHearts)));
        builder.then(Commands.m_82127_((String)"setskin").then(Commands.m_82129_((String)"username", (ArgumentType)StringArgumentType.string()).executes(this::setSkin)));
        builder.then(Commands.m_82127_((String)"setcooldown").then(Commands.m_82129_((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setCooldown)));
        builder.then(Commands.m_82127_((String)"addcooldown").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::addCooldown)));
        builder.then(Commands.m_82127_((String)"reducecooldown").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::reduceCooldown)));
        builder.then(Commands.m_82127_((String)"startcooldown").executes(this::startCooldown));
        builder.then(Commands.m_82127_((String)"setrelic").then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CrystalCommand.SUGGEST_MODIFIER).then(Commands.m_82129_((String)"model", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setRelic)))));
        builder.then(Commands.m_82127_((String)"clearrelics").executes(this::clearRelics));
        builder.then(Commands.m_82127_((String)"settemporal").then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CrystalCommand.SUGGEST_MODIFIER).executes(this::setTemporal)));
        builder.then(Commands.m_82127_((String)"setname").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::setName)));
        builder.then(Commands.m_82127_((String)"setowner").then(Commands.m_82129_((String)"owner", (ArgumentType)StringArgumentType.string()).executes(this::setOwner)));
        builder.then(Commands.m_82127_((String)"settype").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).executes(this::setType)));
        builder.then(Commands.m_82127_((String)"setseries").then(Commands.m_82129_((String)"series", (ArgumentType)StringArgumentType.string()).executes(this::setSeries)));
    }

    private ItemStack getCompanionItem(ServerPlayer player) {
        Optional<ItemStack> held = CompanionItem.getCompanion((LivingEntity)player);
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() == ModItems.COMPANION) {
            return stack;
        }
        if (held.isEmpty() || held.get().m_41720_() != ModItems.COMPANION) {
            player.m_6352_((Component)new TextComponent("Not holding companion!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return ItemStack.f_41583_;
        }
        return held.get();
    }

    private int addXP(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        CompanionItem.addCompanionXP(stack, amount);
        player.m_6352_((Component)new TextComponent("Added " + amount + " XP.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        CompanionItem.setCompanionLevel(stack, level);
        player.m_6352_((Component)new TextComponent("Set level to " + level + ".").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setHearts(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int hearts = IntegerArgumentType.getInteger(ctx, (String)"hearts");
        CompanionItem.setCompanionHearts(stack, hearts);
        player.m_6352_((Component)new TextComponent("Set hearts to " + hearts + ".").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setSkin(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        String skin = StringArgumentType.getString(ctx, (String)"username");
        CompanionItem.setSkinName(stack, skin);
        player.m_6352_((Component)new TextComponent("Set skin to " + skin + ".").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setCooldown(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int minutes = IntegerArgumentType.getInteger(ctx, (String)"minutes");
        CompanionItem.setCompanionCooldown(stack, minutes);
        player.m_6352_((Component)new TextComponent("Cooldown set to " + minutes + " minutes.").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setRelic(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int slot = IntegerArgumentType.getInteger(ctx, (String)"slot");
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        int model = IntegerArgumentType.getInteger(ctx, (String)"model");
        CompanionItem.setRelic(stack, model, slot, id);
        player.m_6352_((Component)new TextComponent("Set relic slot " + slot + " to " + String.valueOf(id)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int clearRelics(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        CompanionItem.clearAllRelics(stack);
        player.m_6352_((Component)new TextComponent("Cleared relics").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setXP(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int xp = IntegerArgumentType.getInteger(ctx, (String)"xp");
        CompanionItem.setCompanionXP(stack, xp);
        player.m_6352_((Component)new TextComponent("Set XP to " + xp).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setMaxHearts(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int max = IntegerArgumentType.getInteger(ctx, (String)"max");
        CompanionItem.setCompanionMaxHearts(stack, max);
        player.m_6352_((Component)new TextComponent("Set max hearts to " + max).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int addCooldown(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int seconds = IntegerArgumentType.getInteger(ctx, (String)"seconds");
        CompanionItem.addCooldownTime(stack, seconds);
        player.m_6352_((Component)new TextComponent("Added " + seconds + "s to cooldown").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int reduceCooldown(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        int seconds = IntegerArgumentType.getInteger(ctx, (String)"seconds");
        CompanionItem.reduceCooldown(stack, seconds);
        player.m_6352_((Component)new TextComponent("Reduced cooldown by " + seconds + "s").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int startCooldown(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        CompanionItem.startCompanionCooldown(stack);
        player.m_6352_((Component)new TextComponent("Started cooldown").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setTemporal(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        CompanionItem.setTemporalModifier(stack, id);
        player.m_6352_((Component)new TextComponent("Set temporal modifier to " + String.valueOf(id)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setName(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        String name = StringArgumentType.getString(ctx, (String)"name");
        CompanionItem.setPetName(stack, name);
        player.m_6352_((Component)new TextComponent("Set name to " + name).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setOwner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        ServerPlayer ownerPlayer = EntityArgument.m_91474_(ctx, (String)"owner");
        UUID owner = ownerPlayer.m_142081_();
        CompanionItem.setOwner(stack, owner);
        player.m_6352_((Component)new TextComponent("Set owner to " + String.valueOf(owner)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        String type = StringArgumentType.getString(ctx, (String)"type");
        CompanionItem.setPetType(stack, type);
        player.m_6352_((Component)new TextComponent("Set type to " + type).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int setSeries(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack stack = this.getCompanionItem(player);
        if (stack.m_41619_()) {
            return 0;
        }
        String seriesStr = StringArgumentType.getString(ctx, (String)"series");
        try {
            CompanionSeries series = CompanionSeries.valueOf(seriesStr.toUpperCase());
            CompanionItem.setPetSeries(stack, series);
            player.m_6352_((Component)new TextComponent("Set series to " + String.valueOf((Object)series)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        }
        catch (IllegalArgumentException e) {
            player.m_6352_((Component)new TextComponent("Invalid series").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        return 1;
    }
}

