/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.objective.NullCrystalObjective;
import iskallia.vault.item.crystal.objective.PersonalCrystalObjective;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.item.crystal.properties.InstabilityCrystalProperties;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.world.data.ParadoxCrystalData;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class CrystalCommand
extends Command {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_MODIFIER = (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)VaultModifierRegistry.getAll().map(VaultModifier::getId).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_THEME = (context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)VaultRegistry.THEME.getKeys().stream().map(VersionedKey::getId).map(ResourceLocation::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_LAYOUT = (context, builder) -> SharedSuggestionProvider.m_82981_(CrystalData.LAYOUT.keys().stream().filter(string -> !string.equals("null")), (SuggestionsBuilder)builder);

    @Override
    public String getName() {
        return "crystal";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"setRandomModifiers").then(Commands.m_82129_((String)"random", (ArgumentType)BoolArgumentType.bool()).executes(this::setRandomModifiers)));
        builder.then(Commands.m_82127_((String)"setExhausted").then(Commands.m_82129_((String)"unmodifiable", (ArgumentType)BoolArgumentType.bool()).executes(this::setUnmodifiable)));
        builder.then(Commands.m_82127_((String)"setUnmodifiable").then(Commands.m_82129_((String)"unmodifiable", (ArgumentType)BoolArgumentType.bool()).executes(this::setUnmodifiable)));
        builder.then(Commands.m_82127_((String)"addModifier").then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_MODIFIER).then(Commands.m_82129_((String)"stackSize", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::addModifier))));
        builder.then(Commands.m_82127_((String)"clearObjective").executes(this::clearObjective));
        builder.then(Commands.m_82127_((String)"setObjective").then(Commands.m_82129_((String)"objective", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(CrystalData.OBJECTIVE.keys().stream().filter(string -> !string.equals("null") && !string.equals("monolith") && !string.equals("ascension")), (SuggestionsBuilder)suggestionsBuilder)).executes(this::setObjective)));
        builder.then(Commands.m_82127_((String)"setInstability").then(Commands.m_82129_((String)"instability", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(this::setInstability)));
        builder.then(Commands.m_82127_((String)"setLevel").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setLevel)));
        builder.then(Commands.m_82127_((String)"setParadoxCooldown").then(Commands.m_82129_((String)"timeoutSeconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setParadoxCooldown)));
        builder.then(Commands.m_82127_((String)"setVolume").then(Commands.m_82129_((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setVolume)));
        builder.then(Commands.m_82127_((String)"setSeed").then(Commands.m_82129_((String)"seed", (ArgumentType)LongArgumentType.longArg()).executes(this::setSeed)));
        builder.then(Commands.m_82127_((String)"setTheme").then(Commands.m_82129_((String)"theme", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_THEME).executes(this::setTheme)));
        builder.then(Commands.m_82127_((String)"setLayout").then(Commands.m_82129_((String)"layout", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_LAYOUT).executes(this::setLayout)));
    }

    private int setParadoxCooldown(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(context);
        CrystalData data = CrystalData.read(crystal);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!(data.getObjective() instanceof PersonalCrystalObjective)) {
            player.m_6352_((Component)new TextComponent("Only works on personal crystals"), Util.f_137441_);
            return 0;
        }
        ParadoxCrystalData.Entry entry = ParadoxCrystalData.get(player.m_20194_()).getOrCreate(player.m_142081_());
        entry.unlockTime = ZonedDateTime.now().plusSeconds(IntegerArgumentType.getInteger(context, (String)"timeoutSeconds")).withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
        entry.changed = true;
        return 0;
    }

    private int setLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(context);
        CrystalData data = CrystalData.read(crystal);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        data.getProperties().setLevel(level);
        data.write(crystal);
        return 0;
    }

    private int setLayout(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        String layoutId = StringArgumentType.getString(ctx, (String)"layout");
        CrystalLayout layout = CrystalData.LAYOUT.getValue(layoutId);
        if (layout == null) {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("Unknown layout: " + layoutId), Util.f_137441_);
            return 0;
        }
        data.setLayout(layout);
        data.write(crystal);
        return 0;
    }

    private int setVolume(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(context);
        CrystalData data = CrystalData.read(crystal);
        int volume = IntegerArgumentType.getInteger(context, (String)"volume");
        CrystalProperties crystalProperties = data.getProperties();
        if (crystalProperties instanceof CapacityCrystalProperties) {
            CapacityCrystalProperties capacityCrystalProperties = (CapacityCrystalProperties)crystalProperties;
            capacityCrystalProperties.setVolume(volume);
        }
        data.write(crystal);
        return 0;
    }

    private int setSeed(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(context);
        CrystalData data = CrystalData.read(crystal);
        long seed = LongArgumentType.getLong(context, (String)"seed");
        CrystalProperties crystalProperties = data.getProperties();
        if (crystalProperties instanceof CapacityCrystalProperties) {
            CapacityCrystalProperties capacityCrystalProperties = (CapacityCrystalProperties)crystalProperties;
            capacityCrystalProperties.setCustomSeed(seed);
        }
        data.write(crystal);
        return 0;
    }

    private int setRandomModifiers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        boolean randomModifiers = BoolArgumentType.getBool(ctx, (String)"random");
        data.getModifiers().setRandomModifiers(randomModifiers);
        data.write(crystal);
        return 0;
    }

    private int setUnmodifiable(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        data.getProperties().setUnmodifiable(BoolArgumentType.getBool(ctx, (String)"unmodifiable"));
        data.write(crystal);
        return 0;
    }

    private int addModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        VaultModifier<?> modifier = VaultModifierRegistry.getOrDefault(id, null);
        if (modifier == null) {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("Unknown Modifier: " + String.valueOf(id)), Util.f_137441_);
            return 0;
        }
        int stackSize = IntegerArgumentType.getInteger(ctx, (String)"stackSize");
        data.getModifiers().add(VaultModifierStack.of(modifier, stackSize));
        data.write(crystal);
        return 0;
    }

    private int clearObjective(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        data.setObjective(NullCrystalObjective.INSTANCE);
        data.write(crystal);
        return 0;
    }

    private int setObjective(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        String objectiveId = StringArgumentType.getString(ctx, (String)"objective");
        if (objectiveId.equals("monolith") || objectiveId.equals("ascension")) {
            return 0;
        }
        data.setObjective(CrystalData.OBJECTIVE.getValue(objectiveId));
        data.write(crystal);
        return 0;
    }

    private int setInstability(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        float instability = FloatArgumentType.getFloat(ctx, (String)"instability");
        CrystalProperties crystalProperties = data.getProperties();
        if (crystalProperties instanceof InstabilityCrystalProperties) {
            InstabilityCrystalProperties properties = (InstabilityCrystalProperties)crystalProperties;
            properties.setInstability(instability);
        }
        data.write(crystal);
        return 0;
    }

    private int setTheme(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = CrystalData.read(crystal);
        ResourceLocation theme = ResourceLocationArgument.m_107011_(ctx, (String)"theme");
        data.setTheme(new ValueCrystalTheme(theme));
        data.write(crystal);
        return 0;
    }

    private ItemStack getCrystal(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultCrystalItem)) {
            player.m_6352_((Component)new TextComponent("Not holding crystal!"), Util.f_137441_);
            throw new RuntimeException();
        }
        return held;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

