/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.google.common.collect.Streams;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.command.Command;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.Event;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.loot.generator.TieredLootTableGenerator;
import iskallia.vault.dump.EntityAttrDump;
import iskallia.vault.dump.GearModelDump;
import iskallia.vault.dump.TranslationsDump;
import iskallia.vault.entity.entity.guardian.AbstractGuardianEntity;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ErrorItem;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.world.data.DiscoveredTrinketsData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerGreedData;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.PlayerVaultAltarData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.VaultPlayerCompassData;
import iskallia.vault.world.data.VaultPlayerStats;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.command.EnumArgument;

public class DebugCommand
extends Command {
    private static final RandomSource rand = JavaRandom.ofNanoTime();
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_LOOT_TABLE = (context, builder) -> SharedSuggestionProvider.m_82957_(VaultRegistry.LOOT_TABLE.getKeys().stream().map(VersionedKey::getId), (SuggestionsBuilder)builder);

    @Override
    public String getName() {
        return "debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"dump_configs").executes(this::dumpConfigs));
        builder.then(Commands.m_82127_((String)"dump_blockstate").then(Commands.m_82129_((String)"block_pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> this.dumpBlockstate((CommandContext<CommandSourceStack>)ctx, BlockPosArgument.m_174395_((CommandContext)ctx, (String)"block_pos")))));
        builder.then(Commands.m_82127_((String)"dump_item_nbt").executes(this::dumpItemNBT));
        builder.then(Commands.m_82127_((String)"scan_inventory").executes(this::scanInventory));
        builder.then(Commands.m_82127_((String)"debug_config_files").executes(this::validateConfigFiles));
        builder.then(Commands.m_82127_((String)"dev_world").executes(this::setupDevWorld));
        builder.then(Commands.m_82127_((String)"insert_loot").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_LOOT_TABLE).executes(this::insertLoot))));
        builder.then(Commands.m_82127_((String)"generate_loot").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_LOOT_TABLE).then(Commands.m_82129_((String)"quantity", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"rarity", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::generateLoot))))));
        builder.then(Commands.m_82127_((String)"debug_events").executes(this::debugEvents));
        builder.then(Commands.m_82127_((String)"prompt_vault_stats").executes(this::promptVaultStats));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"altar_level").then(Commands.m_82127_((String)"get").executes(this::getAltarLevel))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(this::setAltarLevel))));
        builder.then(Commands.m_82127_((String)"expertise").then(Commands.m_82127_((String)"reset_all").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetPlayerExpertises))));
        builder.then(Commands.m_82127_((String)"expertise").then(Commands.m_82127_((String)"world_reset").executes(this::resetAllPlayerExpertises)));
        builder.then(Commands.m_82127_((String)"altar").then(Commands.m_82127_((String)"complete").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::completeAltar))));
        for (VaultGod god : VaultGod.values()) {
            builder.then(Commands.m_82127_((String)"reputation").then(Commands.m_82127_((String)god.name().toLowerCase()).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.addReputation(god, (CommandContext<CommandSourceStack>)context)))));
        }
        builder.then(Commands.m_82127_((String)"discover_all_trinkets").executes(this::discoverAllTrinkets));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"compass").then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mode", (ArgumentType)EnumArgument.enumArgument(VaultCompassMode.class)).executes(this::unlockCompassMode))))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mode", (ArgumentType)EnumArgument.enumArgument(VaultCompassMode.class)).executes(this::lockCompassMode))))).then(Commands.m_82127_((String)"set_progress").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"mode", (ArgumentType)EnumArgument.enumArgument(VaultCompassMode.class)).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setCompassProgress))))));
        builder.then(Commands.m_82127_((String)"find_guardians").then(Commands.m_82129_((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(this::findGuardians)));
        builder.then(Commands.m_82127_((String)"complete_herald").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::completeHerald)));
    }

    private int unlockCompassMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        VaultCompassMode mode = (VaultCompassMode)((Object)context.getArgument("mode", VaultCompassMode.class));
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        VaultPlayerCompassData.CompassInfo info = data.get(player.m_142081_());
        info.unlock(mode);
        data.saveToPlayer(player, info);
        VaultMod.LOGGER.info("Unlocked compass mode {} for {}", (Object)mode, (Object)player.m_6302_());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Unlocked " + mode.name() + " for " + player.m_7755_().getString()), true);
        return 0;
    }

    private int lockCompassMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        VaultCompassMode mode = (VaultCompassMode)((Object)context.getArgument("mode", VaultCompassMode.class));
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        VaultPlayerCompassData.CompassInfo info = data.get(player.m_142081_());
        info.lock(mode);
        data.saveToPlayer(player, info);
        VaultMod.LOGGER.info("Locked compass mode {} for {}", (Object)mode, (Object)player.m_6302_());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Locked " + mode.name() + " for " + player.m_7755_().getString()), true);
        return 0;
    }

    private int setCompassProgress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        VaultCompassMode mode = (VaultCompassMode)((Object)context.getArgument("mode", VaultCompassMode.class));
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        VaultPlayerCompassData.CompassInfo info = data.get(player.m_142081_());
        info.setProgress(mode, value);
        data.saveToPlayer(player, info);
        VaultMod.LOGGER.info("Set compass mode {} progress to {} for {}", (Object)mode, (Object)value, (Object)player.m_6302_());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Set " + mode.name() + " progress to " + value + " for " + player.m_7755_().getString()), true);
        return 0;
    }

    private int findGuardians(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!(source.m_81373_() instanceof ServerPlayer)) {
            source.m_81352_((Component)new TextComponent("This command can only be executed by a player!"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)source.m_81373_();
        ServerLevel level = player.m_183503_();
        Vec3 playerPos = player.m_20182_();
        double radius = DoubleArgumentType.getDouble(context, (String)"radius");
        AABB searchArea = new AABB(playerPos.f_82479_ - radius, playerPos.f_82480_ - radius, playerPos.f_82481_ - radius, playerPos.f_82479_ + radius, playerPos.f_82480_ + radius, playerPos.f_82481_ + radius);
        List entities = level.m_45976_(AbstractGuardianEntity.class, searchArea);
        if (entities.isEmpty()) {
            source.m_81354_((Component)new TextComponent("No guardian entities found within " + radius + " blocks."), false);
            VaultMod.LOGGER.info("[FindGuardians] No guardian entities found within " + radius + " blocks of player " + player.m_7755_().getString());
            return 0;
        }
        source.m_81354_((Component)new TextComponent("Found " + entities.size() + " guardian entities:"), false);
        VaultMod.LOGGER.info("[FindGuardians] Found " + entities.size() + " guardian entities near player " + player.m_7755_().getString() + ":");
        for (AbstractGuardianEntity entity : entities) {
            Vec3 guardianPos = entity.m_20182_();
            double distance = playerPos.m_82554_(guardianPos);
            String entityClass = ((Object)((Object)entity)).getClass().getSimpleName();
            String guardianType = entity.getGuardianType() != null ? entity.getGuardianType().toString() : "Unknown";
            String message = String.format("  - %s (Type: %s) at (%.1f, %.1f, %.1f) - Distance: %.1f blocks - UUID: %s", entityClass, guardianType, guardianPos.f_82479_, guardianPos.f_82480_, guardianPos.f_82481_, distance, entity.m_142081_());
            source.m_81354_((Component)new TextComponent(message), false);
            VaultMod.LOGGER.info("[FindGuardians] " + message);
        }
        return entities.size();
    }

    private int completeAltar(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        PlayerVaultAltarData data = PlayerVaultAltarData.get(player.m_183503_());
        AltarInfusionRecipe recipe = data.getRecipe((Player)player);
        List<RequiredItems> requiredItems = recipe.getIncompleteRequiredItems();
        if (!requiredItems.isEmpty()) {
            requiredItems.forEach(item -> item.setCurrentAmount(item.getAmountRequired()));
            List<BlockPos> altars = data.getAltars(player.m_142081_());
            altars.stream().filter(pos -> player.m_183503_().m_46749_(pos)).map(pos -> player.m_183503_().m_7702_(pos)).filter(te -> te instanceof VaultAltarTileEntity).map(te -> (VaultAltarTileEntity)((Object)te)).forEach(VaultAltarTileEntity::sendUpdates);
            data.m_77762_();
        }
        return 1;
    }

    private int addReputation(VaultGod god, CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerReputationData.addReputation(((CommandSourceStack)context.getSource()).m_81375_().m_142081_(), god, IntegerArgumentType.getInteger(context, (String)"count"));
        return 0;
    }

    private int generateLoot(CommandContext<CommandSourceStack> context) {
        ResourceLocation id = ResourceLocationArgument.m_107011_(context, (String)"id");
        float quantity = FloatArgumentType.getFloat(context, (String)"quantity");
        float rarity = FloatArgumentType.getFloat(context, (String)"rarity");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        LootTableKey table = VaultRegistry.LOOT_TABLE.getKey(id);
        if (table == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Invalid loot table " + String.valueOf(id)));
            return 0;
        }
        TieredLootTableGenerator gen = new TieredLootTableGenerator(Version.latest(), table, rarity, quantity, 54);
        HashMap<ResourceLocation, Integer> cache = new HashMap<ResourceLocation, Integer>();
        HashMap<VaultRarity, Integer> rarities = new HashMap<VaultRarity, Integer>();
        for (int i = 0; i < count; ++i) {
            gen.generate(JavaRandom.ofNanoTime());
            VaultRarity[] it = gen.getItems();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                ResourceLocation itemId = stack.m_41720_() == ModItems.ERROR_ITEM ? ErrorItem.getId(stack) : stack.m_41720_().getRegistryName();
                cache.put(itemId, cache.getOrDefault(itemId, 0) + stack.m_41613_());
                it.remove();
            }
            VaultRarity rarityEnum = ModConfigs.VAULT_CHEST.getRarity(gen.getCDF());
            rarities.put(rarityEnum, rarities.getOrDefault((Object)rarityEnum, 0) + 1);
        }
        StringBuilder copy = new StringBuilder();
        for (VaultRarity value : VaultRarity.values()) {
            int frequency = rarities.getOrDefault((Object)value, 0);
            MutableComponent text = new TextComponent("").m_7220_((Component)new TextComponent(frequency + " ")).m_7220_((Component)new TextComponent(value.name()).m_6270_(Style.f_131099_.m_131140_(value.color)));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)text, false);
            copy.append(text.getString()).append("\n");
        }
        ArrayList entries = new ArrayList(cache.entrySet());
        entries.sort((o1, o2) -> Integer.compare((Integer)o2.getValue(), (Integer)o1.getValue()));
        entries.forEach(e -> {
            Item item = Registry.f_122827_.m_6612_((ResourceLocation)e.getKey()).orElse(null);
            TextComponent text = item != null ? item.m_7626_(new ItemStack((ItemLike)item)) : new TextComponent(((ResourceLocation)e.getKey()).toString());
            MutableComponent result = new TextComponent("").m_7220_((Component)new TextComponent(String.valueOf(e.getValue()) + " ")).m_7220_((Component)text);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)result, false);
            copy.append(result.getString()).append("\n");
        });
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[Copy]").m_130940_(ChatFormatting.GOLD).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copy.toString()))), false);
        return 0;
    }

    private int resetAllPlayerExpertises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        statsData.resetAndReturnAllPlayerExpertisePoints(level);
        PlayerExpertisesData.get(level).resetAllPlayerExpertiseTrees(level);
        return 0;
    }

    private int resetPlayerExpertises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        statsData.resetAndReturnExpertisePoints(player);
        PlayerExpertisesData.get(level).resetExpertiseTree(player);
        return 0;
    }

    private int getAltarLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int level = PlayerStatsData.get().get((Player)player).getCrystals().size();
        player.m_6352_((Component)new TextComponent("Altar Level: " + level), player.m_142081_());
        return 0;
    }

    private int setAltarLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        PlayerStatsData playerStatsData = PlayerStatsData.get();
        playerStatsData.clearCrystals(player.m_142081_());
        for (int i = 0; i <= level; ++i) {
            playerStatsData.onCrystalCrafted(player.m_142081_(), List.of(new RequiredItems("resource", List.of(ItemStack.f_41583_), 100), new RequiredItems("mob", List.of(ItemStack.f_41583_), 100), new RequiredItems("farmable", List.of(ItemStack.f_41583_), 100), new RequiredItems("misc", List.of(ItemStack.f_41583_), 100)));
        }
        return 0;
    }

    private int promptVaultStats(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultPlayerStats.prompt(((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private int debugEvents(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        player.m_9146_((Component)new TextComponent("~ Listing events ordered by highest priority ~").m_130940_(ChatFormatting.GREEN), ChatType.SYSTEM, player.m_142081_());
        ArrayList valid = new ArrayList();
        for (Event<?, ?> event : CommonEvents.REGISTRY) {
            for (Integer priority : event.getListeners().keySet()) {
                Map<Object, List<Consumer<?>>> map = event.getListeners().get(priority);
                for (List<Consumer<?>> listeners : map.values()) {
                    if (listeners.isEmpty()) continue;
                    valid.add(event);
                }
            }
        }
        for (Event<?, ?> event : CommonEvents.REGISTRY) {
            if (!valid.contains(event)) continue;
            player.m_9146_((Component)new TextComponent("=== ").m_7220_((Component)new TextComponent(event.getClass().getSimpleName()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)new TextComponent(" ===").m_130940_(ChatFormatting.WHITE)), ChatType.SYSTEM, player.m_142081_());
            for (Integer priority : event.getListeners().keySet()) {
                if (event.getListeners().get(priority).isEmpty()) continue;
                player.m_9146_((Component)new TextComponent("Priority: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.valueOf(priority)).m_130940_(priority == 0 ? ChatFormatting.GRAY : (priority < 0 ? ChatFormatting.RED : ChatFormatting.GREEN))), ChatType.SYSTEM, player.m_142081_());
                for (Map.Entry<Object, List<Consumer<?>>> map : event.getListeners().get(priority).entrySet()) {
                    String string;
                    Object object = map.getKey();
                    if (object instanceof Class) {
                        Class clazz = (Class)object;
                        string = clazz.getSimpleName();
                    } else {
                        string = map.getKey().getClass().getSimpleName();
                    }
                    player.m_9146_((Component)new TextComponent("   " + string).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)new TextComponent(" has ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent("" + map.getValue().size()).m_130940_(ChatFormatting.GOLD)), ChatType.SYSTEM, player.m_142081_());
                }
            }
        }
        return 0;
    }

    private int insertLoot(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        ResourceLocation id = ResourceLocationArgument.m_107011_(context, (String)"id");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                LootTableGenerator generator = new LootTableGenerator(Version.latest(), VaultRegistry.LOOT_TABLE.getKey(id), 0.0f);
                generator.generate(JavaRandom.ofNanoTime());
                generator.getItems().forEachRemaining(stack -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false));
            });
        }
        return 0;
    }

    private int setupDevWorld(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        MinecraftServer srv = player.m_20194_();
        ServerLevel level = player.m_183503_();
        GameRules rules = level.m_46469_();
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46150_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46134_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46131_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46125_)).m_46246_(false, srv);
        level.m_8615_(6000L);
        level.m_8606_(6000, 0, false, false);
        List<Entity> entities = Streams.stream((Iterable)level.m_142646_().m_142273_()).filter(entity -> !(entity instanceof Player)).toList();
        entities.forEach(entity -> entity.m_142467_(Entity.RemovalReason.DISCARDED));
        return 0;
    }

    private int validateConfigFiles(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        src.m_81354_((Component)new TextComponent("Validating Workbench files..."), true);
        HashMap<Item, List> itemMissingTargets = new HashMap<Item, List>();
        ModConfigs.VAULT_GEAR_WORKBENCH_CONFIG.forEach((item, cfg) -> cfg.getAllCraftableModifiers().forEach(modCfg -> {
            if (modCfg.createModifier().isEmpty()) {
                itemMissingTargets.computeIfAbsent((Item)item, k -> new ArrayList()).add(modCfg);
            }
        }));
        if (itemMissingTargets.isEmpty()) {
            src.m_81354_((Component)new TextComponent("Workbench files are valid"), true);
        } else {
            itemMissingTargets.forEach((item, cfgs) -> {
                src.m_81354_((Component)new TextComponent("Missing targets for: " + String.valueOf(item.getRegistryName())), true);
                cfgs.forEach(cfg -> src.m_81354_((Component)new TextComponent(String.valueOf(cfg.getModifierIdentifier()) + " - tier " + cfg.getModifierTier()), true));
            });
        }
        src.m_81354_((Component)new TextComponent("Validating Card files..."), true);
        HashMap<String, List> packModifierMap = new HashMap<String, List>();
        ModConfigs.BOOSTER_PACK.getValues().forEach((id, entry) -> entry.getCard().forEach((cardCfg, weight) -> cardCfg.forEach(cardConfig -> {
            String modifier = cardConfig.getModifier();
            ModConfigs.CARD_MODIFIERS.getAll(modifier).forEach((modId, cfg) -> {
                if (cfg == null) {
                    packModifierMap.computeIfAbsent((String)modId, k -> new ArrayList()).add(modifier);
                }
            });
        })));
        if (packModifierMap.isEmpty()) {
            src.m_81354_((Component)new TextComponent("Card files are valid"), true);
        } else {
            packModifierMap.forEach((pack, modifiers) -> {
                src.m_81354_((Component)new TextComponent("Missing modifiers for booster pack: " + pack), true);
                modifiers.forEach(modifier -> src.m_81354_((Component)new TextComponent(modifier), true));
            });
        }
        return 0;
    }

    private int dumpBlockstate(CommandContext<CommandSourceStack> context, BlockPos blockPos) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel world = player.m_183503_();
        BlockState blockState = world.m_8055_(blockPos);
        VaultMod.LOGGER.info("Blockstate {} = {}", (Object)blockPos, (Object)blockState);
        player.m_6352_((Component)new TextComponent(blockState.toString()), Util.f_137441_);
        return 0;
    }

    private int scanInventory(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String msg = InventoryUtil.findAllItems((Player)player).stream().map(InventoryUtil.ItemAccess::getStack).map(ItemStack::toString).collect(Collectors.joining(", "));
        VaultMod.LOGGER.info(msg);
        player.m_6352_((Component)new TextComponent(msg), Util.f_137441_);
        return 0;
    }

    private int dumpItemNBT(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldStack = player.m_21205_();
        VaultMod.LOGGER.info("Held Stack NBT = {}", (Object)heldStack.m_41783_());
        player.m_6352_((Component)new TextComponent(heldStack.m_41783_().toString()), Util.f_137441_);
        return 0;
    }

    private int dumpConfigs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String gamePath = FMLPaths.GAMEDIR.get().toString();
        String dumpPath = gamePath + File.separator + "config-dump";
        try {
            new GearModelDump().dumpToFile(dumpPath);
            new EntityAttrDump().dumpToFile(dumpPath);
            new TranslationsDump().dumpToFile(dumpPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandRuntimeException((Component)new TextComponent("Unable to dump file.."));
        }
        return 0;
    }

    private int discoverAllTrinkets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        DiscoveredTrinketsData data = DiscoveredTrinketsData.get(player.m_183503_());
        for (TrinketEffect<?> trinketEffect : TrinketEffectRegistry.getOrderedEntries()) {
            data.discoverTrinket(player.m_142081_(), trinketEffect);
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Discovered all trinkets"), false);
        return 0;
    }

    private int completeHerald(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        if (player.m_20194_() == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Player is not online or server is not available."));
            return 0;
        }
        PlayerGreedData data = PlayerGreedData.get(player.m_20194_());
        data.onHeraldCompleted((Player)player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Herald completed for player: " + player.m_7755_().getString()), false);
        return 1;
    }
}

