/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.EtchingItem;
import iskallia.vault.util.EntityHelper;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EtchingCommand
extends Command {
    @Override
    public String getName() {
        return "etching";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(this::suggestEtchingIds).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(this::giveEtching)));
    }

    private CompletableFuture<Suggestions> suggestEtchingIds(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List<String> ids = ModConfigs.ETCHINGS.getEtchingIds().stream().map(ResourceLocation::toString).toList();
        return SharedSuggestionProvider.m_82970_(ids, (SuggestionsBuilder)builder);
    }

    private int giveEtching(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ResourceLocation id = ResourceLocationArgument.m_107011_(context, (String)"type");
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        VaultEtchingConfig.EtchingEntry entry = ModConfigs.ETCHINGS.getEtchingConfig(id);
        if (entry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("No etching found for ID: " + String.valueOf(id)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<ItemStack> stack = EtchingItem.create(id, entry, player.m_21187_(), level);
        if (stack.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("No etching found for ID: " + String.valueOf(id)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        EntityHelper.giveItem((Player)player, stack.get());
        return 1;
    }
}

