/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.command.Command;
import iskallia.vault.config.AbilitiesConfig;
import iskallia.vault.config.UniqueGearConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.config.BooleanFlagGenerator;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.DoubleAttributeGenerator;
import iskallia.vault.gear.attribute.config.FloatAttributeGenerator;
import iskallia.vault.gear.attribute.config.IdentityObjectGenerator;
import iskallia.vault.gear.attribute.config.IntegerAttributeGenerator;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class GearDebugCommand
extends Command {
    private static final Random rand = new Random();

    @Override
    public String getName() {
        return "gear_debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"setLevel").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::setLevel)));
        builder.then(Commands.m_82127_((String)"give_unique_item").then(Commands.m_82129_((String)"uniqueName", (ArgumentType)StringArgumentType.string()).suggests(this::suggestUniqueItems).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).suggests(this::suggestPlayerLevel).executes(this::giveUniqueItemByName))));
        builder.then(Commands.m_82127_((String)"give_all_unique_items").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).suggests(this::suggestPlayerLevel).executes(this::giveAllUniqueItems)));
        builder.then(Commands.m_82127_((String)"addRandomModifier").executes(this::addRandomModifier));
        builder.then(Commands.m_82127_((String)"removeRandomModifier").executes(this::removeRandomModifier));
        builder.then(Commands.m_82127_((String)"rerollAll").executes(this::rerollAllModifiers));
        builder.then(Commands.m_82127_((String)"add_ability_modifier").then(Commands.m_82129_((String)"ability", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> {
            AbilitiesConfig config = ModConfigs.ABILITIES;
            return SharedSuggestionProvider.m_82970_(config.get().orElseThrow().skills.stream().flatMap(skill -> {
                if (skill instanceof SpecializedSkill) {
                    SpecializedSkill spec = (SpecializedSkill)skill;
                    return Stream.concat(Stream.of(spec.getId()), spec.getChildren().map(Skill::getId));
                }
                return Stream.of(skill.getId());
            }).toList(), (SuggestionsBuilder)suggestionsBuilder);
        }).then(Commands.m_82129_((String)"levelChange", (ArgumentType)IntegerArgumentType.integer()).executes(this::addAbilityLevel))));
        builder.then(Commands.m_82127_((String)"set_corrupted").executes(this::corruptGear));
        builder.then(Commands.m_82127_((String)"set_not_corrupted").executes(this::uncorruptGear));
        builder.then(Commands.m_82127_((String)"set_legendary").executes(this::setGearLegendary));
        builder.then(Commands.m_82127_((String)"give_all_trinkets").executes(this::testGiveAllTrinkets));
        LiteralArgumentBuilder repairsCommand = Commands.m_82127_((String)"repairs");
        repairsCommand.then(Commands.m_82127_((String)"fix").executes(ctx -> this.modifyRepairs(((CommandSourceStack)ctx.getSource()).m_81375_(), false)));
        repairsCommand.then(Commands.m_82127_((String)"damage").executes(ctx -> this.modifyRepairs(((CommandSourceStack)ctx.getSource()).m_81375_(), true)));
        repairsCommand.then(Commands.m_82127_((String)"setSlots").then(Commands.m_82129_((String)"slots", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.setRepairSlots(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slots")))));
        builder.then((ArgumentBuilder)repairsCommand);
        builder.then(Commands.m_82127_((String)"rarity").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(this::suggestRarityValues).executes(this::setRarityAndRollType)));
        builder.then(Commands.m_82127_((String)"model").then(Commands.m_82129_((String)"model", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(this::suggestModels).executes(ctx -> this.setGearModel(((CommandSourceStack)ctx.getSource()).m_81375_(), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"model")))));
        builder.then(Commands.m_82127_((String)"potential").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> this.setCraftingPotential(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        builder.then(Commands.m_82127_((String)"addModifier").then(Commands.m_82129_((String)"affix", (ArgumentType)StringArgumentType.word()).suggests(this::suggestAffixTypes).then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(this::suggestAttributes).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggestAttributeValues).executes(this::addModifier)))));
        builder.then(Commands.m_82127_((String)"removeModifier").then(Commands.m_82129_((String)"affix", (ArgumentType)StringArgumentType.word()).suggests(this::suggestAffixTypes).then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(this::suggestExistingModifiers).executes(this::removeModifier))));
        builder.then(Commands.m_82127_((String)"rollType").then(Commands.m_82129_((String)"rollType", (ArgumentType)StringArgumentType.string()).executes(this::setRollType)));
        builder.then(Commands.m_82127_((String)"unpack").executes(this::unpackGearData));
        builder.then(Commands.m_82127_((String)"pack").executes(this::packGearData));
    }

    private int packGearData(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = player.m_21205_();
        if (gear.m_41619_() || !AttributeGearData.hasData(gear)) {
            player.m_6352_((Component)new TextComponent("No gear data found on item."), Util.f_137441_);
            return 0;
        }
        CompoundTag tag = gear.m_41784_().m_128469_("nbtGearData");
        ((AttributeGearData)AttributeGearData.fromNbt(gear, tag)).write(gear);
        gear.m_41784_().m_128473_("nbtGearData");
        return 0;
    }

    private int unpackGearData(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = player.m_21205_();
        if (gear.m_41619_() || !AttributeGearData.hasData(gear)) {
            player.m_6352_((Component)new TextComponent("No gear data found on item."), Util.f_137441_);
            return 0;
        }
        CompoundTag data = ((AttributeGearData)AttributeGearData.read(gear)).toNbt();
        gear.m_41784_().m_128365_("nbtGearData", (Tag)data);
        return 0;
    }

    private CompletableFuture<Suggestions> suggestModels(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        Set<ResourceLocation> discoveredModels = modelsData.getDiscoveredModels(player.m_142081_());
        Optional<DynamicModelRegistry<?>> registry = ModDynamicModels.REGISTRIES.getAssociatedRegistry(player.m_21205_().m_41720_());
        if (registry.isPresent()) {
            List models = registry.get().getIds().stream().filter(discoveredModels::contains).map(ResourceLocation::toString).collect(Collectors.toList());
            return SharedSuggestionProvider.m_82970_(models, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private CompletableFuture<Suggestions> suggestUniqueItems(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Set<ResourceLocation> uniqueIds = ModConfigs.UNIQUE_GEAR.getRegistry().keySet();
        List uniqueNames = uniqueIds.stream().map(ResourceLocation::m_135815_).sorted().collect(Collectors.toList());
        return SharedSuggestionProvider.m_82970_(uniqueNames, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestPlayerLevel(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return SharedSuggestionProvider.m_82981_(IntStream.rangeClosed(0, SidedHelper.getVaultLevel((Player)player)).mapToObj(String::valueOf), (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestRarityValues(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List<String> rarityValues = Arrays.asList("Scrappy", "Common", "Rare", "Epic", "Omega");
        return SharedSuggestionProvider.m_82970_(rarityValues, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestAffixTypes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List affixTypes = Arrays.stream(VaultGearModifier.AffixType.values()).map(Enum::name).collect(Collectors.toList());
        return SharedSuggestionProvider.m_82970_(affixTypes, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestAttributes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Optional<VaultGearTierConfig> config;
        VaultGearModifier.AffixType affixType;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String affixTypeStr = StringArgumentType.getString(context, (String)"affix");
        try {
            affixType = VaultGearModifier.AffixType.valueOf(affixTypeStr);
        }
        catch (IllegalArgumentException e) {
            return Suggestions.empty();
        }
        ItemStack held = player.m_21205_();
        if (held.m_41720_() instanceof VaultGearItem && (config = VaultGearTierConfig.getConfig(held)).isPresent()) {
            List attributeIds;
            VaultGearTierConfig.ModifierAffixTagGroup affixGroup = VaultGearTierConfig.ModifierAffixTagGroup.ofAffixType(affixType);
            VaultGearTierConfig.AttributeGroup attributeGroup = config.get().getModifierGroup(affixGroup);
            if (attributeGroup != null && !(attributeIds = attributeGroup.stream().map(group -> group.getAttribute().toString()).distinct().collect(Collectors.toList())).isEmpty()) {
                return SharedSuggestionProvider.m_82970_(attributeIds, (SuggestionsBuilder)builder);
            }
        }
        List allAttributes = VaultGearAttributeRegistry.getRegistry().getKeys().stream().map(ResourceLocation::toString).collect(Collectors.toList());
        return SharedSuggestionProvider.m_82970_(allAttributes, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestAttributeValues(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        try {
            ResourceLocation modifierRL = ResourceLocationArgument.m_107011_(context, (String)"modifier");
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(modifierRL);
            if (attribute != null) {
                ArrayList<String> suggestions = new ArrayList<String>();
                ConfigurableAttributeGenerator<?, ?> generator = attribute.getGenerator();
                if (generator instanceof BooleanFlagGenerator) {
                    suggestions.add("true");
                    suggestions.add("false");
                } else if (attribute == ModGearAttributes.EFFECT_IMMUNITY) {
                    ForgeRegistries.MOB_EFFECTS.getKeys().stream().map(ResourceLocation::toString).forEach(suggestions::add);
                } else if (attribute == ModGearAttributes.ABILITY_LEVEL) {
                    ModConfigs.ABILITIES.get().orElseThrow().skills.stream().flatMap(skill -> {
                        if (skill instanceof SpecializedSkill) {
                            SpecializedSkill spec = (SpecializedSkill)skill;
                            return Stream.concat(Stream.of(spec.getId()), spec.getChildren().map(Skill::getId));
                        }
                        return Stream.of(skill.getId());
                    }).forEach(suggestions::add);
                }
                return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Suggestions.empty();
    }

    private CompletableFuture<Suggestions> suggestExistingModifiers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        VaultGearData data;
        VaultGearModifier.AffixType affixType;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String affixTypeStr = StringArgumentType.getString(context, (String)"affix");
        try {
            affixType = VaultGearModifier.AffixType.valueOf(affixTypeStr);
        }
        catch (IllegalArgumentException e) {
            return Suggestions.empty();
        }
        ItemStack held = player.m_21205_();
        if (held.m_41720_() instanceof VaultGearItem && (data = VaultGearData.read(held)).getState() == VaultGearState.IDENTIFIED) {
            List existingModifiers = data.getModifiers(affixType).stream().map(modifier -> {
                if (modifier.getAttribute() != null && modifier.getAttribute().getRegistryName() != null) {
                    return modifier.getAttribute().getRegistryName().toString();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return SharedSuggestionProvider.m_82970_(existingModifiers, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private int giveUniqueItemByName(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String uniqueName = StringArgumentType.getString(ctx, (String)"uniqueName");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        ResourceLocation uniqueId = new ResourceLocation("the_vault", uniqueName);
        ResourceLocation poolId = this.findPoolForUniqueItem(uniqueId);
        if (poolId == null) {
            player.m_6352_((Component)new TextComponent("Unknown unique item: " + uniqueName).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        Optional<UniqueGearConfig.Entry> uniqueEntry = ModConfigs.UNIQUE_GEAR.getEntry(uniqueId);
        if (uniqueEntry.isEmpty()) {
            player.m_6352_((Component)new TextComponent("Unknown unique item: " + uniqueName).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        String gearRollType = "Unique";
        if (ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool(gearRollType).isEmpty()) {
            player.m_6352_((Component)new TextComponent("Could not determine appropriate gear roll type").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        ItemStack gearStack = this.determineItemStackForUnique(uniqueEntry.get());
        if (gearStack.m_41619_()) {
            player.m_6352_((Component)new TextComponent("Failed to create item for " + uniqueName).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(gearStack);
        data.setItemLevel(level);
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, gearRollType);
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_UNIQUE_POOL, poolId);
        data.write(gearStack);
        gearStack = LootInitialization.initializeVaultLoot(gearStack, level);
        player.m_150109_().m_36054_(gearStack);
        player.m_6352_((Component)new TextComponent("Gave " + uniqueEntry.get().getName() + " (Level " + level + ")").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 1;
    }

    private int giveAllUniqueItems(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        for (UniqueGearConfig.Entry uniqueEntry : ModConfigs.UNIQUE_GEAR.getRegistry().values()) {
            ResourceLocation uniqueId = uniqueEntry.getId();
            ResourceLocation poolId = this.findPoolForUniqueItem(uniqueId);
            if (poolId == null) {
                player.m_6352_((Component)new TextComponent("Unknown unique item: " + uniqueEntry.getName()).m_130940_(ChatFormatting.RED), Util.f_137441_);
                continue;
            }
            ItemStack gearStack = this.determineItemStackForUnique(uniqueEntry);
            if (gearStack.m_41619_()) {
                player.m_6352_((Component)new TextComponent("Failed to create item for " + uniqueEntry.getName()).m_130940_(ChatFormatting.RED), Util.f_137441_);
                continue;
            }
            VaultGearData data = VaultGearData.read(gearStack);
            data.setItemLevel(level);
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, "Unique");
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_UNIQUE_POOL, poolId);
            data.write(gearStack);
            gearStack = LootInitialization.initializeVaultLoot(gearStack, level);
            Item item = gearStack.m_41720_();
            if (item instanceof IdentifiableItem) {
                IdentifiableItem identifiableItem = (IdentifiableItem)item;
                if (!identifiableItem.canIdentify((Player)player, gearStack)) continue;
                VaultGearState state = identifiableItem.getState(gearStack);
                if (state == VaultGearState.UNIDENTIFIED) {
                    identifiableItem.instantIdentify((Player)player, gearStack);
                }
            }
            player.m_150109_().m_36054_(gearStack);
        }
        return 1;
    }

    private ResourceLocation findPoolForUniqueItem(ResourceLocation uniqueId) {
        ResourceLocation dedicatedPool;
        Map<ResourceLocation, WeightedList<ResourceLocation>> pools = ModConfigs.UNIQUE_GEAR.getPools();
        if (pools.containsKey(dedicatedPool = new ResourceLocation("the_vault", uniqueId.m_135815_()))) {
            return dedicatedPool;
        }
        for (Map.Entry<ResourceLocation, WeightedList<ResourceLocation>> entry : pools.entrySet()) {
            if (!entry.getValue().contains(uniqueId)) continue;
            return entry.getKey();
        }
        return UniqueGearConfig.DEFAULT_POOL;
    }

    private ItemStack determineItemStackForUnique(UniqueGearConfig.Entry uniqueEntry) {
        ResourceLocation model = uniqueEntry.getModel();
        if (model == null) {
            return new ItemStack((ItemLike)ModItems.JEWEL);
        }
        String modelPath = model.m_135815_();
        if (modelPath.contains("armor")) {
            if (modelPath.contains("helmet")) {
                return new ItemStack((ItemLike)ModItems.HELMET);
            }
            if (modelPath.contains("chestplate")) {
                return new ItemStack((ItemLike)ModItems.CHESTPLATE);
            }
            if (modelPath.contains("leggings")) {
                return new ItemStack((ItemLike)ModItems.LEGGINGS);
            }
            if (modelPath.contains("boots")) {
                return new ItemStack((ItemLike)ModItems.BOOTS);
            }
        } else {
            if (modelPath.contains("sword")) {
                return new ItemStack((ItemLike)ModItems.SWORD);
            }
            if (modelPath.contains("shield")) {
                return new ItemStack((ItemLike)ModItems.SHIELD);
            }
            if (modelPath.contains("wand")) {
                return new ItemStack((ItemLike)ModItems.WAND);
            }
            if (modelPath.contains("focus")) {
                return new ItemStack((ItemLike)ModItems.FOCUS);
            }
        }
        return new ItemStack((ItemLike)ModItems.SWORD);
    }

    private int modifyRepairs(ServerPlayer player, boolean breakItem) {
        ItemStack gear = this.getHeldGear(player);
        VaultGearData data = VaultGearData.read(gear);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            player.m_6352_((Component)new TextComponent("Only identified gear can be modified"), Util.f_137441_);
            return 0;
        }
        int usedRepairSlots = data.getUsedRepairSlots() + (breakItem ? 1 : -1);
        if (usedRepairSlots > data.getRepairSlots()) {
            player.m_6352_((Component)new TextComponent("Item is already at maximum used repair slots"), Util.f_137441_);
            return 0;
        }
        if (usedRepairSlots < 0) {
            player.m_6352_((Component)new TextComponent("Item is already at 0 used repair slots"), Util.f_137441_);
            return 0;
        }
        data.setUsedRepairSlots(usedRepairSlots);
        data.write(gear);
        if (breakItem) {
            player.m_6352_((Component)new TextComponent("Item repair slot usage increased"), Util.f_137441_);
        } else {
            player.m_6352_((Component)new TextComponent("Item repair slot usage decreased"), Util.f_137441_);
        }
        return 1;
    }

    private int setRepairSlots(ServerPlayer player, int slots) {
        ItemStack gear = this.getHeldGear(player);
        VaultGearData data = VaultGearData.read(gear);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            player.m_6352_((Component)new TextComponent("Only identified gear can be modified"), Util.f_137441_);
            return 0;
        }
        int oldSlots = data.getRepairSlots();
        data.setRepairSlots(slots);
        data.write(gear);
        player.m_6352_((Component)new TextComponent("Changed repair slots from " + oldSlots + " to " + slots), Util.f_137441_);
        return 1;
    }

    private int setRollType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        String rollType = StringArgumentType.getString(ctx, (String)"rollType");
        if (!ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPoolNames().contains(rollType)) {
            player.m_6352_((Component)new TextComponent("Unknown roll type " + rollType), Util.f_137441_);
            player.m_6352_((Component)new TextComponent("Known roll types: " + ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPoolNames().toString()), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(gear);
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, rollType);
        data.write(gear);
        return 0;
    }

    private int setRarityAndRollType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        String value = StringArgumentType.getString(ctx, (String)"value");
        VaultGearData data = VaultGearData.read(gear);
        VaultGearRarity rarity = null;
        if ("Scrappy".equals(value)) {
            rarity = VaultGearRarity.SCRAPPY;
        } else if ("Common".equals(value)) {
            rarity = VaultGearRarity.COMMON;
        } else if ("Rare".equals(value)) {
            rarity = VaultGearRarity.RARE;
        } else if ("Epic".equals(value)) {
            rarity = VaultGearRarity.EPIC;
        } else if ("Omega".equals(value)) {
            rarity = VaultGearRarity.OMEGA;
        }
        if (rarity != null) {
            VaultGearRarity oldRarity = data.getRarity();
            String oldRollType = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).orElse("Unknown");
            data.setRarity(rarity);
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, value);
            data.write(gear);
            player.m_6352_((Component)new TextComponent("Changed rarity from " + String.valueOf((Object)oldRarity) + " to " + String.valueOf((Object)rarity)), Util.f_137441_);
            return 1;
        }
        player.m_6352_((Component)new TextComponent("Unknown rarity: " + value).m_130940_(ChatFormatting.RED), Util.f_137441_);
        player.m_6352_((Component)new TextComponent("Valid rarities: Scrappy, Common, Rare, Epic, Omega"), Util.f_137441_);
        return 0;
    }

    private int setGearModel(ServerPlayer player, ResourceLocation model) {
        ItemStack gear = this.getHeldGear(player);
        VaultGearData data = VaultGearData.read(gear);
        if (FMLEnvironment.production && !ModConfigs.GEAR_MODEL_ROLL_RARITIES.canAppearNormally(gear, model)) {
            return 0;
        }
        if (data.getState() != VaultGearState.IDENTIFIED) {
            player.m_6352_((Component)new TextComponent("Only identified gear can be modified"), Util.f_137441_);
            return 0;
        }
        boolean hasRewards = ModDynamicModels.REGISTRIES.getModelByResourceLocation(model).map(m -> m.getModelProperties().doesRequireRewards()).orElse(false);
        if (hasRewards) {
            player.m_6352_((Component)new TextComponent("Cannot change model for identified gear with rewards"), Util.f_137441_);
            return 0;
        }
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, model);
        data.write(gear);
        player.m_6352_((Component)new TextComponent("Updated gear model to " + String.valueOf(model)), Util.f_137441_);
        return 1;
    }

    private int setCraftingPotential(ServerPlayer player, int potential) {
        ItemStack gear = this.getHeldGear(player);
        VaultGearData data = VaultGearData.read(gear);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            player.m_6352_((Component)new TextComponent("Only identified gear can be modified"), Util.f_137441_);
            return 0;
        }
        int oldPotential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(0);
        data.createOrReplaceAttributeValue(ModGearAttributes.CRAFTING_POTENTIAL, potential);
        data.write(gear);
        player.m_6352_((Component)new TextComponent("Changed crafting potential from " + oldPotential + " to " + potential), Util.f_137441_);
        return 1;
    }

    private int testGiveAllTrinkets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        for (TrinketEffect<?> trinket : TrinketEffectRegistry.getOrderedEntries()) {
            EntityHelper.giveItem((Player)player, TrinketItem.createRandomTrinket(trinket));
        }
        return 0;
    }

    private int setGearLegendary(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("Not holding VaultGear item"), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(held);
        if (!data.isModifiable()) {
            player.m_6352_((Component)new TextComponent("Item is corrupted"), Util.f_137441_);
            return 0;
        }
        data.createOrReplaceAttributeValue(ModGearAttributes.IS_LEGENDARY, true);
        data.write(held);
        return 0;
    }

    private int corruptGear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("Not holding VaultGear item"), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(held);
        if (!data.isModifiable()) {
            player.m_6352_((Component)new TextComponent("Item already corrupted"), Util.f_137441_);
            return 0;
        }
        VaultGearModifierHelper.setGearCorrupted(held);
        return 0;
    }

    private int uncorruptGear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("Not holding VaultGear item"), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(held);
        if (data.isModifiable()) {
            player.m_6352_((Component)new TextComponent("Item is not corrupted"), Util.f_137441_);
            return 0;
        }
        data.removeAttribute(ModGearAttributes.IS_CORRUPTED);
        data.write(held);
        return 0;
    }

    private int addAbilityLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Skill ability;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("Not holding VaultGear item"), Util.f_137441_);
            return 0;
        }
        String abilityKey = StringArgumentType.getString(context, (String)"ability");
        if (!abilityKey.equals("all_abilities") && (ability = (Skill)ModConfigs.ABILITIES.getAbilityById(abilityKey).orElse(null)) == null) {
            player.m_6352_((Component)new TextComponent("Unknown ability: " + abilityKey), Util.f_137441_);
            return 0;
        }
        int levelChange = IntegerArgumentType.getInteger(context, (String)"levelChange");
        VaultGearData data = VaultGearData.read(held);
        data.addModifier(VaultGearModifier.AffixType.PREFIX, new VaultGearModifier<AbilityLevelAttribute>(ModGearAttributes.ABILITY_LEVEL, new AbilityLevelAttribute(abilityKey, levelChange)));
        data.write(held);
        return 0;
    }

    private int rerollAllModifiers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        VaultGearModifierHelper.reForgeAllModifiers(gear, rand);
        return 0;
    }

    private int addRandomModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        long gameTime = player.m_20193_().m_46467_();
        ItemStack gear = this.getHeldGear(player);
        if (!VaultGearModifierHelper.addNewModifier(gear, gameTime, rand).success()) {
            player.m_6352_((Component)new TextComponent("No empty modifier slots remaining."), Util.f_137441_);
        }
        return 0;
    }

    private int removeRandomModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        if (!VaultGearModifierHelper.removeRandomModifier(gear, rand).success()) {
            player.m_6352_((Component)new TextComponent("No modifiers remaining to remove."), Util.f_137441_);
        }
        return 0;
    }

    private int addModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultGearModifier.AffixType affixType;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        String affixTypeStr = StringArgumentType.getString(ctx, (String)"affix");
        try {
            affixType = VaultGearModifier.AffixType.valueOf(affixTypeStr);
        }
        catch (IllegalArgumentException e) {
            player.m_6352_((Component)new TextComponent("Invalid affix type: " + affixTypeStr).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        ResourceLocation modifierRL = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(modifierRL);
        if (attribute == null) {
            player.m_6352_((Component)new TextComponent("Unknown attribute: " + String.valueOf(modifierRL)).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(gear);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            player.m_6352_((Component)new TextComponent("Only identified gear can be modified"), Util.f_137441_);
            return 0;
        }
        String valueStr = StringArgumentType.getString(ctx, (String)"value");
        boolean success = false;
        try {
            success = this.addModifierByType(data, affixType, attribute, valueStr);
            if (success) {
                data.write(gear);
                player.m_6352_((Component)new TextComponent("Added " + String.valueOf((Object)affixType) + " modifier: " + String.valueOf(modifierRL)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            } else {
                player.m_6352_((Component)new TextComponent("Failed to add modifier: " + String.valueOf(modifierRL)).m_130940_(ChatFormatting.RED), Util.f_137441_);
            }
        }
        catch (Exception e) {
            player.m_6352_((Component)new TextComponent("Error adding modifier: " + e.getMessage()).m_130940_(ChatFormatting.RED), Util.f_137441_);
            e.printStackTrace();
        }
        return success ? 1 : 0;
    }

    private int removeModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultGearModifier.AffixType affixType;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        String affixTypeStr = StringArgumentType.getString(ctx, (String)"affix");
        try {
            affixType = VaultGearModifier.AffixType.valueOf(affixTypeStr);
        }
        catch (IllegalArgumentException e) {
            player.m_6352_((Component)new TextComponent("Invalid affix type: " + affixTypeStr).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        ResourceLocation modifierRL = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        VaultGearData data = VaultGearData.read(gear);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            player.m_6352_((Component)new TextComponent("Only identified gear can be modified"), Util.f_137441_);
            return 0;
        }
        List<VaultGearModifier> matchingModifiers = data.getModifiers(affixType).stream().filter(modifier -> modifier.getAttribute() != null && modifier.getAttribute().getRegistryName() != null && modifier.getAttribute().getRegistryName().equals((Object)modifierRL)).toList();
        if (matchingModifiers.isEmpty()) {
            player.m_6352_((Component)new TextComponent("No matching modifiers found for: " + String.valueOf(modifierRL)), Util.f_137441_);
            return 0;
        }
        VaultGearModifier modifierToRemove = matchingModifiers.get(0);
        boolean removed = data.removeModifier(modifierToRemove);
        if (removed) {
            data.write(gear);
            player.m_6352_((Component)new TextComponent("Removed " + String.valueOf((Object)affixType) + " modifier: " + String.valueOf(modifierRL)).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            return 1;
        }
        player.m_6352_((Component)new TextComponent("Failed to remove modifier: " + String.valueOf(modifierRL)).m_130940_(ChatFormatting.RED), Util.f_137441_);
        return 0;
    }

    private int setLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack gear = this.getHeldGear(player);
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        VaultGearData data = VaultGearData.read(gear);
        data.setItemLevel(level);
        data.write(gear);
        return 0;
    }

    private ItemStack getHeldGear(ServerPlayer player) {
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("No vaultgear held in hand"), Util.f_137441_);
            throw new IllegalArgumentException("Not vaultgear in hand");
        }
        return held;
    }

    private boolean addModifierByType(VaultGearData data, VaultGearModifier.AffixType affixType, VaultGearAttribute<?> attribute, String valueStr) {
        block11: {
            try {
                if (attribute.getGenerator() instanceof FloatAttributeGenerator) {
                    float value = Float.parseFloat(valueStr);
                    VaultGearModifier<Float> modifier = new VaultGearModifier<Float>(attribute, Float.valueOf(value));
                    GearDebugCommand.prepareModifier(modifier);
                    return data.addModifier(affixType, modifier);
                }
                if (attribute.getGenerator() instanceof IntegerAttributeGenerator) {
                    int value = Integer.parseInt(valueStr);
                    VaultGearModifier<Integer> modifier = new VaultGearModifier<Integer>(attribute, value);
                    GearDebugCommand.prepareModifier(modifier);
                    return data.addModifier(affixType, modifier);
                }
                if (attribute.getGenerator() instanceof DoubleAttributeGenerator) {
                    double value = Double.parseDouble(valueStr);
                    VaultGearModifier<Double> modifier = new VaultGearModifier<Double>(attribute, value);
                    GearDebugCommand.prepareModifier(modifier);
                    return data.addModifier(affixType, modifier);
                }
                if (attribute.getGenerator() instanceof BooleanFlagGenerator) {
                    boolean value = Boolean.parseBoolean(valueStr);
                    VaultGearModifier<Boolean> modifier = new VaultGearModifier<Boolean>(attribute, value);
                    GearDebugCommand.prepareModifier(modifier);
                    return data.addModifier(affixType, modifier);
                }
                if (attribute == ModGearAttributes.EFFECT_IMMUNITY) {
                    try {
                        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(valueStr));
                        if (effect != null) {
                            VaultGearModifier<MobEffect> modifier = new VaultGearModifier<MobEffect>(attribute, effect);
                            return data.addModifier(affixType, modifier);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (attribute.getGenerator() instanceof IdentityObjectGenerator) {
                    VaultGearModifier<String> modifier = new VaultGearModifier<String>(attribute, valueStr);
                    GearDebugCommand.prepareModifier(modifier);
                    return data.addModifier(affixType, modifier);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        VaultMod.LOGGER.error("Failed to add modifier of type: " + String.valueOf(attribute.getRegistryName()));
        return false;
    }

    private static <T> void prepareModifier(VaultGearModifier<T> modifier) {
        if (modifier.getModifierIdentifier() == null && modifier.getAttribute().getRegistryName() != null) {
            modifier.setModifierIdentifier(modifier.getAttribute().getRegistryName());
        }
        if (modifier.getRolledTier() < 0) {
            modifier.setRolledTier(0);
        }
        if (modifier.getModifierGroup() == null) {
            modifier.setModifierGroup("");
        }
    }
}

