/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.block.item.FinalVaultFrameBlockItem;
import iskallia.vault.block.item.LootStatueBlockItem;
import iskallia.vault.block.item.TrophyStatueBlockItem;
import iskallia.vault.command.Command;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.CrateLootGenerator;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CompanionEggItem;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionRelicItem;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.item.SoulFlameItem;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.item.crystal.modifiers.DefaultCrystalModifiers;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.WeekKey;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.command.EnumArgument;

public class GiveLootCommand
extends Command {
    @Override
    public String getName() {
        return "give_loot";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"loot_statue").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveLootStatue(StringArgumentType.getString((CommandContext)ctx, (String)"name"), (CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))));
        builder.then(Commands.m_82127_((String)"paxel").then(Commands.m_82129_((String)"enhancementId", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.givePaxel((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"enhancementId")))));
        builder.then(Commands.m_82127_((String)"set_gear_name").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::setGearName)));
        builder.then(Commands.m_82127_((String)"record_trophy").then(Commands.m_82129_((String)"year", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"week", (ArgumentType)IntegerArgumentType.integer()).executes(this::giveTrophy))));
        builder.then(Commands.m_82127_((String)"record_box").executes(this::giveTrophyBox));
        builder.then(Commands.m_82127_((String)"final_vault_frame").then(Commands.m_82129_((String)"ownerUUID", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"ownerNickname", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveFinalVaultFrame((CommandContext<CommandSourceStack>)ctx, UuidArgument.m_113853_((CommandContext)ctx, (String)"ownerUUID"), StringArgumentType.getString((CommandContext)ctx, (String)"ownerNickname"))))));
        builder.then(Commands.m_82127_((String)"vault_doll").then(Commands.m_82129_((String)"playerIGN", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveVaultDoll((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"playerIGN")))));
        builder.then(Commands.m_82127_((String)"crate").then(Commands.m_82129_((String)"crateType", (ArgumentType)EnumArgument.enumArgument(VaultCrateBlock.Type.class)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"itemQuantity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer player;
            try {
                player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            }
            catch (CommandSyntaxException | IllegalArgumentException exception) {
                player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            }
            return this.giveCrate((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"itemQuantity"), player);
        }))).executes(ctx -> this.giveCrate((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"itemQuantity"))))).executes(this::giveCrate))));
        builder.then(Commands.m_82127_((String)"flame_rock").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"stacks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::giveEmberRock))));
        builder.then(Commands.m_82127_((String)"companion_egg").then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"series", (ArgumentType)EnumArgument.enumArgument(CompanionSeries.class)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            int time = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time");
            CompanionSeries series = (CompanionSeries)((Object)((Object)ctx.getArgument("series", CompanionSeries.class)));
            return this.giveCompanionEgg((CommandContext<CommandSourceStack>)ctx, player, time, series);
        }))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int time = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time");
            CompanionSeries series = (CompanionSeries)((Object)((Object)ctx.getArgument("series", CompanionSeries.class)));
            return this.giveCompanionEgg((CommandContext<CommandSourceStack>)ctx, player, time, series);
        }))));
        builder.then(Commands.m_82127_((String)"tool").then(Commands.m_82129_((String)"prebuiltId", (ArgumentType)StringArgumentType.string()).suggests((ctx, sBuilder) -> SharedSuggestionProvider.m_82970_(ModConfigs.PRE_BUILT_TOOLS.getKeys(), (SuggestionsBuilder)sBuilder)).executes(this::giveTool)));
        builder.then(Commands.m_82127_((String)"trail").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::giveCompanionTrail)));
        builder.then(Commands.m_82127_((String)"companion_relic").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::giveCompanionRelic)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::giveCompanionRelic))));
    }

    private int giveCrate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.giveCrate(ctx, 0.0f);
    }

    private int giveCompanionTrail(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        ItemStack stack = CompanionParticleTrailItem.createRandom();
        EntityHelper.giveItem((Player)target, stack);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("OK"), false);
        return 1;
    }

    private int giveEmberRock(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        int stacks = IntegerArgumentType.getInteger(ctx, (String)"stacks");
        ItemStack rock = SoulFlameItem.create(stacks, target.m_7755_().getString(), target.m_142081_(), new DefaultCrystalModifiers());
        EntityHelper.giveItem((Player)target, rock);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("OK"), false);
        return 1;
    }

    private int giveCompanionEgg(CommandContext<CommandSourceStack> context, ServerPlayer player, int time, CompanionSeries series) {
        ItemStack egg = new ItemStack((ItemLike)ModItems.COMPANION_EGG);
        CompanionEggItem.setRemainingTime(egg, time);
        CompanionEggItem.setSeries(egg, series);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)egg);
        return 0;
    }

    private int giveCrate(CommandContext<CommandSourceStack> ctx, float itemQuantity) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return this.giveCrate(ctx, itemQuantity, player);
    }

    private int giveCrate(CommandContext<CommandSourceStack> ctx, float itemQuantity, ServerPlayer player) throws CommandSyntaxException {
        VaultCrateBlock.Type type = (VaultCrateBlock.Type)((Object)ctx.getArgument("crateType", VaultCrateBlock.Type.class));
        ItemStack crate = ItemStack.f_41583_;
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        switch (type) {
            case BOUNTY: {
                crate = ModConfigs.REWARD_CONFIG.generateReward(level, "common").createRewardCrate();
                break;
            }
            default: {
                AwardCrateObjective objective = AwardCrateObjective.ofConfig(type, type.toString().toLowerCase(), level, true);
                CrateLootGenerator crateLootGenerator = new CrateLootGenerator(objective.get(AwardCrateObjective.LOOT_TABLE), itemQuantity, ItemStackList.create(), objective.has(AwardCrateObjective.ADD_ARTIFACT), objective.get(AwardCrateObjective.ARTIFACT_CHANCE).floatValue());
                NonNullList<ItemStack> loot = crateLootGenerator.createLootForCommand(JavaRandom.ofInternal(new Random().nextLong()), level);
                crate = VaultCrateBlock.getCrateWithLoot(type, loot);
            }
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)crate);
        return 0;
    }

    private int setGearName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldItem = sPlayer.m_21205_();
        if (heldItem.m_41619_()) {
            return 0;
        }
        return 0;
    }

    public int giveTrophyBox(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel sWorld = sPlayer.m_183503_();
        LootContext.Builder builder = new LootContext.Builder(sWorld).m_78977_(sWorld.f_46441_).m_78963_(sPlayer.m_36336_());
        int playerLevel = PlayerVaultStatsData.get(sWorld).getVaultStats(sPlayer.m_142081_()).getVaultLevel();
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(playerLevel);
        LootTable bossBonusTbl = sPlayer.m_20194_().m_129898_().m_79217_(config.getScavengerCrate());
        NonNullList quickBossLoot = NonNullList.m_122779_();
        quickBossLoot.addAll((Collection)bossBonusTbl.m_79129_(builder.m_78975_(LootContextParamSets.f_81410_)));
        Collections.shuffle(quickBossLoot);
        ItemStack box = new ItemStack((ItemLike)Items.f_42266_);
        box.m_41784_().m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        ContainerHelper.m_18973_((CompoundTag)box.m_41784_().m_128469_("BlockEntityTag"), (NonNullList)quickBossLoot);
        sPlayer.m_36356_(box);
        sPlayer.m_6352_((Component)new TextComponent("Generated Recordbox for Vault level " + playerLevel), Util.f_137441_);
        return 0;
    }

    public int giveTrophy(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        int year = IntegerArgumentType.getInteger(context, (String)"year");
        int week = IntegerArgumentType.getInteger(context, (String)"week");
        ItemStack statue = TrophyStatueBlockItem.getTrophy(sPlayer.m_183503_(), WeekKey.of(year, week));
        if (!statue.m_41619_()) {
            sPlayer.m_36356_(statue);
        } else {
            sPlayer.m_6352_((Component)new TextComponent("No record set!"), Util.f_137441_);
        }
        return 0;
    }

    private int giveLootStatue(String name, CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ItemStack statue = LootStatueBlockItem.getStatueBlockItem(name);
        player.m_36356_(statue);
        return 0;
    }

    public int givePaxel(CommandContext<CommandSourceStack> context, ServerPlayer player, String enhancementSId) {
        ItemStack paxelStack = new ItemStack((ItemLike)ModItems.VAULTERITE_PICKAXE);
        EntityHelper.giveItem((Player)player, paxelStack);
        return 0;
    }

    public int giveFinalVaultFrame(CommandContext<CommandSourceStack> context, UUID ownerUUID, String ownerNickname) throws CommandSyntaxException {
        ItemStack frameStack = new ItemStack((ItemLike)ModBlocks.FINAL_VAULT_FRAME_BLOCK_ITEM);
        FinalVaultFrameBlockItem.writeToItemStack(frameStack, ownerUUID, ownerNickname);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        EntityHelper.giveItem((Player)player, frameStack);
        return 0;
    }

    private int giveVaultDoll(CommandContext<CommandSourceStack> context, String playerIGN) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack dollStack = new ItemStack((ItemLike)ModItems.VAULT_DOLL);
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        serverLevel.m_142572_().m_129927_().m_10996_(playerIGN).ifPresentOrElse(gp -> {
            VaultDollItem.setNewDollAttributes(dollStack, gp, (Level)((CommandSourceStack)context.getSource()).m_81372_());
            EntityHelper.giveItem((Player)serverPlayer, dollStack);
        }, () -> serverPlayer.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerIGN).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 0;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private int giveTool(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String prebuiltId = StringArgumentType.getString(context, (String)"prebuiltId");
        if (!ModConfigs.PRE_BUILT_TOOLS.hasId(prebuiltId)) {
            player.m_6352_((Component)new TextComponent("Unknown prebuilt tool ID: " + prebuiltId).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 1;
        }
        ItemStack toolStack = new ItemStack((ItemLike)ModItems.TOOL);
        ModConfigs.PRE_BUILT_TOOLS.apply(prebuiltId, toolStack);
        EntityHelper.giveItem((Player)player, toolStack);
        player.m_6352_((Component)new TextComponent("Given tool: " + prebuiltId), Util.f_137441_);
        return 0;
    }

    private int giveCompanionRelic(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = context.getInput().contains("player") && EntityArgument.m_91474_(context, (String)"player") != null ? EntityArgument.m_91474_(context, (String)"player") : ((CommandSourceStack)context.getSource()).m_81375_();
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        ModConfigs.COMPANION_RELICS.getRandom(level, JavaRandom.ofNanoTime()).ifPresent(entry -> {
            ItemStack stack = CompanionRelicItem.create(entry.getModifiers(), entry.getModel().get(JavaRandom.ofNanoTime()));
            EntityHelper.giveItem((Player)player, stack);
        });
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Given companion relic to " + player.m_7755_().getString()), false);
        return 1;
    }
}

