/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.type.Research;
import iskallia.vault.world.data.PlayerBlackMarketData;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class InternalCommand
extends Command {
    @Override
    public String getName() {
        return "internal";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"reset_black_market").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetBlackMarket)));
        builder.then(Commands.m_82127_((String)"reset_black_markets").executes(this::resetBlackMarkets));
        builder.then(Commands.m_82127_((String)"remove_research").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"research", (ArgumentType)StringArgumentType.string()).executes(this::unlearnResearch))));
    }

    private int unlearnResearch(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        Research research = ModConfigs.RESEARCHES.getByName(StringArgumentType.getString(ctx, (String)"research"));
        if (research == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Unknown research"));
            return 0;
        }
        PlayerResearchesData.get(target.m_183503_()).removeResearch(target, research);
        return 0;
    }

    private int resetBlackMarket(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        PlayerBlackMarketData.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getBlackMarket((Player)target).resetTrades(target.m_142081_());
        return 0;
    }

    private int resetBlackMarkets(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        PlayerBlackMarketData.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPlayerMap().forEach((uuid, blackMarket) -> blackMarket.resetTrades((UUID)uuid));
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

