/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.command.Command;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.DiscoveryGoalStatesData;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ModelDebugCommand
extends Command {
    @Override
    public String getName() {
        return "model_debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"discover_all").executes(this::discoverAll));
        builder.then(Commands.m_82127_((String)"undiscover_all").executes(this::undiscoverAll));
        builder.then(Commands.m_82127_((String)"discover").then(Commands.m_82129_((String)"model", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(this::suggestModels).executes(this::discoverModel)));
        ModDynamicModels.Armor.MODEL_REGISTRY.forEach((setId, armorModel) -> {
            builder.then(Commands.m_82127_((String)"all_armor_pieces").then(Commands.m_82127_((String)setId.toString()).executes(ctx -> this.giveAllPieces((CommandContext<CommandSourceStack>)ctx, (ArmorModel)armorModel))));
            armorModel.getPiece(EquipmentSlot.HEAD).ifPresent(piece -> builder.then(Commands.m_82127_((String)"helmet").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.HELMET, piece.getId())))));
            armorModel.getPiece(EquipmentSlot.CHEST).ifPresent(piece -> builder.then(Commands.m_82127_((String)"chestplate").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.CHESTPLATE, piece.getId())))));
            armorModel.getPiece(EquipmentSlot.LEGS).ifPresent(piece -> builder.then(Commands.m_82127_((String)"leggings").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.LEGGINGS, piece.getId())))));
            armorModel.getPiece(EquipmentSlot.FEET).ifPresent(piece -> builder.then(Commands.m_82127_((String)"boots").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.BOOTS, piece.getId())))));
        });
        ModDynamicModels.Swords.REGISTRY.forEach((setId, armorModel) -> builder.then(Commands.m_82127_((String)"sword").then(Commands.m_82127_((String)armorModel.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.SWORD, armorModel.getId())))));
        ModDynamicModels.Axes.REGISTRY.forEach((setId, armorModel) -> builder.then(Commands.m_82127_((String)"axe").then(Commands.m_82127_((String)armorModel.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.AXE, armorModel.getId())))));
        ModDynamicModels.Focus.REGISTRY.forEach((setId, armorModel) -> builder.then(Commands.m_82127_((String)"focus").then(Commands.m_82127_((String)armorModel.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, ModItems.FOCUS, armorModel.getId())))));
        ModDynamicModels.Shields.REGISTRY.forEach((setId, armorModel) -> builder.then(Commands.m_82127_((String)"shield").then(Commands.m_82127_((String)armorModel.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.SHIELD, armorModel.getId())))));
        ModDynamicModels.Wands.REGISTRY.forEach((setId, armorModel) -> builder.then(Commands.m_82127_((String)"wands").then(Commands.m_82127_((String)armorModel.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, ModItems.WAND, armorModel.getId())))));
        ModDynamicModels.Magnets.REGISTRY.forEach((setId, magnetModel) -> builder.then(Commands.m_82127_((String)"magnet").then(Commands.m_82127_((String)magnetModel.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, ModItems.MAGNET, magnetModel.getId())))));
        builder.then(Commands.m_82127_((String)"all_magnets").executes(ctx -> {
            ModDynamicModels.Magnets.REGISTRY.forEach((setId, magnetModel) -> this.givePiece((CommandContext<CommandSourceStack>)ctx, ModItems.MAGNET, magnetModel.getId()));
            return 0;
        }));
    }

    private int discoverAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        ModDynamicModels.REGISTRIES.getUniqueRegistries().forEach(registry -> registry.forEach((modelId, model) -> modelsData.discoverModel(player.m_142081_(), (ResourceLocation)modelId)));
        return 0;
    }

    private int undiscoverAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        modelsData.reset(player.m_142081_());
        modelsData.m_77762_();
        DiscoveryGoalStatesData goalStatesData = DiscoveryGoalStatesData.get(player.m_183503_());
        goalStatesData.getState(player).deleteCompletions();
        goalStatesData.m_77762_();
        return 0;
    }

    private int giveAllPieces(CommandContext<CommandSourceStack> context, ArmorModel armorModel) throws CommandSyntaxException {
        armorModel.getPiece(EquipmentSlot.HEAD).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.HELMET, armorModelPiece.getId()));
        armorModel.getPiece(EquipmentSlot.CHEST).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.CHESTPLATE, armorModelPiece.getId()));
        armorModel.getPiece(EquipmentSlot.LEGS).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.LEGGINGS, armorModelPiece.getId()));
        armorModel.getPiece(EquipmentSlot.FEET).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.BOOTS, armorModelPiece.getId()));
        return 0;
    }

    private int discoverModel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ResourceLocation modelId = ResourceLocationArgument.m_107011_(context, (String)"model");
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        ModDynamicModels.REGISTRIES.getModelAndAssociatedItem(modelId).ifPresentOrElse(pair -> modelsData.discoverModelAndBroadcast((Item)pair.getSecond(), ((DynamicModel)pair.getFirst()).getId(), (Player)player), () -> VaultMod.LOGGER.info("Model {} not found for discover command", (Object)modelId));
        return 0;
    }

    private CompletableFuture<Suggestions> suggestModels(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_((Iterable)ModDynamicModels.REGISTRIES.getUniqueRegistries().stream().flatMap(reg -> reg.getIds().stream()).map(ResourceLocation::toString).sorted().collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    private int giveAllSwordPieces(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ModDynamicModels.Swords.REGISTRY.forEach((setId, armorModel) -> this.givePiece(context, (Item)ModItems.SWORD, armorModel.getId()));
        return 0;
    }

    private int givePiece(CommandContext<CommandSourceStack> context, Item gear, ResourceLocation modelId) {
        try {
            ItemStack helmetStack = new ItemStack((ItemLike)gear);
            if (FMLEnvironment.production && !ModConfigs.GEAR_MODEL_ROLL_RARITIES.canAppearNormally(helmetStack, modelId)) {
                return 0;
            }
            this.configureGear(helmetStack, modelId, VaultGearRarity.COMMON);
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            EntityHelper.giveItem((Player)player, helmetStack);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        return 0;
    }

    private void configureGear(ItemStack gearStack, ResourceLocation modelId, VaultGearRarity rarity) {
        VaultGearData gearData = VaultGearData.read(gearStack);
        gearData.setState(VaultGearState.IDENTIFIED);
        gearData.setRarity(rarity);
        gearData.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, modelId);
        gearData.createOrReplaceAttributeValue(ModGearAttributes.GEAR_COLOR, -1);
        gearData.write(gearStack);
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

