/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.OpenVaultSnapshotMessage;
import iskallia.vault.world.data.VaultSnapshots;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class OpenVaultSnapshotCommand
extends Command {
    @Override
    public String getName() {
        return "open_snapshot";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"timestamp", (ArgumentType)LongArgumentType.longArg()).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(this::open)))).then(Commands.m_82129_((String)"target", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"asPlayer", (ArgumentType)UuidArgument.m_113850_()).executes(this::openLegacy))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"send").then(Commands.m_82129_((String)"timestamp", (ArgumentType)LongArgumentType.longArg()).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(this::send)))).then(Commands.m_82129_((String)"target", (ArgumentType)UuidArgument.m_113850_()).executes(this::sendLegacy)));
        builder.then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(this::list)));
    }

    private int open(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer viewer = ((CommandSourceStack)ctx.getSource()).m_81375_();
        long timestamp = LongArgumentType.getLong(ctx, (String)"timestamp");
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        UUID asPlayer = srv.m_129927_().m_10996_(playerName).map(profile -> profile.getId()).orElse(null);
        if (asPlayer == null) {
            viewer.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerName).m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        VaultSnapshot snapshot = VaultSnapshots.getAll().stream().filter(s -> s.getTimestamp() == timestamp && s.getEnd() != null).findFirst().orElse(null);
        if (snapshot != null && snapshot.getEnd().get(Vault.STATS).getMap().containsKey(asPlayer)) {
            ModNetwork.CHANNEL.sendTo((Object)new OpenVaultSnapshotMessage.S2C(snapshot, asPlayer), viewer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        return 0;
    }

    private int openLegacy(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID target = UuidArgument.m_113853_(ctx, (String)"target");
        UUID asPlayer = UuidArgument.m_113853_(ctx, (String)"asPlayer");
        VaultSnapshot snapshot = VaultSnapshots.get(target);
        if (snapshot != null) {
            ModNetwork.CHANNEL.sendTo((Object)new OpenVaultSnapshotMessage.S2C(snapshot, asPlayer), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        return 0;
    }

    private int send(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        long timestamp = LongArgumentType.getLong(ctx, (String)"timestamp");
        String targetPlayer = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        OpenVaultSnapshotCommand.sendCommand(player, timestamp, targetPlayer, srv);
        return 0;
    }

    private int sendLegacy(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID target = UuidArgument.m_113853_(ctx, (String)"target");
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        OpenVaultSnapshotCommand.sendLegacyCommand(player, target, srv);
        return 0;
    }

    public static void sendCommand(ServerPlayer player, long timestamp, String targetPlayer, MinecraftServer srv) {
        String openSnapshot = "/the_vault open_snapshot open " + timestamp + " " + targetPlayer;
        String snapshotName = "Vault";
        MutableComponent acceptTxt = new TextComponent(snapshotName).m_130940_(ChatFormatting.AQUA);
        acceptTxt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to open"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, openSnapshot)));
        MutableComponent acceptMessage = new TextComponent("").m_7220_((Component)new TextComponent("[").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)acceptTxt).m_7220_((Component)new TextComponent("]").m_130940_(ChatFormatting.GREEN));
        srv.m_6846_().m_11264_((Component)new TranslatableComponent("chat.type.text", new Object[]{player.m_5446_(), acceptMessage}), ChatType.CHAT, Util.f_137441_);
    }

    public static void sendLegacyCommand(ServerPlayer player, UUID target, MinecraftServer srv) {
        String openSnapshot = "/the_vault open_snapshot open " + String.valueOf(target) + " " + String.valueOf(player.m_142081_());
        String snapshotName = "Vault";
        MutableComponent acceptTxt = new TextComponent(snapshotName).m_130940_(ChatFormatting.AQUA);
        acceptTxt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to open"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, openSnapshot)));
        MutableComponent acceptMessage = new TextComponent("").m_7220_((Component)new TextComponent("[").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)acceptTxt).m_7220_((Component)new TextComponent("]").m_130940_(ChatFormatting.GREEN));
        srv.m_6846_().m_11264_((Component)new TranslatableComponent("chat.type.text", new Object[]{player.m_5446_(), acceptMessage}), ChatType.CHAT, Util.f_137441_);
    }

    private int list(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer viewer = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        srv.m_129927_().m_10996_(playerName).ifPresentOrElse(profile -> {
            UUID playerId = profile.getId();
            List<VaultSnapshot> snapshots = VaultSnapshots.getAll().stream().filter(s -> s.getEnd() != null && s.getTimestamp() != 0L && s.getEnd().get(Vault.STATS).getMap().containsKey(playerId)).sorted(Comparator.comparingLong(VaultSnapshot::getTimestamp).reversed()).toList();
            if (snapshots.isEmpty()) {
                viewer.m_6352_((Component)new TextComponent("No snapshots for " + playerName).m_130940_(ChatFormatting.RED), Util.f_137441_);
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            snapshots.forEach(snap -> {
                long ts = snap.getTimestamp();
                String command = "/the_vault open_snapshot open " + ts + " " + playerName;
                MutableComponent msg = new TextComponent(dateFormat.format(new Date(ts * 1000L)) + " (" + ts + ")").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to open"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)));
                viewer.m_6352_((Component)msg, Util.f_137441_);
            });
        }, () -> viewer.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerName).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

