/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.command.CrystalCommand;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.world.data.PersonalVaultData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PersonalVaultCommand
extends Command {
    @Override
    public String getName() {
        return "personal_vault";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"reset").executes(this::reset));
        builder.then(Commands.m_82127_((String)"resettimer").executes(this::resetTimer));
        builder.then(Commands.m_82127_((String)"addmodifier").then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CrystalCommand.SUGGEST_MODIFIER).executes(this::addModifierToInscription)));
        builder.then(Commands.m_82127_((String)"create_inscription").then(Commands.m_82129_((String)"modifiers", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(this::createInscription)));
        builder.then(Commands.m_82127_((String)"create_catalyst").then(Commands.m_82129_((String)"modifiers", (ArgumentType)IntegerArgumentType.integer((int)0, (int)5)).executes(this::createCatalyst)));
    }

    private int addModifierToInscription(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ResourceLocation modifier = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        ItemStack held = player.m_21205_();
        if (!held.m_150930_((Item)ModItems.INSCRIPTION)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Hold an inscription."));
            return 0;
        }
        Object vaultModifier = VaultModifierRegistry.get(modifier);
        if (vaultModifier == null) {
            player.m_6352_((Component)new TextComponent("Modifier not found").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        InscriptionData data = InscriptionData.from(held);
        data.addModifier(modifier);
        data.write(held);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Added modifier to inscription."), true);
        return 1;
    }

    private int reset(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PersonalVaultData.Entry entry = PersonalVaultData.getEntry(player.m_142081_());
        entry.reset();
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Vault reset."), true);
        return 1;
    }

    private int resetTimer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PersonalVaultData.Entry entry = PersonalVaultData.getEntry(player.m_142081_());
        entry.unlockTime = 0L;
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Vault reset."), true);
        return 1;
    }

    private int createInscription(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int modifiers = IntegerArgumentType.getInteger(ctx, (String)"modifiers");
        ItemStack inscription = InscriptionItem.createRandomSuperInscription(modifiers);
        if (!player.m_150109_().m_36054_(inscription)) {
            player.m_36176_(inscription, false);
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Created inscription with" + modifiers + " modifiers."), true);
        return 1;
    }

    private int createCatalyst(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int modifiers = IntegerArgumentType.getInteger(ctx, (String)"modifiers");
        ItemStack catalyst = InfusedCatalystItem.createRandomSuperCatalyst(modifiers);
        if (!player.m_150109_().m_36054_(catalyst)) {
            player.m_36176_(catalyst, false);
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Created catalyst with " + modifiers + " modifiers."), true);
        return 1;
    }
}

