/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import iskallia.vault.command.Command;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlayerDifficultyCommand
extends Command {
    private static final String COMMANDS_PREFIX = "commands.";
    private static final Dynamic2CommandExceptionType ERROR_ALREADY_DIFFICULT = new Dynamic2CommandExceptionType((playerName, vaultDifficulty) -> new TranslatableComponent("commands.the_vault.player_difficulty.failure", new Object[]{playerName, vaultDifficulty}));
    private static final DynamicCommandExceptionType ERROR_DIFFERENT_PLAYER = new DynamicCommandExceptionType(playerName -> new TranslatableComponent("commands.the_vault.player_difficulty.failure.different_player", new Object[]{playerName}));

    @Override
    public String getName() {
        return "local_difficulty";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        RequiredArgumentBuilder argument = Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_());
        for (VaultDifficulty vaultDifficulty : VaultDifficulty.values()) {
            argument.then(((LiteralArgumentBuilder)Commands.m_82127_((String)vaultDifficulty.getKey()).requires(s -> s.m_6761_(s.m_81372_().m_46469_().m_46207_(ModGameRules.NO_OP_DIFFICULTY) ? 0 : 2))).executes(ctx -> PlayerDifficultyCommand.setDifficulty((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), vaultDifficulty)));
        }
        argument.executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            VaultDifficulty vaultDifficulty = WorldSettings.get((Level)((CommandSourceStack)ctx.getSource()).m_81372_()).getPlayerDifficulty(player.m_142081_());
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.the_vault.player_difficulty.query", new Object[]{player.m_7755_(), vaultDifficulty.getDisplayName()}), false);
            return vaultDifficulty.getId();
        });
        builder.then((ArgumentBuilder)argument);
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    public static int setDifficulty(CommandSourceStack source, Player player, VaultDifficulty vaultDifficulty) throws CommandSyntaxException {
        ServerPlayer sender = source.m_81375_();
        WorldSettings worldSettings = WorldSettings.get((Level)source.m_81372_());
        if (!sender.m_20310_(4) && !sender.m_142081_().equals(player.m_142081_())) {
            throw ERROR_DIFFERENT_PLAYER.create((Object)player.m_7755_());
        }
        if (worldSettings.getPlayerDifficulty(player.m_142081_()) == vaultDifficulty) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)player.m_7755_(), (Object)vaultDifficulty);
        }
        worldSettings.setPlayerDifficulty(player.m_142081_(), vaultDifficulty);
        source.m_81354_((Component)new TranslatableComponent("commands.the_vault.player_difficulty.success", new Object[]{player.m_7755_(), vaultDifficulty.getDisplayName()}), true);
        return 0;
    }
}

