/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import iskallia.vault.config.quest.QuestConfig;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.quest.QuestDebugModeMessage;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.world.data.QuestStatesData;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;

public class QuestCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> TRUE_FALSE = (context, builder) -> SharedSuggestionProvider.m_82970_(List.of("true", "false"), (SuggestionsBuilder)builder);

    @Override
    public String getName() {
        return "quests";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"progress").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::addProgress)));
        builder.then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"enabled", (ArgumentType)StringArgumentType.word()).suggests(TRUE_FALSE).executes(this::setDebugMode)));
        builder.then(Commands.m_82127_((String)"force_skyvault").then(Commands.m_82129_((String)"enabled", (ArgumentType)StringArgumentType.word()).suggests(TRUE_FALSE).executes(this::setForceSkyVault)));
        builder.then(Commands.m_82127_((String)"reset").executes(this::reset));
    }

    private int reset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        QuestStatesData.get().getState(player).reset();
        return 1;
    }

    private int setDebugMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        boolean enabled = Boolean.parseBoolean(StringArgumentType.getString(context, (String)"enabled"));
        ModNetwork.CHANNEL.sendTo((Object)new QuestDebugModeMessage(enabled), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        return 1;
    }

    private int setForceSkyVault(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        boolean enabled = Boolean.parseBoolean(StringArgumentType.getString(context, (String)"enabled"));
        QuestStatesData.get().setForceSkyVaultWorld(enabled);
        player.m_6352_((Component)new TextComponent("Set Force Sky Vault World: " + enabled), Util.f_137441_);
        return 1;
    }

    private int addProgress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        QuestState state = QuestStatesData.get().getState(player);
        String inProgress = (String)state.getInProgress().stream().findFirst().orElseThrow();
        Optional quest = ((QuestConfig)state.getConfig(player.m_183503_())).getQuestById(inProgress);
        quest.ifPresent(q -> state.addProgress((Quest)q, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")));
        return 1;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

