/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.InvalidConfigsMessage;
import iskallia.vault.network.message.OmegaShardGlobalTradeMessage;
import iskallia.vault.network.message.ShardGlobalTradeMessage;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class ReloadConfigsCommand
extends Command {
    @Override
    public String getName() {
        return "reloadcfg";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        ((LiteralArgumentBuilder)builder.then(Commands.m_82127_((String)"gen").executes(this::reloadGenConfigs))).executes(this::reloadConfigs);
    }

    private int reloadGenConfigs(CommandContext<CommandSourceStack> context) {
        try {
            ModConfigs.registerGen();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Gen Configs reloaded!").m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }

    private int reloadConfigs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            ModConfigs.register();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        if (!ModConfigs.INVALID_CONFIGS.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ShardGlobalTradeMessage(ModConfigs.SOUL_SHARD.getTrades()));
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new OmegaShardGlobalTradeMessage(ModConfigs.OMEGA_SOUL_SHARD.getTrades()));
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss dd-MM"));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[" + timestamp + "] Configs reloaded, with errors!").m_130940_(ChatFormatting.RED), true);
            try {
                ModNetwork.CHANNEL.sendTo((Object)new InvalidConfigsMessage(ModConfigs.INVALID_CONFIGS), ((CommandSourceStack)context.getSource()).m_81375_().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                throw e;
            }
        } else {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ShardGlobalTradeMessage(ModConfigs.SOUL_SHARD.getTrades()));
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new OmegaShardGlobalTradeMessage(ModConfigs.OMEGA_SOUL_SHARD.getTrades()));
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss dd-MM"));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[" + timestamp + "] Configs reloaded!").m_130940_(ChatFormatting.GREEN), true);
        }
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

