/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.command.Command;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.network.message.UpdateTitlesDataMessage;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.BountyData;
import iskallia.vault.world.data.DiscoveredAlchemyEffectsData;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.DiscoveredTrinketsData;
import iskallia.vault.world.data.DiscoveredWorkbenchModifiersData;
import iskallia.vault.world.data.ParadoxCrystalData;
import iskallia.vault.world.data.PlayerBlackMarketData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerHistoricFavoritesData;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import iskallia.vault.world.data.PlayerProficiencyData;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.PlayerTitlesData;
import iskallia.vault.world.data.PlayerVaultAltarData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.VaultSnapshots;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class ResetCommand
extends Command {
    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetAll)));
        builder.then(Commands.m_82127_((String)"skill_points").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetSkillPoints)));
        builder.then(Commands.m_82127_((String)"prestige_points").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetPrestigePoints)));
        builder.then(Commands.m_82127_((String)"prestige_powers").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetPrestigePowers)));
        builder.then(Commands.m_82127_((String)"level_abilities_talents_and_expertises").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetLevelAbilitiesTalentsAndExpertises)));
        builder.then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetLevel)));
        builder.then(Commands.m_82127_((String)"abilities_and_talents").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetAbilitiesAndTalents)));
        builder.then(Commands.m_82127_((String)"expertises").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetExpertises)));
        builder.then(Commands.m_82127_((String)"research").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetResearch)));
        builder.then(Commands.m_82127_((String)"knowledge").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetKnowledge)));
        builder.then(Commands.m_82127_((String)"altar_recipe").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetAltarRecipe)));
        builder.then(Commands.m_82127_((String)"altar_level").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetAltarLevel)));
        builder.then(Commands.m_82127_((String)"black_market").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetBlackMarket)));
        builder.then(Commands.m_82127_((String)"vault_history").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetVaultHistory)));
        builder.then(Commands.m_82127_((String)"god_reputations").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetGodsReputation)));
        builder.then(Commands.m_82127_((String)"paradox").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetParadox)));
        builder.then(Commands.m_82127_((String)"trinkets").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetTrinkets)));
        builder.then(Commands.m_82127_((String)"bounties").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetBounties)));
        builder.then(Commands.m_82127_((String)"workbench_modifiers").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetWorkbenchModifiers)));
        builder.then(Commands.m_82127_((String)"armor_models").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetArmorModels)));
        builder.then(Commands.m_82127_((String)"alchemy_effects").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetAlchemyEffects)));
        builder.then(Commands.m_82127_((String)"ascension_titles").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetAscensionTitles)));
        builder.then(Commands.m_82127_((String)"proficiencies").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetProficiencies)));
    }

    private int resetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerAbilitiesAndTalents(player, false);
        this.resetPlayerLevel(player);
        this.resetSkillPoints(player);
        this.resetPrestigePoints(player);
        this.resetPlayerExpertises(player);
        this.resetPlayerResearch(player);
        this.resetPlayerKnowledge(player);
        this.resetPlayerAltarRecipe(player);
        this.resetPlayerAltarLevel(player);
        this.resetBlackMarket(player);
        this.resetGodReputations(player);
        this.resetParadoxProgress(player);
        this.clearPlayerTrinkets(player);
        this.clearActiveBounties(player);
        this.clearWorkbenchModifiers(player);
        this.clearArmorModels(player);
        this.clearAlchemyEffects(player);
        this.clearAscensionTitles(player);
        this.resetProficiencies(player);
        this.resetPlayerVaultHistory(player);
        this.resetPrestigePowers(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset all stats for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetLevelAbilitiesTalentsAndExpertises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerLevel(player);
        this.resetPlayerAbilitiesAndTalents(player);
        this.resetPlayerExpertises(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset level, abilities, talents and expertises for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetSkillPoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetSkillPoints(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset skill points for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetPrestigePoints(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPrestigePoints(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset prestige points for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetPrestigePowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPrestigePowers(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset prestige powers for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetPrestigePowers(ServerPlayer player) {
        PlayerPrestigePowersData data = PlayerPrestigePowersData.get(player.m_183503_());
        PrestigeTree defaultTree = (PrestigeTree)ModConfigs.PRESTIGE_POWERS.get().orElse(new PrestigeTree()).copy();
        data.setPrestige((Player)player, defaultTree);
        PlayerVaultStats stats = PlayerVaultStatsData.get(player.m_183503_()).getVaultStats((Player)player);
        stats.setPrestigePoints(defaultTree.getSpentLearnPoints());
        AttributeSnapshotHelper.getInstance().refreshSnapshotDelayed(player);
        return 1;
    }

    private int resetLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerLevel(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset level for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetAbilitiesAndTalents(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerAbilitiesAndTalents(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset abilities and talents for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetExpertises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerExpertises(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset expertises for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetResearch(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerResearch(player);
        this.resetPlayerKnowledge(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset research and knowledge for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetKnowledge(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerKnowledge(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset knowledge for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetAltarRecipe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerAltarRecipe(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset altar recipe for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetAltarLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerAltarLevel(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset altar level for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetBlackMarket(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetBlackMarket(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset black market for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetVaultHistory(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetPlayerVaultHistory(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset vault history for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetGodsReputation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetGodReputations(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset god reputations for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetParadox(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetParadoxProgress(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset paradox progress for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetTrinkets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.clearPlayerTrinkets(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset trinkets for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetBounties(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.clearActiveBounties(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset bounties for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetWorkbenchModifiers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.clearWorkbenchModifiers(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset workbench modifiers for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetArmorModels(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.clearArmorModels(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset armor models for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetAlchemyEffects(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.clearAlchemyEffects(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset alchemy effects for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetAscensionTitles(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.clearAscensionTitles(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset ascension titles for player " + player.m_6302_()), true);
        return 1;
    }

    private int resetProficiencies(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        this.resetProficiencies(player);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Reset proficiencies for player " + player.m_6302_()), true);
        return 1;
    }

    private void resetPlayerLevel(ServerPlayer player) {
        PlayerVaultStatsData.get(player.m_183503_()).setVaultLevel(player, 0);
        player.refreshTabListName();
    }

    private void resetSkillPoints(ServerPlayer player) {
        PlayerVaultStatsData.get(player.m_183503_()).resetSkillPoints(player);
    }

    private void resetPrestigePoints(ServerPlayer player) {
        PlayerVaultStatsData.get(player.m_183503_()).resetPrestigePoints(player);
    }

    private void resetPlayerAbilitiesAndTalents(ServerPlayer player) {
        this.resetPlayerAbilitiesAndTalents(player, true);
    }

    private void resetPlayerAbilitiesAndTalents(ServerPlayer player, boolean refundPoints) {
        PlayerVaultStatsData.get(player.m_183503_()).resetSkills(player, refundPoints);
    }

    /*
     * WARNING - void declaration
     */
    private void resetPlayerExpertises(ServerPlayer player) {
        try {
            PlayerVaultStatsData statsData = PlayerVaultStatsData.get(player.m_183503_());
            PlayerExpertisesData expertisesData = PlayerExpertisesData.get(player.m_183503_());
            ExpertiseTree expertisesTree = expertisesData.getExpertises((Player)player);
            PlayerVaultStats stats = statsData.getVaultStats((Player)player);
            for (Skill skill : expertisesTree.getAll(LearnableSkill.class, Skill::isUnlocked)) {
                void var7_8;
                SkillContext context = SkillContext.empty();
                Skill skill2 = skill.getParent();
                if (skill2 instanceof GroupedSkill) {
                    GroupedSkill grouped = (GroupedSkill)skill2;
                    grouped.select(skill.getId());
                    GroupedSkill groupedSkill = grouped;
                }
                if (!(var7_8 instanceof LearnableSkill)) continue;
                LearnableSkill learnable = (LearnableSkill)var7_8;
                learnable.regret(context);
                expertisesTree.sync(context);
            }
            stats.setExpertisePoints(0);
            stats.sync(player.m_183503_().m_142572_());
            statsData.m_77762_();
        }
        catch (Exception e) {
            player.m_6352_((Component)new TextComponent("Error resetting expertises. Check server logs."), player.m_142081_());
            VaultMod.LOGGER.error("Error in resetPlayerExpertises for player: " + player.m_6302_(), (Throwable)e);
        }
    }

    private void resetPlayerResearch(ServerPlayer player) {
        PlayerResearchesData.get(player.m_183503_()).resetResearchTree(player);
    }

    private void resetPlayerKnowledge(ServerPlayer player) {
        PlayerVaultStatsData.get(player.m_183503_()).resetKnowledge(player);
    }

    private void resetPlayerAltarRecipe(ServerPlayer player) {
        PlayerVaultAltarData altarData = PlayerVaultAltarData.get(player.m_183503_());
        altarData.removeRecipe(player.m_142081_());
        List<BlockPos> altars = altarData.getAltars(player.m_142081_());
        altars.stream().filter(pos -> player.m_183503_().m_46749_(pos)).map(pos -> player.m_183503_().m_7702_(pos)).filter(te -> te instanceof VaultAltarTileEntity).map(te -> (VaultAltarTileEntity)((Object)te)).filter(altar -> altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING).forEach(altar -> altar.onRemoveInput(player.m_142081_()));
        altars.stream().toList().forEach(altar -> altarData.removeAltar(player.m_142081_(), (BlockPos)altar));
        altarData.m_77762_();
    }

    private void resetPlayerAltarLevel(ServerPlayer player) {
        PlayerStatsData.get().clearCrystals(player.m_142081_());
    }

    private void resetBlackMarket(ServerPlayer player) {
        PlayerBlackMarketData.get(player.f_8924_).getBlackMarket((Player)player).resetTrades(player.m_142081_());
    }

    private void resetPlayerVaultHistory(ServerPlayer player) {
        VaultSnapshots snapshots = VaultSnapshots.get(player.f_8924_);
        List<VaultSnapshot> filteredSnapshots = VaultSnapshots.getAll().stream().filter(snapshot -> !snapshot.getEnd().get(Vault.STATS).getMap().containsKey(player.m_142081_())).toList();
        VListNBT<VaultSnapshot, LongArrayTag> snapshotsNBT = new VListNBT<VaultSnapshot, LongArrayTag>(filteredSnapshots, snapshot -> new LongArrayTag(snapshot.getCache()), nbt -> new VaultSnapshot(ArrayBitBuffer.backing(nbt.m_128851_(), 0)));
        CompoundTag data = new CompoundTag();
        data.m_128365_("snapshots", (Tag)snapshotsNBT.serializeNBT());
        snapshots.load(data);
        snapshots.m_77760_(true);
        PlayerHistoricFavoritesData favoritesData = PlayerHistoricFavoritesData.get(player.m_183503_());
        favoritesData.getPlayerMap().remove(player.m_142081_());
        favoritesData.m_77762_();
    }

    private void resetGodReputations(ServerPlayer player) {
        List<VaultGod> gods = Arrays.asList(VaultGod.IDONA, VaultGod.TENOS, VaultGod.VELARA, VaultGod.WENDARR);
        gods.forEach(god -> {
            int reputation = PlayerReputationData.getReputation(player.m_142081_(), god);
            if (reputation > 0) {
                PlayerReputationData.addReputation(player.m_142081_(), god, -reputation);
            }
        });
    }

    private void resetParadoxProgress(ServerPlayer player) {
        ParadoxCrystalData paradoxData = ParadoxCrystalData.get(player.f_8924_);
        paradoxData.getOrCreate(player.m_142081_()).reset();
        paradoxData.m_77760_(true);
    }

    private void clearPlayerTrinkets(ServerPlayer player) {
        DiscoveredTrinketsData trinketsData = DiscoveredTrinketsData.get(player.f_8924_);
        trinketsData.getDiscoveredTrinkets(player.m_142081_()).clear();
        trinketsData.m_77760_(true);
        trinketsData.syncTo(player);
    }

    private void clearActiveBounties(ServerPlayer player) {
        BountyData bountyData = BountyData.get();
        bountyData.resetAllBounties(player.m_142081_());
        bountyData.m_77760_(true);
    }

    private void clearWorkbenchModifiers(ServerPlayer player) {
        DiscoveredWorkbenchModifiersData modifiersData = DiscoveredWorkbenchModifiersData.get(player.f_8924_);
        modifiersData.resetCrafts(player.m_142081_());
        modifiersData.syncTo(player);
    }

    private void clearArmorModels(ServerPlayer player) {
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        modelsData.getDiscoveredModels(player.m_142081_()).clear();
        modelsData.m_77760_(true);
        modelsData.syncTo(player);
    }

    private void clearAlchemyEffects(ServerPlayer player) {
        DiscoveredAlchemyEffectsData alchemyData = DiscoveredAlchemyEffectsData.get(player.f_8924_);
        alchemyData.resetPlayerEffects(player.m_142081_());
        alchemyData.syncTo(player);
    }

    private void clearAscensionTitles(ServerPlayer player) {
        PlayerTitlesData titlesData = PlayerTitlesData.get();
        titlesData.entries.remove(player.m_142081_());
        titlesData.m_77760_(true);
        ModNetwork.CHANNEL.sendTo((Object)new UpdateTitlesDataMessage(titlesData.entries), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private void resetProficiencies(ServerPlayer player) {
        PlayerProficiencyData proficiencyData = PlayerProficiencyData.get(player.f_8924_);
        proficiencyData.setAbsoluteProficiency(player.m_142081_(), 0);
        proficiencyData.m_77760_(true);
        proficiencyData.sendProficiencyInformation(player);
    }
}

