/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import iskallia.vault.command.Command;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultSpectatorData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;

public class SpectateCommand
extends Command {
    @Override
    public String getName() {
        return "spectate";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::spectatePlayer))).then(Commands.m_82127_((String)"stop").executes(this::stopSpectating))).then(Commands.m_82127_((String)"next").executes(this::spectateNext));
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    private int spectatePlayer(CommandContext<CommandSourceStack> context) {
        ServerPlayer targetPlayer;
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Only players can use this command"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        SpectatorMode mode = ((SpectatorMode.GameRuleValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.SPECTATOR_MODE)).get();
        if (mode == SpectatorMode.OFF) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Spectator mode is disabled"));
            return 0;
        }
        try {
            targetPlayer = EntityArgument.m_91474_(context, (String)"player");
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Player not found"));
            return 0;
        }
        Optional<Vault> vaultOptional = ServerVaults.get((Level)targetPlayer.m_183503_());
        if (vaultOptional.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Target player is not in a vault"));
            return 0;
        }
        Vault vault = vaultOptional.get();
        boolean isRunner = vault.get(Vault.LISTENERS).getAll(Runner.class).stream().anyMatch(runner -> runner.get(Listener.ID).equals(targetPlayer.m_142081_()) && runner.isOnline());
        if (!isRunner) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Target player is not an active runner in a vault"));
            return 0;
        }
        if (player.f_8941_.m_9290_() == GameType.SPECTATOR) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("You are already in spectator mode. Use '/spectate stop' first or '/spectate next' to cycle targets"));
            return 0;
        }
        if (VaultSpectatorData.startSpectating(player, targetPlayer.m_142081_())) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("You are now spectating " + targetPlayer.m_5446_().getString()), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Failed to start spectating"));
        return 0;
    }

    private int stopSpectating(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Only players can use this command"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("You are not in spectator mode"));
            return 0;
        }
        VaultSpectatorData.stopSpectating(player.m_142081_());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Stopped spectating"), false);
        return 1;
    }

    private int spectateNext(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Only players can use this command"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("You are not in spectator mode"));
            return 0;
        }
        VaultSpectatorData data = VaultSpectatorData.get(player.m_20194_());
        if (!data.isPlayerSpectating(player.m_142081_())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("You are not spectating through the vault system"));
            return 0;
        }
        if (VaultSpectatorData.changeSpectatorTarget(player.m_142081_())) {
            UUID newTarget = data.getSpectatingTarget(player.m_142081_());
            if (newTarget != null) {
                ServerPlayer targetPlayer = player.m_20194_().m_6846_().m_11259_(newTarget);
                String targetName = targetPlayer != null ? targetPlayer.m_5446_().getString() : "Unknown Player";
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Now spectating " + targetName), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Switched spectator target"), false);
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Cannot cycle spectator target (no other active runners found)"));
        return 0;
    }
}

