/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import iskallia.vault.core.vault.TeamTaskManager;
import iskallia.vault.world.data.TeamTaskData;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;

public class TeamTasksCommand
extends Command {
    public static final SuggestionProvider<CommandSourceStack> ASSIGNED_TASKIDS = (context, builder) -> {
        TeamTaskData.get(((CommandSourceStack)context.getSource()).m_81377_()).streamAssignedTaskIds().sorted().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> TEAM_NAMES = (context, builder) -> {
        TeamTaskData.get(((CommandSourceStack)context.getSource()).m_81377_()).getTeamNames().stream().sorted().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    @Override
    public String getName() {
        return "team_tasks";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"reset_tasks").executes(this::resetTasks));
        builder.then(Commands.m_82127_((String)"refresh_task").then(Commands.m_82129_((String)"taskId", (ArgumentType)StringArgumentType.string()).suggests(ASSIGNED_TASKIDS).executes(this::refreshTask)));
        builder.then(Commands.m_82127_((String)"set_task_progress").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"teamName", (ArgumentType)StringArgumentType.string()).suggests(TEAM_NAMES).then(Commands.m_82129_((String)"taskId", (ArgumentType)StringArgumentType.string()).suggests(ASSIGNED_TASKIDS).then(Commands.m_82129_((String)"progress", (ArgumentType)IntegerArgumentType.integer()).executes(this::setTaskProgress)))).executes(this::refreshTask)));
        builder.then(Commands.m_82127_((String)"get_task_progress").then(Commands.m_82129_((String)"taskId", (ArgumentType)StringArgumentType.string()).suggests(ASSIGNED_TASKIDS).executes(this::getTaskProgress)));
    }

    private int getTaskProgress(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        String taskId = StringArgumentType.getString(ctx, (String)"taskId");
        TeamTaskData teamTaskData = TeamTaskData.get(server);
        Map<String, Number> taskProgress = teamTaskData.getTaskProgress(taskId);
        if (!taskProgress.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Task progress for " + taskId), false);
            taskProgress.forEach((teamName, progress) -> ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(teamName + ": " + String.valueOf(progress)), false));
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Task not found"), false);
        }
        return 0;
    }

    private int setTaskProgress(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        String teamName = StringArgumentType.getString(ctx, (String)"teamName");
        String taskId = StringArgumentType.getString(ctx, (String)"taskId");
        int progress = IntegerArgumentType.getInteger(ctx, (String)"progress");
        TeamTaskData teamTaskData = TeamTaskData.get(server);
        if (teamTaskData.setTaskProgress(teamName, taskId, progress, server)) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Progress set"), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Task not found"), false);
        }
        return 0;
    }

    private int refreshTask(CommandContext<CommandSourceStack> ctx) {
        String taskId;
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        if (TeamTaskManager.refreshTask(server, taskId = StringArgumentType.getString(ctx, (String)"taskId"))) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Task refreshed"), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Task not found"), false);
        }
        return 0;
    }

    private int resetTasks(CommandContext<CommandSourceStack> ctx) {
        TeamTaskManager.resetTasks(((CommandSourceStack)ctx.getSource()).m_81377_());
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Tasks reset for all teams"), false);
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

